/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import org.jwaresoftware.mcmods.lib.ModIntegration;

public final class FluidsHelper {
    private static final SPILink _noopImpl = new SPILink(){};
    private static final Map<ModIntegration, SPILink> _spiInstances = new Hashtable<ModIntegration, SPILink>(11, 0.8f);

    @Nonnull
    private static final SPILink get(@Nullable ModIntegration modid) {
        return modid == null ? _noopImpl : _spiInstances.getOrDefault((Object)modid, _noopImpl);
    }

    public static final void initFinalize(ModIntegration modid, @Nonnull SPILink overrideImpl) {
        _spiInstances.put(Objects.requireNonNull(modid), Objects.requireNonNull(overrideImpl));
    }

    public static final boolean initFinalize(ModIntegration modid, ModIntegration from_modid) {
        boolean present = _spiInstances.containsKey((Object)from_modid);
        if (present) {
            FluidsHelper.initFinalize(modid, _spiInstances.get((Object)from_modid));
        }
        return present;
    }

    public static final boolean isExtensionPresent(@Nullable ModIntegration modid) {
        return modid != null && _spiInstances.getOrDefault((Object)modid, _noopImpl) != _noopImpl;
    }

    public static final int getColorFrom(@Nullable ModIntegration modid, FluidStack stack) {
        return FluidsHelper.get(modid).getColorFrom(stack);
    }

    public static final int getColorFrom(FluidStack stack) {
        return FluidsHelper.get(ModIntegration.FORGE_LIB).getColorFrom(stack);
    }

    private FluidsHelper() {
    }

    static {
        _spiInstances.put(ModIntegration.MINECRAFT, _noopImpl);
        _spiInstances.put(ModIntegration.FORGE_LIB, _noopImpl);
    }

    public static interface SPILink {
        default public ModIntegration modid() {
            return ModIntegration.MINECRAFT;
        }

        default public int getColorFrom(FluidStack stack) {
            return 0xFFFFFF;
        }
    }
}

