/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import org.jwaresoftware.mcmods.lib.Enchants;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.lib.loot.EnchantCompatibleFunction;

public final class EnchantCompatibleWithLevelsFunction
extends EnchantCompatibleFunction {
    private static final int _OTHER_ENCHANTIBILITY = ItemTier.WOOD.func_200927_e();
    @Nullable
    final RandomValueRange _withLevels;
    @Nullable
    final EnchantCompatibleFunction.Profile _profile;
    final boolean _allowTreasure;
    final boolean _stripCurses;
    final boolean _reTitle;

    public EnchantCompatibleWithLevelsFunction(ILootCondition[] conditions, @Nullable RandomValueRange withLevels, boolean treasure, boolean strip, @Nullable EnchantCompatibleFunction.Profile profile, boolean retitle) {
        super(conditions);
        this._withLevels = withLevels;
        this._profile = profile;
        this._allowTreasure = treasure;
        this._stripCurses = strip;
        this._reTitle = retitle;
    }

    @Nonnull
    private List<EnchantmentData> buildEnchantmentList(ItemStack in, boolean isBook, @Nonnull RandomValueRange withLevels, Random rand) {
        List<Enchantment> missing;
        List<EnchantmentData> enchantments;
        int xpLevel = withLevels.func_186511_a(rand);
        ItemStack use = in;
        if (isBook) {
            use = this._profile != null ? EnchantCompatibleFunction.Profile.example(this._profile, rand) : new ItemStack((IItemProvider)Items.field_151122_aG);
        }
        if ((enchantments = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)use, (int)xpLevel, (boolean)this._allowTreasure)).isEmpty() && (missing = EnchantCompatibleWithLevelsFunction.getSpecialItemsEnchantments(use, false)) != null) {
            enchantments = EnchantCompatibleWithLevelsFunction.buildRandomList(use, _OTHER_ENCHANTIBILITY, xpLevel, this._allowTreasure, rand, missing);
        }
        return enchantments;
    }

    public ItemStack func_215859_a(ItemStack in, LootContext context) {
        ItemStack out = in;
        RandomValueRange withLevels = this._withLevels;
        if (withLevels == null) {
            float luck_factor = 3.0f * MathHelper.func_76131_a((float)context.func_186491_f(), (float)0.0f, (float)10.0f);
            float min = MathHelper.func_76131_a((float)(3.0f + luck_factor), (float)3.0f, (float)20.0f);
            float max = 20.0f + luck_factor;
            withLevels = new RandomValueRange(min, max);
        }
        boolean isBook = Whatis.isBlankBook(in.func_77973_b());
        List<EnchantmentData> enchantments = this.buildEnchantmentList(in, isBook, withLevels, context.func_216032_b());
        if (this._stripCurses) {
            Enchants.strippedOfCurses(enchantments);
        }
        if (!enchantments.isEmpty()) {
            if (isBook) {
                out = new ItemStack((IItemProvider)Items.field_151134_bR);
            }
            for (EnchantmentData edata : enchantments) {
                if (isBook) {
                    EnchantedBookItem.func_92115_a((ItemStack)out, (EnchantmentData)edata);
                    continue;
                }
                out.func_77966_a(edata.field_76302_b, edata.field_76303_c);
            }
            if (this._reTitle && isBook && this._profile != null && enchantments.size() > 1 && this._profile != EnchantCompatibleFunction.Profile.BOOK) {
                EnchantCompatibleFunction.Profile.reTitle(out, this._profile);
            }
        }
        return out;
    }

    public static class Serializer
    extends EnchantCompatibleFunction.Serializer<EnchantCompatibleWithLevelsFunction> {
        public Serializer() {
            super(LibInfo.MOD_ID(), EnchantCompatibleWithLevelsFunction.class);
        }

        public EnchantCompatibleWithLevelsFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            RandomValueRange withLevels = null;
            if (object.has("levels")) {
                withLevels = (RandomValueRange)JSONUtils.func_188174_a((JsonObject)object, (String)"levels", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            EnchantCompatibleFunction.Profile profile = EnchantCompatibleFunction.Profile.fromLString(JSONUtils.func_151219_a((JsonObject)object, (String)"profile", null));
            boolean treasureFlag = JSONUtils.func_151209_a((JsonObject)object, (String)"treasure", (boolean)false);
            boolean stripFlag = JSONUtils.func_151209_a((JsonObject)object, (String)"varnish", (boolean)false);
            boolean retitleFlag = JSONUtils.func_151209_a((JsonObject)object, (String)"retitle", (boolean)true);
            return new EnchantCompatibleWithLevelsFunction(conditions, withLevels, treasureFlag, stripFlag, profile, retitleFlag);
        }

        public void serialize(JsonObject object, EnchantCompatibleWithLevelsFunction lfunction, JsonSerializationContext serializationContext) {
            if (lfunction._profile != null && lfunction._profile != EnchantCompatibleFunction.Profile.BOOK) {
                String profile = EnchantCompatibleFunction.Profile.toLString(lfunction._profile);
                object.add("profile", serializationContext.serialize((Object)profile));
            }
            if (lfunction._withLevels != null) {
                object.add("levels", serializationContext.serialize((Object)lfunction._withLevels));
            }
            if (lfunction._allowTreasure) {
                object.add("treasure", serializationContext.serialize((Object)true));
            }
            if (lfunction._stripCurses) {
                object.add("varnish", serializationContext.serialize((Object)true));
            }
            if (!lfunction._reTitle) {
                object.add("retitle", serializationContext.serialize((Object)false));
            }
        }
    }
}

