/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.event.world.BlockEvent;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.loot.Loot;

public abstract class HarvestDropsHandlerFunction
extends LootFunction {
    protected final Consumer<BlockEvent.HarvestDropsEvent> _dropsHandler;
    protected final boolean _explosionDecay;

    protected HarvestDropsHandlerFunction(ILootCondition[] conditions, boolean decay, @Nonnull Consumer<BlockEvent.HarvestDropsEvent> dropsHandler) {
        super(conditions);
        this._dropsHandler = dropsHandler;
        this._explosionDecay = decay;
    }

    protected final ItemStack callHandler(ItemStack in, LootContext lc, boolean passthru) {
        ItemStack out = in;
        BlockPos pos = (BlockPos)lc.func_216031_c(LootParameters.field_216286_f);
        BlockState harvested = (BlockState)lc.func_216031_c(LootParameters.field_216287_g);
        if (pos != null && harvested != null) {
            ItemStack tool = (ItemStack)lc.func_216031_c(LootParameters.field_216289_i);
            int fortune = 0;
            boolean silky = false;
            if (!tool.func_190926_b()) {
                fortune = EnchantmentHelper.func_77506_a((Enchantment)SharedGlue.Enchantment_fortune, (ItemStack)tool);
                silky = EnchantmentHelper.func_77506_a((Enchantment)SharedGlue.Enchantment_silkTouch, (ItemStack)tool) > 0;
            }
            PlayerEntity player = SharedGlue.getPlayerOrNull((Entity)lc.func_216031_c(LootParameters.field_216281_a));
            BlockEvent.HarvestDropsEvent fakeevent = new BlockEvent.HarvestDropsEvent((World)lc.func_202879_g(), pos, harvested, fortune, 1.0f, NonNullList.func_191196_a(), player, silky);
            if (passthru) {
                fakeevent.getDrops().add(ItemStacks.copy(in));
            }
            try {
                this._dropsHandler.accept(fakeevent);
                if (fakeevent.getDrops().isEmpty()) {
                    out = ItemStack.field_190927_a;
                } else {
                    out = (ItemStack)fakeevent.getDrops().get(0);
                    if (this._explosionDecay) {
                        Loot.applyExplosion(out, lc);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            fakeevent = null;
        }
        return out;
    }

    protected final ItemStack callHandler(ItemStack in, LootContext lc) {
        return this.callHandler(in, lc, true);
    }
}

