/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.barter.Bartering;

public final class IfBarteringCondition
implements ILootCondition {
    @Nullable
    final ModIntegration _mod_id;

    public IfBarteringCondition(String modid) {
        this._mod_id = ModIntegration.get(modid);
    }

    public boolean test(LootContext context) {
        return Bartering.isEnabled(this._mod_id);
    }

    public static ILootCondition.IBuilder builder(String modid) {
        return () -> new IfBarteringCondition(modid);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<IfBarteringCondition> {
        public Serializer() {
            super(new ResourceLocation(LibInfo.MOD_ID(), "bartering"), IfBarteringCondition.class);
        }

        public IfBarteringCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            String mod_id = JSONUtils.func_151219_a((JsonObject)json, (String)"modid", null);
            if (LibInfo.MOD_ID().equals(mod_id)) {
                mod_id = null;
            }
            return new IfBarteringCondition(mod_id);
        }

        public void serialize(JsonObject json, IfBarteringCondition lcond, JsonSerializationContext context) {
            if (lcond._mod_id != null) {
                json.addProperty("modid", lcond._mod_id.modid());
            }
        }
    }
}

