/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import org.jwaresoftware.mcmods.lib.LibInfo;

public final class IfEntityInBiomeCondition
implements ILootCondition {
    @Nonnull
    final LootContext.EntityTarget _target_locked;
    @Nonnull
    final List<ResourceLocation> _biomes;

    public IfEntityInBiomeCondition(@Nullable LootContext.EntityTarget target, @Nonnull String[] ids) {
        this._target_locked = target != null ? target : LootContext.EntityTarget.THIS;
        this._biomes = new ArrayList<ResourceLocation>(Math.max(10, ids.length));
        for (int i = 0; i < ids.length; ++i) {
            this._biomes.add(new ResourceLocation(ids[i]));
        }
    }

    public IfEntityInBiomeCondition(String ... ids) {
        this((LootContext.EntityTarget)null, ids);
    }

    public boolean test(LootContext context) {
        ResourceLocation rb;
        Biome biome;
        Entity target = (Entity)context.func_216031_c(this._target_locked.func_216029_a());
        return target != null && (biome = target.func_130014_f_().func_226691_t_(target.func_180425_c())) != null && (rb = biome.getRegistryName()) != null && this._biomes.contains(rb);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<IfEntityInBiomeCondition> {
        private static final String _ERR_MSG = "Invalid or missing biome id(s); must be either string or array of strings.";
        private static final String _FROM = "entity";
        private static final String _TYPE = "type";

        public Serializer() {
            super(new ResourceLocation(LibInfo.MOD_ID(), "in_biome"), IfEntityInBiomeCondition.class);
        }

        public IfEntityInBiomeCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            LootContext.EntityTarget target = null;
            if (json.has(_FROM)) {
                target = (LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)_FROM, (JsonDeserializationContext)context, LootContext.EntityTarget.class);
            }
            String[] typeids = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)_TYPE)) {
                if (JSONUtils.func_151205_a((JsonObject)json, (String)_TYPE)) {
                    String key = JSONUtils.func_151200_h((JsonObject)json, (String)_TYPE);
                    typeids = new String[]{key};
                } else {
                    if (!JSONUtils.func_151202_d((JsonObject)json, (String)_TYPE)) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                    JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)_TYPE);
                    typeids = new String[jsonarray.size()];
                    int j = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        typeids[j++] = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)_TYPE);
                    }
                    if (typeids.length == 0) {
                        throw new JsonSyntaxException("Invalid biome id array; must contain at least one biome identifier.");
                    }
                }
            }
            if (typeids == null) {
                throw new JsonSyntaxException(_ERR_MSG);
            }
            return new IfEntityInBiomeCondition(target, typeids);
        }

        public void serialize(JsonObject json, IfEntityInBiomeCondition lcond, JsonSerializationContext context) {
            json.add(_FROM, context.serialize((Object)lcond._target_locked));
            if (lcond._biomes.size() == 1) {
                json.add(_TYPE, context.serialize((Object)lcond._biomes.get(0).toString()));
            } else {
                JsonArray jsonarray = new JsonArray();
                for (ResourceLocation rid : lcond._biomes) {
                    jsonarray.add(context.serialize((Object)rid.toString()));
                }
                json.add(_TYPE, (JsonElement)jsonarray);
            }
        }
    }
}

