/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.entity.Entity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class KilledByRealPlayerCondition
implements ILootCondition {
    final boolean _is_not;
    final boolean _thorough;

    public KilledByRealPlayerCondition(boolean inverse, boolean universal) {
        this._is_not = inverse;
        this._thorough = universal;
    }

    public KilledByRealPlayerCondition() {
        this(false, true);
    }

    public boolean test(LootContext context) {
        Entity e = (Entity)context.func_216031_c(LootParameters.field_216282_b);
        if (e == null && this._thorough) {
            e = (Entity)context.func_216031_c(LootParameters.field_216284_d);
        }
        boolean is = SharedGlue.isaRealNonSpectatingPlayer(e);
        return is == !this._is_not;
    }

    public static ILootCondition.IBuilder builder() {
        return () -> new KilledByRealPlayerCondition();
    }

    public static ILootCondition.IBuilder builder(boolean inverse, boolean universal) {
        return () -> new KilledByRealPlayerCondition(inverse, universal);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<KilledByRealPlayerCondition> {
        public Serializer() {
            super(new ResourceLocation(LibInfo.MOD_ID(), "killed_by_realplayer"), KilledByRealPlayerCondition.class);
        }

        public KilledByRealPlayerCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return new KilledByRealPlayerCondition(JSONUtils.func_151209_a((JsonObject)json, (String)"inverse", (boolean)false), JSONUtils.func_151209_a((JsonObject)json, (String)"any", (boolean)false));
        }

        public void serialize(JsonObject json, KilledByRealPlayerCondition lcond, JsonSerializationContext context) {
            json.addProperty("inverse", Boolean.valueOf(lcond._is_not));
            json.addProperty("any", Boolean.valueOf(lcond._thorough));
        }
    }
}

