/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import org.jwaresoftware.mcmods.lib.LibInfo;

public final class RandomChanceWithLuckCondition
implements ILootCondition {
    final float _chance;
    final float _luckMultiplier;

    public RandomChanceWithLuckCondition(float chance, float luckMultiplier) {
        this._chance = chance;
        this._luckMultiplier = luckMultiplier;
    }

    public boolean test(LootContext context) {
        float luck = context.func_186491_f();
        return context.func_216032_b().nextFloat() < this._chance + luck * this._luckMultiplier;
    }

    public static ILootCondition.IBuilder builder(float chance, float multiplier) {
        return () -> new RandomChanceWithLuckCondition(chance, multiplier);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<RandomChanceWithLuckCondition> {
        public Serializer() {
            super(new ResourceLocation(LibInfo.MOD_ID(), "random_chance_with_luck"), RandomChanceWithLuckCondition.class);
        }

        public RandomChanceWithLuckCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return new RandomChanceWithLuckCondition(JSONUtils.func_151217_k((JsonObject)json, (String)"chance"), JSONUtils.func_151217_k((JsonObject)json, (String)"luck_multiplier"));
        }

        public void serialize(JsonObject json, RandomChanceWithLuckCondition lcond, JsonSerializationContext context) {
            json.addProperty("chance", (Number)Float.valueOf(lcond._chance));
            json.addProperty("luck_multiplier", (Number)Float.valueOf(lcond._luckMultiplier));
        }
    }
}

