/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.RID;

public final class AllTagsPresentCondition
implements ICondition {
    public static final ResourceLocation NAME = LibInfo.r("tags_exist");
    final String[] _tags;

    AllTagsPresentCondition(String[] tags) {
        this._tags = tags;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        for (String tag : this._tags) {
            if (RID.isIngredientDefined(tag)) continue;
            return false;
        }
        return true;
    }

    public static final class Serializer
    implements IConditionSerializer<AllTagsPresentCondition> {
        public static final Serializer INSTANCE = new Serializer();
        private static final String _LIST = "values";

        public ResourceLocation getID() {
            return NAME;
        }

        public final AllTagsPresentCondition read(JsonObject json) {
            JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)_LIST);
            String[] tagids = new String[jsonarray.size()];
            int j = 0;
            for (JsonElement jsonelement : jsonarray) {
                tagids[j++] = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)_LIST);
            }
            if (tagids.length == 0) {
                throw new JsonSyntaxException("Invalid tags; must contain at least one value.");
            }
            return new AllTagsPresentCondition(tagids);
        }

        public final void write(JsonObject json, AllTagsPresentCondition rc) {
            JsonArray jsonarray = new JsonArray();
            for (String tag : rc._tags) {
                if (tag == null) continue;
                jsonarray.add(tag);
            }
            if (jsonarray.size() > 0) {
                json.add(_LIST, (JsonElement)jsonarray);
            }
        }
    }
}

