/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.vfp.agents.CarbonationBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.DryingAgentDispenserBehaviors;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.agents.JuJuExtensions;
import org.jwaresoftware.mcmods.vfp.agents.LavaSandFuelHandler;
import org.jwaresoftware.mcmods.vfp.agents.RennetBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.SaltBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.StarterYeast;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.milk.MilkPortion;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuildHelper;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;
import org.jwaresoftware.mcmods.vfp.sugar.HoneyPortion;
import org.jwaresoftware.mcmods.vfp.water.BucketOfPotableWater;
import org.jwaresoftware.mcmods.vfp.water.WaterBottlesBuildHelper;

public final class AgentsBuildHelper
extends VfpBuildHelperSupport {
    private WaterBottlesBuildHelper _waterHelper = new WaterBottlesBuildHelper();
    private RennetBuildHelper _rennetHelper = new RennetBuildHelper();
    private SaltBuildHelper _saltHelper = new SaltBuildHelper();
    private CarbonationBuildHelper _carbHelper = new CarbonationBuildHelper();
    private JuJuExtensions _jujuHelper = new JuJuExtensions();
    private final VfpBuildHelper[] _subBuilders = new VfpBuildHelper[5];

    public AgentsBuildHelper() {
        this._subBuilders[0] = this._waterHelper;
        this._subBuilders[1] = this._saltHelper;
        this._subBuilders[2] = this._carbHelper;
        this._subBuilders[3] = this._rennetHelper;
        this._subBuilders[4] = this._jujuHelper;
    }

    @Override
    protected String categoryName() {
        return "Additives";
    }

    @Override
    public void installEventBusHandlers(IModRuntime runtime) {
        MinecraftForge.EVENT_BUS.register((Object)new LavaSandFuelHandler());
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.installEventBusHandlers(runtime);
        }
    }

    @Override
    public void makeObjects(IModRuntime runtime) {
        VfpObj.Bit_Pipette_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Bit_Pipette);
        VfpObj.Water_Portion_obj = VfpBuilder.newAdditive(VfpOid.Portion_Water, SharedGlue.CreativeTabs_materials);
        VfpObj.Portion_Sugar_obj = VfpBuilder.newAdditive(VfpOid.Portion_Sugar);
        VfpObj.Portion_Honey_obj = new HoneyPortion();
        VfpObj.Dried_Seeds_obj = VfpBuilder.newCompostableItem(VfpOid.Dried_Seeds, 0.25f);
        VfpObj.Starter_Yeast_obj = new StarterYeast();
        VfpObj.Leavening_Agent_obj = VfpBuilder.newAdditive(VfpOid.Leavening_Agent);
        VfpObj.Leavening_Agent_Ball_obj = VfpBuilder.newAdditive(VfpOid.Leavening_Agent_Ball);
        VfpObj.Leavening_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Leavening_Agent_Pantry_Block, VfpObj.Leavening_Agent_Ball_obj);
        VfpObj.Drying_Agent_Unprocessed_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Unprocessed);
        VfpObj.Drying_Agent_Unprocessed_Ball_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Unprocessed_Ball);
        VfpObj.Drying_Agent_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent);
        VfpObj.Drying_Agent_Ball_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Ball);
        VfpObj.Drying_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Drying_Agent_Pantry_Block, VfpObj.Drying_Agent_Ball_obj);
        this._saltHelper.makeObjects(runtime);
        this._carbHelper.makeObjects(runtime);
        VfpObj.Milk_Portion_obj = new MilkPortion();
        this._rennetHelper.makeObjects(runtime);
        VfpObj.Heat_Portion_obj = VfpBuilder.newMisc(VfpOid.Portion_Heat);
        VfpObj.Lava_Sand_Portion_obj = VfpBuilder.newMisc(VfpOid.Lava_Sand);
        VfpObj.Lava_Sand_Pack_obj = VfpBuilder.newMisc(VfpOid.Pack_Lava_Sand);
        VfpObj.Lava_Sand_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Lava_Sand_Block, Blocks.field_150354_m, VfpObj.Lava_Sand_Pack_obj);
        this._waterHelper.makeObjects(runtime);
        VfpObj.Bucket_Potable_Water_obj = new BucketOfPotableWater();
        this._jujuHelper.makeObjects(runtime);
        VfpObj.Cocoa_Seedmush_obj = VfpBuilder.newCompostableItem(VfpOid.Seedmush_Cocoa, 0.35f);
        VfpObj.Raw_Caffeine_obj = VfpBuilder.newItem(VfpOid.Raw_Caffeine).setContainerItem(VfpObj.Empty_Bottle_obj);
        VfpObj.Fizzing_Agent_obj = VfpBuilder.newAdditive(VfpOid.Fizzing_Agent);
        VfpObj.Fizzing_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Fizzing_Agent_Pantry_Block, Blocks.field_150354_m, VfpObj.Fizzing_Agent_obj);
        VfpObj.Whisk_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Whisk);
        VfpObj.Rolling_Pin_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Rolling_Pin);
        VfpObj.Fermenting_Bucket_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Fermenting_Bucket);
        FoodPowder.makeObjects();
    }

    @Override
    public void makeObjectsFinalPass(IModRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.makeObjectsFinalPass(runtime);
        }
    }

    @Override
    public void linkObjects(IModRuntime runtime) {
        FoodPowder.linkObjects();
        VfpObj.Lava_Sand_BlockItem_obj = VfpObj.Lava_Sand_Block_obj.func_199767_j();
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.linkObjects(runtime);
        }
    }

    @Override
    public void linkLikeFoods(IModRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.linkLikeFoods(runtime);
        }
    }

    @Override
    public void installDeferredTasks(IModRuntime runtime) {
        DryingAgentDispenserBehaviors.register(VfpObj.Drying_Agent_obj);
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.installDeferredTasks(runtime);
        }
    }

    @Override
    public void addDictionaryEntries(IModRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.addDictionaryEntries(runtime);
        }
    }

    @Override
    public void addLootEntries(IModRuntime runtime) {
        Loot.addFishedUpJunk((String)"vanillafoodpantry", (String)VfpOid.Bit_Pipette.fmlid(), (Item)VfpObj.Bit_Pipette_obj);
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.addLootEntries(runtime);
        }
    }

    @Override
    public void setRecipeRewards(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        int additive_count = VfpCapacity.ADDITIVE_BATCH.count();
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Leavening_Agent_obj, additive_count), VfpOid.Leavening_Agent.craftingXp());
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Drying_Agent_Unprocessed_obj, additive_count), VfpOid.Drying_Agent_Unprocessed.craftingXp());
        if (config.includePotionBrewing()) {
            BrewEffect.addWaterConversionFor((Item)VfpObj.Cocoa_Seedmush_obj, (Potion)VfpPotions.STRONG_STIMULANT);
            BrewEffect.addRecipeFor((Item)VfpObj.Cocoa_Seedmush_obj, (Potion)VfpPotions.STRONG_STIMULANT);
        }
        this._waterHelper.setRecipeRewards(runtime);
        this._saltHelper.setRecipeRewards(runtime);
        this._carbHelper.setRecipeRewards(runtime);
        FoodPowder.setRecipeRewards(runtime);
        this._rennetHelper.setRecipeRewards(runtime);
        this._jujuHelper.setRecipeRewards(runtime);
    }

    @Override
    public void sendApiMessages(IModRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.sendApiMessages(runtime);
        }
    }

    @Override
    public void finish(IModRuntime runtime) {
        FoodPowder.finishConfigFinally(runtime);
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.finish(runtime);
        }
    }
}

