/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Misc;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class FoodPowder
extends VfpPantryMultiItem
implements FoodColor,
IVariant {
    static final int MAX_POWDERS_PER_USAGE = 200;
    static final int NUM_RESERVED_SLOTS = 64;
    public static final int _NONE = 0;
    public static final int _DRINK = 1;
    public static final int _BREAD = 16;
    public static final int _COOKIE = 256;
    public static final int _SOUP = 4096;
    public static final int _COLOR = 65536;
    public static final int _SEASON = 0x100000;
    static VfpVariant[] VARIANT_ARRAY;
    private static FoodPowder[] INSTANCES;
    private static ItemStack[] TYPED_INSTANCES;
    private static boolean _UNCONDITIONAL_SHOWALL;

    public static final int[] getReservedIngredientIdRange() {
        return new int[]{Usage.DRINK_FLAVOR.idFirst(), Usage.OTHER.idLast()};
    }

    FoodPowder(VfpVariant variant) {
        super((VfpProfile)VfpOid.FoodPowder, false, variant);
        this.inGroup("foodpowders");
        this.autoregister();
    }

    @Override
    public final float getCompostChance() {
        return 0.25f;
    }

    @Override
    public boolean isHiddenByDefault() {
        return super.isHiddenByDefault() || FoodPowder.isHiddenByDefault(this._variant.datadata(Type.class));
    }

    public static final boolean isHiddenByDefault(Type type) {
        return _UNCONDITIONAL_SHOWALL ? false : !type.isCraftable();
    }

    public String varid() {
        return this._variant.datadata(Type.class).name_lowercased();
    }

    @Override
    public int color(ItemStack stack) {
        Integer color = this._variant.datadata(Type.class).colorValue();
        return color != null ? color : 0xF1F1F1;
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(TYPED_INSTANCES.length + 2);
        for (ItemStack powder : TYPED_INSTANCES) {
            all.add(powder.func_77946_l());
        }
        return all;
    }

    public static final void makeObjects() {
        if (INSTANCES == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(113);
            String basename = VfpOid.FoodPowder.fmlid();
            List<Type> typeDefs = Type.orderedValues();
            for (Type type : typeDefs) {
                String fmlid = basename + "_" + type.name().toLowerCase(Locale.US);
                variants.add(new VfpTransientVariant(variants.size(), type.meta(), fmlid, null, type, null));
                if (type != Type.FILLER && type != Type.WATER) continue;
                type.setUncraftable();
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCES = new FoodPowder[VARIANT_ARRAY.length];
            for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
                FoodPowder.INSTANCES[i] = new FoodPowder(VARIANT_ARRAY[i]);
            }
        }
    }

    public static final void linkObjects() {
        if (INSTANCES != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(71);
            for (FoodPowder foodpowder : INSTANCES) {
                ItemStack a_powder = foodpowder.createInstance((Item)foodpowder, 1);
                instances.add(a_powder);
            }
            TYPED_INSTANCES = instances.toArray(ItemStacks.EMPTY_ARRAY);
        }
    }

    private static final void detectUncraftableFoodPowders(VfpConfig config) {
        if (!Type.PEPPERCORN.isCraftable()) {
            Type.STEW_MIX.setUncraftable();
            Type.PICKLING_MIX.setUncraftable();
        }
        if (!Type.CELERY.isCraftable() || !Type.GARLIC.isCraftable()) {
            Type.STEW_MIX.setUncraftable();
        }
        if (!Type.COFFEEBEAN.isCraftable()) {
            Type.MOCHA_MIX.setUncraftable();
        }
        if (!RID.isIngredientDefined((String)"foods/citrus_fruits")) {
            Type.CITRUS_MIX.setUncraftable();
        }
        for (FoodPowder foodpowder : INSTANCES) {
            Type type = foodpowder._variant.datadata(Type.class);
            if (type.isCraftable()) {
                config.setPresent(type.name_lowercased());
                continue;
            }
            config.setNotPresent(type.name_lowercased());
        }
    }

    private static final void rewardGelatinPowder(VfpConfig config) {
        VfpRewards.addRewardingCraftItem(FoodPowder._copy(Type.GELATIN, 2), LikeFood.bone.craftExperience());
    }

    private static final void rewardBuiltinMixes(VfpConfig config) {
        ItemStack mix_powder = FoodPowder._copy(Type.BATTER_MIX, 3);
        VfpRewards.addRewardingCraftItem(mix_powder, OneXp.Per10.value());
        mix_powder = FoodPowder._copy(Type.JERKY_RUB, 6);
        VfpRewards.addRewardingCraftItem(mix_powder, OneXp.Per10.value());
        mix_powder = FoodPowder._copy(Type.STEW_MIX, 6);
        VfpRewards.addRewardingCraftItem(mix_powder, OneXp.Per06.value());
        mix_powder = FoodPowder._copy(Type.CITRUS_MIX, 6);
        VfpRewards.addRewardingCraftItem(mix_powder, OneXp.Per06.value());
        mix_powder = FoodPowder._copy(Type.MOCHA_MIX, 6);
        VfpRewards.addRewardingCraftItem(mix_powder, OneXp.Per10.value());
    }

    private static final void rewardCompounds(VfpConfig config) {
        VfpRewards.addRewardingCraftItem(FoodPowder._copy(Type.SYRUP, 1), OneXp.Per10.value());
        VfpRewards.addRewardingCraftItem(FoodPowder._copy(Type.FEATHER, 1), OneXp.Per08.value());
        VfpRewards.addRewardingCraftItem(FoodPowder._copy(Type.MUSCLE_MIX, 1), OneXp.Per03.value());
        VfpRewards.addRewardingCraftItem(FoodPowder._copy(Type.BUSHTEA, 3), OneXp.Per02.value());
        VfpRewards.addRewardingCraftItem(FoodPowder._copy(Type.DANDTEA, 3), OneXp.Per02.value());
        VfpRewards.addRewardingCraftItem(FoodPowder._copy(Type.FLOWERPOWER, 2), OneXp.Per03.value());
        VfpRewards.addRewardingCraftItem(FoodPowder._copy(Type.VINEGAR, VfpCapacity.ADDITIVE_BATCH.count()), OneXp.Per03.value());
        VfpRewards.addRewardingCraftItem(FoodPowder._copy(Type.UGLI_FRUIT, 3), OneXp.Per08.value());
    }

    private static final void autorecipeBrewingReactants(VfpConfig config) {
        if (config.includePotionBrewing()) {
            BrewEffect.addRecipeFor((Item)INSTANCES[Type.FLOWERPOWER.ordinal()], (Potion)SharedGlue.PotionType_luck);
            BrewEffect.addConversionFor((Potion)SharedGlue.PotionType_luck, (Item)INSTANCES[Type.FLOWERPOWER.ordinal()], (Potion)VfpPotions.SUPER_GOOD_JUJU);
            BrewEffect.addConversionFor((Potion)SharedGlue.PotionType_luck, (Item)VfpObj.Fermented_Feather_obj, (Potion)VfpPotions.BADD_JUJU);
            BrewEffect.addConversionFor((Potion)SharedGlue.PotionType_luck, (Item)Items.field_151071_bq, (Potion)VfpPotions.BADD_JUJU);
        }
    }

    static final void setRecipeRewards(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        FoodPowder.rewardGelatinPowder(config);
        FoodPowder.rewardCompounds(config);
        FoodPowder.rewardBuiltinMixes(config);
        FoodPowder.autorecipeBrewingReactants(config);
    }

    static final void finishConfigFinally(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        _UNCONDITIONAL_SHOWALL = config.showAllItemsInUI();
        FoodPowder.detectUncraftableFoodPowders(config);
    }

    private static final ItemStack _copy(Type powder, int amount) {
        assert (TYPED_INSTANCES != null);
        return ItemStacks.copy((ItemStack)TYPED_INSTANCES[powder.ordinal()], (int)amount);
    }

    private static final ItemStackDef _copydef(Type powder, int amount) {
        assert (INSTANCES != null);
        return new ItemStackDef((Item)INSTANCES[powder.ordinal()], amount);
    }

    @Nullable
    public static final Ingredient toIngredient(Type powder, int amount, Usage usage, String preferredName) {
        Ingredient ingredient = null;
        if (powder != null) {
            if (usage == null) {
                usage = Usage.OTHER;
            }
            if (preferredName == null) {
                preferredName = powder.name_lowercased();
            }
            boolean metaCheck = powder.meta() >= 0 && powder.meta() < 200;
            Validate.validState((boolean)metaCheck, (String)"A food powder's meta value MUST be between 0 and %d exclusive", (Object[])new Object[]{200});
            ingredient = new Ingredient(preferredName, usage.idLast() - powder.meta(), FoodPowder._copydef(powder, amount));
            ingredient.setEnabled(() -> powder.isCraftable());
        }
        return ingredient;
    }

    @Nullable
    public static final Ingredient toIngredient(Type powder, Usage usage, String preferredName) {
        return FoodPowder.toIngredient(powder, 1, usage, preferredName);
    }

    @Nullable
    public static final Ingredient toIngredient(@Nullable Type powder, int id, @Nullable String preferredName) {
        Ingredient ingredient = null;
        if (powder != null) {
            if (preferredName == null) {
                preferredName = powder.name_lowercased();
            }
            ingredient = new Ingredient(preferredName, id, FoodPowder._copydef(powder, 1));
        }
        return ingredient;
    }

    @Nullable
    public static final ItemStack get(@Nullable Type powder, int amount) {
        ItemStack item = null;
        if (powder != null) {
            item = FoodPowder._copy(powder, amount);
        }
        return item;
    }

    @Nullable
    public static final ItemStackDef getDef(@Nullable Type powder, int amount) {
        ItemStackDef defn = null;
        if (powder != null) {
            defn = FoodPowder._copydef(powder, amount);
        }
        return defn;
    }

    @Nullable
    public static final Type findType(@Nonnull String name) {
        return Type._VALUES.get(name.toUpperCase());
    }

    @Nonnull
    public static final Type findTypeOrFiller(@Nonnull String name) {
        Type hit = FoodPowder.findType(name);
        return hit == null ? Type.FILLER : hit;
    }

    static {
        _UNCONDITIONAL_SHOWALL = false;
    }

    public static final class Type
    implements Comparable<Type> {
        static int _NEXT_ORDINAL = 0;
        static final Map<String, Type> _VALUES = new HashMap<String, Type>(231);
        static final String _UNUSED = "unused";
        public static final Type SYRUP = new Type("SYRUP", new Ingredient("fpt_syrup", 0, new ItemStackDef(Items.field_151102_aT), 2), 1, true, (Integer)171775);
        public static final Type COCOA = new Type("COCOA", new Ingredient("fpt_cocoa", 0, new ItemStackDef(Items.field_196130_bo), 2), 65793, true, (Integer)8931339);
        public static final Type APPLE = new Type("APPLE", new Ingredient("fpt_apple", 0, "foods/apples", 1, 2), 273, true, (Integer)16774112);
        public static final Type PUMPKIN = new Type("PUMPKIN", new ItemStackDef(Blocks.field_150423_aK, 4), 4368, true, (Integer)16768161);
        public static final Type MELON = new Type("MELON", new ItemStackDef(Blocks.field_150440_ba, 4), 1, true, SharedGlue.MapColor_PINK);
        public static final Type CARROT = new Type("CARROT", new ItemStackDef(Items.field_151172_bF, 2), 69649, true, (Integer)16748827);
        public static final Type DANDELION = new Type("DANDELION", new ItemStackDef(Items.field_221619_aU), 65537, true, (Integer)16574754);
        public static final Type CACTUS = new Type("CACTUS", new ItemStackDef(Blocks.field_150434_aF, 4), 69889, true, SharedGlue.MapColor_LIME);
        public static final Type KELP = new Type("KELP", new Ingredient("fpt_kelp", 0, "unused"), 65536, true, (Integer)SharedGlue.MapColor_GREEN.field_76291_p);
        public static final Type POPPY = new Type("POPPY", new ItemStackDef(Items.field_221620_aV), 65537, true, (Integer)0xFF0000);
        public static final Type MILK = new Type("MILK", new Ingredient("fpt_milk", 0, "carrots:portions_large_milk", 4, 1), 1, true, (Integer)0xFFFFDD);
        public static final Type POTATO = new Type("POTATO", new ItemStackDef(Items.field_151174_bG, 2), 4112, true, (Integer)16775636);
        public static final Type EGG = new Type("EGG", new Ingredient("fpt_egg", 0, "carrots:portions_raw_egg"), 16, true, (Integer)0xFFFF8C);
        public static final Type INK = new Type("INK", new ItemStackDef(Items.field_196136_br), 65537, true, (Integer)SharedGlue.MapColor_BLACK.field_76291_p);
        public static final Type INK_KELP = new Type("INK_KELP", new Ingredient("fpt_inkkelp", 0, "unused"), 65536, true, (Integer)SharedGlue.MapColor_BLACK.field_76291_p);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Ingredient("fpt_shroom", 0, "foods/raw_mushrooms"), 4096, true, (Integer)11306333);
        public static final Type ROSE = new Type("ROSE", new Ingredient("fpt_rose", 0, "foods/flowers/roses"), 65536, true, (Integer)SharedGlue.MapColor_RED.field_76291_p);
        public static final Type GELATIN = new Type("GELATIN", new ItemStackDef(Items.field_151103_aS, 2), 0, true);
        public static final Type CHEESE = new Type("CHEESE", new Ingredient("fpt_cheez", 0, "foods/cheeses"), 4112, true, (Integer)16772518);
        public static final Type FEATHER = new Type("FEATHER", new ItemStackDef(Items.field_151008_G), 0, true);
        public static final Type MUSCLE_MIX = new Type("MUSCLE_MIX", new Ingredient("fpt_muscle", 0, "unused"), 0, true, (Integer)3419182);
        public static final Type BUSHTEA = new Type("BUSHTEA", new Ingredient("fpt_bushtea", 0, "unused"), 65536, true, (Integer)6585650);
        public static final Type DANDTEA = new Type("DANDTEA", new Ingredient("fpt_dandtea", 0, "unused"), 0, true, (Integer)13873231);
        public static final Type CREAM = new Type("CREAM", new Ingredient("fpt_cream", 0, "unused"), 0, true, (Integer)15128708);
        public static final Type VINEGAR = new Type("VINEGAR", new Ingredient("fpt_vinegar", 0, "unused"), 0, true, null);
        public static final Type FILLER = new Type("CLEAR", new Ingredient("fpt_filler", 0, "unused"), 0, false, null);
        public static final Type BATTER_MIX = new Type("BATTER_MIX", new Ingredient("fpt_battermix", 0, "unused"), 0x100000, true, null);
        public static final Type JERKY_RUB = new Type("JERKY_MIX", new Ingredient("fpt_jerkymix", 0, "unused"), 0x100000, true, null);
        public static final Type POTATO_STARCH = new Type("POTATO_STARCH", new Ingredient("fpt_starch", 0, "unused"), 0, true, null);
        public static final Type BEET = new Type("BEET", new Ingredient("fpt_beet", 0, "foods/beets", 1, 2), 69632, true, (Integer)12612474);
        public static final Type CHORUSFRUIT = new Type("CHORUSFRUIT", new Ingredient("fpt_chorus", 0, new ItemStackDef(Items.field_185161_cS), 1), 65537, true, (Integer)7887224);
        public static final Type FLOWERPOWER = new Type("PINKFLOWERS", new Ingredient("fpt_flower", 0, "unused"), 65536, true, (Integer)SharedGlue.MapColor_PINK.field_76291_p);
        public static final Type UGLI_FRUIT = new Type("UGLI", new Ingredient("fpt_ugli", 0, "unused"), 0, true, (Integer)15921735);
        public static final Type SUNFLOWER_SEEDS = new Type("SUNFLOWER_SEEDS", new Ingredient("fpt_sunflower", 0, "unused"), 0, true, null);
        public static final Type SUNBUTTER_MIX = new Type("SUNBUTTER_MIX", new Ingredient("fpt_sunbuttmix", 0, "unused"), 0, true, null);
        public static final Type HONEY = new Type("HONEY", new Ingredient("fpt_honey", 0, new ItemStackDef(Items.field_226638_pX_, 3), 1), 0, true, null);
        public static final Type XYLITOL = new Type("XYLITOL", new Ingredient("fpt_xylitol", 0, "unused"), 0, true, null);
        public static final Type WATER = new Type("WATER", new Ingredient("fpt_water", 0, "unused"), 0, true, null);
        public static final Type STRAWBERRY = new Type("strawberry", new Ingredient("fpt_strbery", 0, "foods/strawberries", 1, 2), 1, false, (Integer)0xDD6161);
        public static final Type BLUEBERRY = new Type("blueberry", new Ingredient("fpt_blubery", 0, "foods/blueberries", 1, 3), 1, false, (Integer)6384842);
        public static final Type PEANUTS = new Type("peanuts", new Ingredient("fpt_peanut", 0, "foods/peanuts", 1, 3), 0, false, (Integer)12816928);
        public static final Type MANGO = new Type("mango", new Ingredient("fpt_mango", 0, "foods/mangoes", 2, 1), 1, false, (Integer)16759296);
        public static final Type PINEAPPLE = new Type("pineapple", new Ingredient("fpt_pinaple", 0, "foods/whole_pineapples", 4, 1), 1, false, (Integer)16769875);
        public static final Type COCONUT = new Type("coconut", new Ingredient("fpt_conut", 0, "foods/whole_coconuts", 2, 1), 0, false, null);
        public static final Type PEPPERCORN = new Type("peppercorn", new Ingredient("fpt_blkpepr", 0, "seeds/peppercorn", 1, 3), 0x100000, false, null);
        public static final Type ONION = new Type("onion", new Ingredient("fpt_onion", 0, "foods/onions"), 0x100000, false, null);
        public static final Type LEEK = new Type("leek", new Ingredient("fpt_leek", 0, "foods/leeks"), 0x101000, false, (Integer)15859668);
        public static final Type TOMATO = new Type("tomato", new Ingredient("fpt_tomato", 0, "foods/tomatoes", 1, 2), 4096, false, (Integer)14111549);
        public static final Type CELERY = new Type("celery", new Ingredient("fpt_celery", 0, "foods/whole_celery"), 0x100000, false, null);
        public static final Type GARLIC = new Type("garlic", new Ingredient("fpt_garlic", 0, "foods/whole_garlic"), 0x100000, false, null);
        public static final Type COFFEEBEAN = new Type("coffee", new Ingredient("fpt_koffee", 0, "seeds/coffee_bean", 1, 3), 0, false, null);
        public static final Type BOUILLON = new Type("bouillon", new Ingredient("fpt_bouilon", 0, "unused"), 0x100000, true, null);
        public static final Type STEW_MIX = new Type("stew_mix", new Ingredient("fpt_stewmix", 0, "unused"), 0x100000, false, null);
        public static final Type CITRUS_MIX = new Type("citrus_mix", new Ingredient("fpt_citrus", 0, "foods/limes"), 1, false, (Integer)13563136);
        public static final Type MOCHA_MIX = new Type("mocha_mix", new Ingredient("fpt_mocha", 0, "unused"), 0, false, (Integer)7289344);
        public static final Type BERRY_MIX = new Type("berry_mix", new Ingredient("fpt_berry", 0, "unused"), 1, true, (Integer)13241050);
        public static final Type PICKLING_MIX = new Type("pickling_mix", new Ingredient("fpt_picklin", 0, "unused"), 0x100000, false, null);
        private final String _name;
        private final int _ordinal;
        private final int _meta;
        private boolean _vanillaFlag;
        private final Ingredient _item;
        private final int _uses;
        private final Integer _colorValue;

        public static final Collection<Type> values() {
            return Collections.unmodifiableCollection(_VALUES.values());
        }

        Type(int id, String name, Ingredient item, int uses, boolean vanilla, Integer colorValue) {
            this._name = name = name.toUpperCase(Locale.US);
            this._ordinal = _NEXT_ORDINAL++;
            this._meta = id < 0 ? this._ordinal : id;
            this._item = item;
            this._uses = uses;
            this._vanillaFlag = vanilla;
            this._colorValue = colorValue;
            _VALUES.put(name, this);
        }

        Type(String name, Ingredient item, int uses, boolean vanilla, Integer colorValue) {
            this(-1, name, item, uses, vanilla, colorValue);
        }

        public Type(String name, ItemStackDef item, int uses, boolean vanilla, Integer colorValue) {
            this(-1, name, new Ingredient("fpt_unused", 0, item), uses, vanilla, colorValue);
        }

        Type(String name, ItemStackDef item, int uses, boolean vanilla, MaterialColor color) {
            this(name, item, uses, vanilla, (Integer)color.field_76291_p);
        }

        public Type(String name, ItemStackDef item, int uses, int multiplier, boolean vanilla, Integer colorValue) {
            this(name, new Ingredient("fpt_unused", 0, item, multiplier), uses, vanilla, colorValue);
        }

        public Type(String name, ItemStackDef item, int uses, boolean vanilla) {
            this(name, new Ingredient("fpt_unused", 0, item), uses, vanilla, null);
        }

        public final String name() {
            return this._name;
        }

        public final String name_lowercased() {
            return this.name().toLowerCase(Locale.US);
        }

        public final int ordinal() {
            return this._ordinal;
        }

        public final int meta() {
            return this._meta;
        }

        Ingredient item() {
            return this._item;
        }

        public boolean isBreadFlavor() {
            return (this._uses & 0x10) == 16;
        }

        public boolean isDrinkFlavor() {
            return (this._uses & 1) == 1;
        }

        public boolean isSoupFlavor() {
            return (this._uses & 0x1000) == 4096;
        }

        public boolean isCookieFlavor() {
            return (this._uses & 0x100) == 256;
        }

        public boolean isSeasoningFlavor() {
            return (this._uses & 0x100000) == 0x100000;
        }

        public boolean isColorer() {
            return this._colorValue != null && (this._uses & 0x10000) == 65536;
        }

        public Integer colorValue() {
            return this._colorValue;
        }

        public boolean isAlwaysPresent() {
            return this._vanillaFlag;
        }

        public void setUncraftable() {
            this._item.setEnabled(Misc.ALWAYS_FALSE);
        }

        public boolean isCraftable() {
            return this != FILLER && this != WATER && (this.isAlwaysPresent() || this._item.isEnabled());
        }

        public boolean isCraftableOrForceShown(boolean flag) {
            return flag || this.isCraftable();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.name()).append("|").append(this.meta()).append("|").append(this._uses).append("|").append(this.colorValue());
            return sb.toString();
        }

        public boolean equals(Object o) {
            return o == null ? false : (o instanceof Type ? ((Type)o)._meta == this._meta : false);
        }

        public int hashCode() {
            return this._meta + this._name.hashCode();
        }

        @Override
        public int compareTo(Type o) {
            if (o == null) {
                return 1;
            }
            if (o == this) {
                return 0;
            }
            return this._ordinal > o._ordinal ? 1 : (this._ordinal < o._ordinal ? -1 : 0);
        }

        public static final List<Type> orderedValues() {
            ArrayList<Type> list = new ArrayList<Type>(_VALUES.values());
            Collections.sort(list);
            return list;
        }
    }

    public static enum Usage {
        DRINK_FLAVOR(400),
        BREAD_FLAVOR(DRINK_FLAVOR.idLast() + 200),
        COOKIE_FLAVOR(BREAD_FLAVOR.idLast() + 200),
        SOUP_FLAVOR(COOKIE_FLAVOR.idLast() + 200),
        COLORING(SOUP_FLAVOR.idLast() + 200),
        SEASONING_FLAVOR(COLORING.idLast() + 200),
        OTHER(SEASONING_FLAVOR.idLast() + 200);

        private final int _offset;

        private Usage(int offset) {
            this._offset = offset;
        }

        public int idLast() {
            return this._offset;
        }

        public int idFirst() {
            return this._offset - 200 + 1;
        }
    }
}

