/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Food;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.vfp.common.ItemHandle;
import org.jwaresoftware.mcmods.vfp.common.Named;
import org.jwaresoftware.mcmods.vfp.common.OneXp;

public final class LikeFood
implements Named {
    public static final Item NO_PROTOTYPE = null;
    public static final float DEFAULT_SATURATION_MODIFIER = 0.6f;
    public static final float NO_SMELT_XP = -1.0f;
    public static final OneXp NO_CRAFT_XP = null;
    public static final float DEFAULT_BUCKET_SMELT_XP = 1.0f;
    public static final LikeFood air = new LikeFood("air", 0, 0.0f, NO_PROTOTYPE, true);
    public static final LikeFood crumb = new LikeFood("crumb", 1, 0.05f, NO_PROTOTYPE, true);
    public static final LikeFood water = new LikeFood("water", 1, 0.05f, Items.field_151068_bn, false);
    public static final LikeFood flavored_water = new LikeFood("flav_water", 2, 0.05f, Items.field_151068_bn, false);
    public static final LikeFood bone = new LikeFood("bone", 0, 0.0f, 0.25f, OneXp.Per06, Items.field_151103_aS, true);
    public static final LikeFood cake_slice = new LikeFood("", 4, 0.3f, NO_PROTOTYPE, false);
    public static final LikeFood cake = new LikeFood("cake", 12, 0.1f, -1.0f, Items.field_222070_lD, true);
    public static final LikeFood cookie = new LikeFood("cookie", 2, 0.1f, Items.field_151106_aX, true);
    public static final LikeFood raw_seed = new LikeFood("rawseed", 1, 0.05f, 0.030625f, OneXp.Per16, NO_PROTOTYPE, true);
    public static final LikeFood seed = new LikeFood("seed", 2, 0.05f, -1.0f, OneXp.Per16, NO_PROTOTYPE, true);
    public static final LikeFood acorn_nuts = new LikeFood("acornuts", 5, 0.4f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood honey_acorn_nuts = new LikeFood("acornuts", 6, 0.5f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood wheat = new LikeFood("wheat", 0, -1.0f, Items.field_151015_O, true);
    public static final LikeFood apple = new LikeFood("apple", 4, 0.3f, 0.1f, Items.field_151034_e, true);
    public static final LikeFood dried_apple = new LikeFood("dried_apple", -1, apple, apple);
    public static final LikeFood melon_slice = new LikeFood("mslice", 2, 0.3f, Items.field_221794_dg, true);
    public static final LikeFood golden_apple = new LikeFood("gold_aple", 4, 1.2f, Items.field_151153_ao, true);
    public static final LikeFood golden_carrot = new LikeFood("gold_carot", 6, 1.2f, Items.field_151150_bK, true);
    public static final LikeFood pumpkin_pie = new LikeFood("pumpkinpie", 8, 0.3f, Items.field_151158_bO, true);
    public static final LikeFood enriched_dessert_pie = new LikeFood("dessertpie", 32, 0.7f, 0.3f, NO_PROTOTYPE, false);
    public static final LikeFood chorus_fruit = new LikeFood("chorusfruit", 4, 0.3f, 0.1f, Items.field_185161_cS, true);
    public static final LikeFood sweet_berries = new LikeFood("swt_berry", 2, 0.1f, 0.030625f, Items.field_222112_pR, true);
    public static final LikeFood raftugli_fruit = new LikeFood("raftugli", 4, 0.2f, -1.0f, NO_CRAFT_XP, NO_PROTOTYPE, false);
    public static final LikeFood mixed_berries = new LikeFood("berries", 7, 0.3f, 0.1f, NO_CRAFT_XP, NO_PROTOTYPE, false);
    public static final LikeFood golden_berries = new LikeFood("gold_bery", 7, 1.2f, NO_PROTOTYPE, false);
    public static final LikeFood honey_bottle = new LikeFood("honey", 6, 0.4f, Items.field_226638_pX_, true);
    public static final LikeFood honeycomb = new LikeFood("honeycmb", 2, 0.3f, NO_PROTOTYPE, true);
    public static final LikeFood muscle_boost = new LikeFood("muscle", 3, 0.2f, -1.0f, NO_CRAFT_XP, NO_PROTOTYPE, false).setEnhancer();
    public static final LikeFood bread = new LikeFood("bread", 5, 0.6f, 0.3f, Items.field_151025_P, true);
    public static final LikeFood flouronly_bread = new LikeFood("_bread", 0, bread).setCraftExperience(OneXp.Per08.value());
    public static final LikeFood french_bread = new LikeFood("french_bread", 7, 0.6f, 0.3f, Items.field_151025_P, false).setCraftExperience(OneXp.Per08.value());
    public static final LikeFood enriched_bread = new LikeFood("enriched_bread", 10, 0.7f, 0.3f, OneXp.Per05, Items.field_151025_P, false);
    public static final LikeFood mini_bread = new LikeFood("roll", 3, 0.6f, 0.15f, OneXp.Per08, NO_PROTOTYPE, false);
    public static final LikeFood mini_bread_halved = new LikeFood("half_roll", 2, 0.6f, 0.15f, OneXp.Per08, NO_PROTOTYPE, false);
    public static final LikeFood sandwich = new LikeFood("sandwich_breadslices", 2, 0.6f, -1.0f, OneXp.Per06, NO_PROTOTYPE, false);
    public static final LikeFood sandwich_bread = new LikeFood("sandwich_bread", 18, 0.85f, 0.35f, OneXp.Per04, Items.field_151025_P, false);
    public static final LikeFood specialty_bread = new LikeFood("specialty_bread", 14, 0.75f, 0.35f, OneXp.Per04, Items.field_151025_P, false);
    public static final LikeFood muffin = new LikeFood("muffin", 5, 0.5f, 0.15f, OneXp.Per06, NO_PROTOTYPE, false);
    public static final LikeFood bread_pocket = new LikeFood("pocket", 2, 0.5f, NO_PROTOTYPE, false);
    public static final LikeFood apple_pie = new LikeFood("applepie", -1, apple, apple, apple, muffin);
    public static final LikeFood golden_apple_pie = new LikeFood("gapplepie", apple_pie.healAmount(), 1.2f, NO_PROTOTYPE, false);
    public static final LikeFood berry_pie = new LikeFood("berrypie", -1, mixed_berries, mixed_berries, mixed_berries, muffin);
    public static final LikeFood condiment = new LikeFood("condiment", 1, 0.05f, NO_PROTOTYPE, false);
    public static final LikeFood combo_boost1 = new LikeFood("+meal1", 0, 0.1f, -1.0f, NO_CRAFT_XP, NO_PROTOTYPE, false).setEnhancer();
    public static final LikeFood combo_boost2 = new LikeFood("+meal2", 0, 0.2f, -1.0f, NO_CRAFT_XP, NO_PROTOTYPE, false).setEnhancer();
    public static final LikeFood combo_boost3 = new LikeFood("+meal3", 3, 0.0f, -1.0f, NO_CRAFT_XP, NO_PROTOTYPE, false).setEnhancer();
    public static final LikeFood effort_boost1 = new LikeFood("+meal4", 1, 0.1f, -1.0f, NO_CRAFT_XP, NO_PROTOTYPE, false).setEnhancer();
    public static final LikeFood effort_boost2 = new LikeFood("+meal5", 2, 0.1f, -1.0f, NO_CRAFT_XP, NO_PROTOTYPE, false).setEnhancer();
    public static final LikeFood golden_boost = new LikeFood("+gold", 0, 0.3f, -1.0f, NO_CRAFT_XP, NO_PROTOTYPE, false).setEnhancer();
    public static final LikeFood golden_beetroots = new LikeFood("gold_beets", 6, 0.85f, NO_PROTOTYPE, false);
    public static final LikeFood carrot = new LikeFood("carrot", 2, 0.6f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_carrot = new LikeFood("u_carrot", 3, 0.6f, 0.1f, Items.field_151172_bF, true);
    public static final LikeFood potato = new LikeFood("potato", Foods.field_221426_b.func_221466_a(), Foods.field_221426_b.func_221469_b(), Items.field_151168_bH, true);
    public static final LikeFood uncooked_potato = new LikeFood("u_potato", 1, 0.3f, 0.3f, Items.field_151174_bG, true);
    public static final LikeFood half_potato = new LikeFood("halfpotato", 3, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood bad_potato = new LikeFood("bad_potato", 2, 0.3f, Items.field_151170_bI, true);
    public static final LikeFood fries = new LikeFood("fries", 3, 0.5f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_mushroom = new LikeFood("ubrw_shroom", 2, 0.3f, 0.04375f, Items.field_221692_bh, true);
    public static final LikeFood mushroom = new LikeFood("brw_shroom", 2, 0.3f, -1.0f, Items.field_221692_bh, true);
    public static final LikeFood red_mushroom = new LikeFood("red_shroom", 2, 0.3f, -1.0f, Items.field_221694_bi, true);
    public static final LikeFood uncooked_beetroot = new LikeFood("u_beet", 1, 0.6f, 0.045f, Items.field_185164_cV, true);
    public static final LikeFood chicken = new LikeFood("chikin", 6, 0.6f, -1.0f, Items.field_151077_bg, true);
    public static final LikeFood uncooked_chicken = new LikeFood("u_chikin", 2, 0.3f, 0.35f, Items.field_151076_bf, true);
    public static final LikeFood pork = new LikeFood("pork", 8, 0.8f, -1.0f, Items.field_151157_am, true);
    public static final LikeFood uncooked_pork = new LikeFood("u_pork", 3, 0.3f, 0.35f, Items.field_151147_al, true);
    public static final LikeFood beef = new LikeFood("beef", 8, 0.8f, -1.0f, Items.field_151083_be, true);
    public static final LikeFood uncooked_beef = new LikeFood("u_beef", 3, 0.3f, 0.35f, Items.field_151082_bd, true);
    public static final LikeFood mutton = new LikeFood("mutton", 6, 0.8f, -1.0f, Items.field_179557_bn, true);
    public static final LikeFood uncooked_mutton = new LikeFood("u_mutton", 2, 0.3f, 0.35f, Items.field_179561_bm, true);
    public static final LikeFood rabbit = new LikeFood("rabit", 5, 0.6f, -1.0f, Items.field_179559_bp, true);
    public static final LikeFood uncooked_rabbit = new LikeFood("u_rabit", 3, 0.3f, 0.35f, Items.field_179558_bo, true);
    public static final LikeFood egg = new LikeFood("egg", 4, 0.6f, 0.2f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_egg = new LikeFood("u_egg", 3, 0.6f, 0.25f, Items.field_151110_aK, true);
    public static final LikeFood fried_egg = new LikeFood("fried_egg", 4, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood fish = new LikeFood("codfish", 5, 0.6f, -1.0f, Items.field_196102_ba, true);
    public static final LikeFood uncooked_fish = new LikeFood("u_fish", 4, 0.6f, 0.35f, Items.field_196086_aW, true);
    public static final LikeFood salt_fish_portion = new LikeFood("bito_saltfish", 2, 0.3f, -1.0f, OneXp.Per02, NO_PROTOTYPE, false);
    public static final LikeFood salmon = new LikeFood("salmon", 6, 0.8f, -1.0f, Items.field_196104_bb, true);
    public static final LikeFood uncooked_salmon = new LikeFood("u_salmon", 4, 0.6f, 0.35f, Items.field_196087_aX, true);
    public static final LikeFood pufferfish = new LikeFood("pufyfish", 5, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_pufferfish = new LikeFood("u_pufyfish", 3, 0.6f, 0.35f, Items.field_196089_aZ, true);
    public static final LikeFood ink_kelp = new LikeFood("ikelp", 2, 0.3f, 0.04375f, NO_PROTOTYPE, false);
    public static final LikeFood salt_pork = new LikeFood("saltpork", 8, 0.8f, -1.0f, Items.field_151157_am, false);
    public static final LikeFood uncooked_salt_pork = new LikeFood("u_saltpork", 3, 0.3f, 0.4f, Items.field_151147_al, false);
    public static final LikeFood smoked_pork_hocks = new LikeFood("hocks", 5, 0.6f, -1.0f, Items.field_151157_am, false);
    public static final LikeFood uncooked_pork_hocks = new LikeFood("u_hocks", 3, 0.3f, 0.35f, Items.field_151147_al, false);
    public static final LikeFood uncooked_pigtail = new LikeFood("u_pigtail", 1, 0.3f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood salt_pigtail = new LikeFood("pigtail", 4, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood bat = new LikeFood("bat", 4, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_bat = new LikeFood("u_bat", 2, 0.3f, 0.4f, NO_PROTOTYPE, false);
    public static final LikeFood horse = new LikeFood("horse", 10, 0.9f, -1.0f, Items.field_151083_be, false);
    public static final LikeFood uncooked_horse = new LikeFood("u_horse", 4, 0.5f, 0.35f, Items.field_151082_bd, false);
    public static final LikeFood llama = new LikeFood("llama", 7, 0.8f, -1.0f, Items.field_179557_bn, false);
    public static final LikeFood uncooked_llama = new LikeFood("u_llama", 2, 0.3f, 0.35f, Items.field_179561_bm, false);
    public static final LikeFood wolf = new LikeFood("wolf", 5, 0.7f, -1.0f, Items.field_151077_bg, false);
    public static final LikeFood uncooked_wolf = new LikeFood("u_wolf", 3, 0.3f, 0.35f, Items.field_151076_bf, false);
    public static final LikeFood squid = new LikeFood("squid", 4, 0.7f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_squid = new LikeFood("u_squid", 3, 0.3f, 0.3f, NO_PROTOTYPE, false);
    public static final LikeFood squid_on_stick = new LikeFood("squid_stick", -1, squid, squid);
    public static final LikeFood bear = new LikeFood("bear", 8, 0.8f, -1.0f, Items.field_151083_be, false);
    public static final LikeFood uncooked_bear = new LikeFood("u_bear", 2, 0.3f, 0.35f, Items.field_151082_bd, false);
    public static final LikeFood charred_bear = new LikeFood("burnt_bear", 4, 0.6f, -1.0f, Items.field_151083_be, false);
    public static final LikeFood deer = new LikeFood("deer", 8, 0.8f, -1.0f, Items.field_151083_be, false);
    public static final LikeFood uncooked_deer = new LikeFood("u_deer", 2, 0.3f, 0.35f, Items.field_151082_bd, false);
    public static final LikeFood turkey = new LikeFood("turkey", 6, 0.6f, -1.0f, Items.field_151077_bg, false);
    public static final LikeFood uncooked_turkey = new LikeFood("u_turkey", 2, 0.3f, 0.35f, Items.field_151076_bf, false);
    public static final LikeFood goat = new LikeFood("goat", 8, 0.8f, -1.0f, Items.field_151157_am, false);
    public static final LikeFood uncooked_goat = new LikeFood("u_goat", 3, 0.3f, 0.35f, Items.field_151147_al, false);
    public static final LikeFood squirrel = new LikeFood("squrel", 4, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_squirrel = new LikeFood("u_squrel", 2, 0.3f, 0.4f, NO_PROTOTYPE, false);
    public static final LikeFood ravager = new LikeFood("ravgr", 15, 1.0f, -1.0f, Items.field_151083_be, false);
    public static final LikeFood uncooked_ravager = new LikeFood("u_ravgr", 8, 0.7f, 0.35f, Items.field_151082_bd, false);
    public static final LikeFood charred_ravager = new LikeFood("burnt_ravgr", 8, 0.8f, -1.0f, Items.field_151083_be, false);
    public static final LikeFood rotten_flesh = new LikeFood("rotn_flesh", 4, 0.3f, 0.35f, Items.field_151078_bh, true);
    public static final LikeFood sanitized_flesh = new LikeFood("spam", 7, 0.7f, 0.35f, Items.field_151078_bh, false);
    public static final LikeFood uncooked_fish_sausage = new LikeFood("u_fish_sausage", 0, 0.0f, 0.0f, NO_PROTOTYPE, false);
    public static final LikeFood fish_sausage = new LikeFood("fish_sausage", 8, 0.8f, 0.3f, OneXp.Per02, NO_PROTOTYPE, false);
    public static final LikeFood fish_sausage_wrap = new LikeFood("fish_sausage_swch", 12, 0.8f, NO_PROTOTYPE, false);
    public static final LikeFood sugar = new LikeFood("sugar", 1, 0.1f, 0.3f, Items.field_151102_aT, true);
    public static final LikeFood hardened_sugar = new LikeFood("hrd_sugar", -1, sugar, sugar, sugar, sugar);
    public static final LikeFood sugarbomb = new LikeFood(0, sugar, sugar);
    public static final LikeFood soaked_gelo = new LikeFood("soakd_gelo", -1, hardened_sugar, golden_boost);
    public static final LikeFood cocoa_seed = new LikeFood("coco_seed", 0, 0.0f, -1.0f, Items.field_196130_bo, true);
    public static final LikeFood cane_section = new LikeFood("cane", 0, 0.0f, 0.1f, Items.field_222065_kN, true);
    public static final LikeFood golden_sugar = new LikeFood("gold_sugar", 8, 0.45f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood spidereye = new LikeFood("spdr_eye", 2, 0.8f, Items.field_151070_bp, true);
    public static final LikeFood mushroom_stew = new LikeFood("shroom_stw", 6, 0.6f, Items.field_151009_A, true);
    public static final LikeFood beetsoup = new LikeFood("beet_soup", 6, 0.6f, Items.field_185165_cW, true);
    public static final LikeFood rabbit_stew = new LikeFood("rabit_stew", 10, 0.7f, Items.field_179560_bq, true);
    public static final LikeFood vegetable_stew = new LikeFood("veg_stew", 7, 0.8f, NO_PROTOTYPE, false);
    public static final LikeFood vegetable_stew_meal = new LikeFood("veg_stew_meal", 0, vegetable_stew, flouronly_bread);
    public static final LikeFood meat_stew = new LikeFood("meat_stew", 14, 0.85f, NO_PROTOTYPE, false);
    public static final LikeFood meat_stew_meal = new LikeFood("meat_stew_meal", 0, meat_stew, sandwich);
    public static final LikeFood earthy_stew = new LikeFood("earthy_stew", 18, 0.85f, NO_PROTOTYPE, false).setFeedsWell();
    public static final LikeFood broth = new LikeFood("broth", 3, 0.45f, NO_PROTOTYPE, false);
    public static final LikeFood broth_meal = new LikeFood("broth_meal", 0, broth, sandwich);
    public static final LikeFood uncooked_meat_pie = new LikeFood("u_meatpie", 0, 0.0f, 0.8f, NO_PROTOTYPE, false).setCraftExperience(OneXp.Per02.value());
    public static final LikeFood egg_pie = new LikeFood("eggpie", 26, 0.9f, NO_PROTOTYPE, false);
    public static final LikeFood meat_pie = new LikeFood("meatpie", 16, 0.9f, NO_PROTOTYPE, false);
    public static final LikeFood mini_pie = new LikeFood("minipie", 3, 0.7f, 0.3f, NO_PROTOTYPE, true);
    public static final LikeFood uncooked_meat_portion = new LikeFood("u_bito_meat", 1, 0.3f, 0.04375f, NO_PROTOTYPE, false);
    public static final LikeFood meat_portion = new LikeFood("bito_meat", 2, 0.7f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood jerky_bit = new LikeFood("jerkybit", 3, 0.75f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood jerky_bit_x3 = new LikeFood("3x_jerkybit", 10, 0.8f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood jerky = new LikeFood("jerky", 7, 0.7f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood cornmeal_portion = new LikeFood("cornmeal", 4, 0.4f, NO_PROTOTYPE, true);
    public static final LikeFood veg_portion = new LikeFood("bito_veg", 2, 0.4f, NO_PROTOTYPE, true);
    public static final LikeFood raw_veg_medley = new LikeFood("raw_vegs", 6, 0.7f, 0.3f, NO_PROTOTYPE, false);
    public static final LikeFood roast_veg_medley = new LikeFood("roast_vegs", 12, 0.6f, NO_PROTOTYPE, false);
    public static final LikeFood roast_veg = new LikeFood("roast_veg", 4, 0.6f, NO_PROTOTYPE, false);
    public static final LikeFood glazed_carrots = new LikeFood("glazed_carrot", 10, 0.7f, NO_PROTOTYPE, false);
    public static final LikeFood desert_salad = new LikeFood("desert_salad", -1, raw_veg_medley, acorn_nuts, chicken, combo_boost1);
    public static final LikeFood special_salad = new LikeFood("reward_salad", -1, roast_veg_medley, golden_apple, golden_carrot, combo_boost3);
    public static final LikeFood milk = new LikeFood("milk_botl", 2, 0.6f, -1.0f, OneXp.Per08, Items.field_151117_aB, false);
    public static final LikeFood cream = new LikeFood("cream_botl", 4, 0.6f, -1.0f, OneXp.Per08, Items.field_151117_aB, false);
    public static final LikeFood sweet_milk = new LikeFood("sweet_milk_botl", -1, milk, sugar, sugar);
    public static final LikeFood sweet_cream = new LikeFood("sweet_cream_botl", -1, cream, sugar, sugar);
    public static final LikeFood milk_bucket = new LikeFood("milk_bukt", 8, 0.6f, 0.3f, Items.field_151117_aB, true);
    public static final LikeFood juice = new LikeFood("juice", 7, 0.5f, NO_PROTOTYPE, false);
    public static final LikeFood bush_tea = new LikeFood("bushtea", 6, 0.4f, -1.0f, OneXp.Per08, NO_PROTOTYPE, false);
    public static final LikeFood milky_bush_tea = new LikeFood("milky_bushtea", -1, cream, bush_tea);
    public static final LikeFood kelp_shake = new LikeFood("kelp_shake", -1, sweet_cream, bush_tea, spidereye, ink_kelp).setFeedsWell();
    public static final LikeFood birch_sap = new LikeFood("birchsap_botl", 3, 3.34f, -1.0f, OneXp.Per08, NO_PROTOTYPE, false);
    public static final LikeFood honey_milk = new LikeFood("honeymilk", -1, milk, honey_bottle, honeycomb, effort_boost1);
    public static final LikeFood cheese_portion = new LikeFood("cheeze", 4, 0.6f, -1.0f, OneXp.Per02, NO_PROTOTYPE, false);
    public static final LikeFood butter = new LikeFood("buttah", 4, 0.3f, -1.0f, OneXp.Per04, NO_PROTOTYPE, false);
    public static final LikeFood butter_dab = new LikeFood("buttdab", 1, 0.1f, NO_PROTOTYPE, false);
    public static final LikeFood buttered_bread = new LikeFood("buttered_bread", -1, sandwich, butter_dab);
    public static final LikeFood sunbutter = new LikeFood("sun_buttah", 4, 0.3f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood cream_soup = new LikeFood("cream_soup", 8, 0.8f, NO_PROTOTYPE, false).setCraftExperience(OneXp.Per03.value());
    public static final LikeFood gruel = new LikeFood("gruel", -1, milk, cornmeal_portion, combo_boost1);
    public static final LikeFood sop = new LikeFood("sop", -1, broth, veg_portion);
    public static final LikeFood acorn_stew = new LikeFood("acorn_stew", 8, 0.9f, NO_PROTOTYPE, false).setFeedsWell().setCraftExperience(OneXp.Per03.value());
    public static final LikeFood fish_chowder = new LikeFood("fish_chwder", -1, milk, veg_portion, salmon).setCraftExperience(cream_soup.craftExperience());
    public static final LikeFood tato_chowder = new LikeFood("tato_chwder", -1, milk, potato, meat_portion).setCraftExperience(cream_soup.craftExperience());
    public static final LikeFood fryegg_sandwich = new LikeFood("fryegg_sandwch", -1, fried_egg, sandwich, combo_boost1);
    public static final LikeFood fry2egg_sandwich = new LikeFood("fry2egg_sandwch", -1, fried_egg, fryegg_sandwich);
    public static final LikeFood cheese_sandwich = new LikeFood("cheeze_sandwch", -1, cheese_portion, sandwich, combo_boost1);
    public static final LikeFood hamegg_sandwich = new LikeFood("hamegg_sandwch", -1, fried_egg, meat_portion, meat_portion, sandwich, combo_boost1);
    public static final LikeFood happy_muffin = new LikeFood("hapi_muffin", -1, apple, muffin, golden_boost).setCraftExperience(OneXp.Per02.value());
    public static final LikeFood sunbutter_sandwich = new LikeFood("sunbutt_sandwch", -1, sandwich, sunbutter, seed, combo_boost1);
    public static final LikeFood sunbutter_fruit_sandwich = new LikeFood("sunbutt_fruit_sandwch", -1, apple, sandwich, sunbutter, combo_boost2);
    public static final LikeFood sunbutter_honey_sandwich = new LikeFood("sunbutt_honey_sandwch", -1, honey_bottle, sandwich, sunbutter, seed, combo_boost2);
    public static final LikeFood sunbutter_jelly_sandwich = new LikeFood("sunbutt_sandwch", -1, sandwich, sunbutter, sugarbomb, combo_boost1);
    public static final LikeFood jellyjam_sandwich = new LikeFood("jelyjam_sandwch", -1, sandwich, sugarbomb, effort_boost2);
    public static final LikeFood cheese_jellyjam_sandwich = new LikeFood("jelyjam_sandwch2", -1, jellyjam_sandwich, butter_dab, cheese_portion);
    public static final LikeFood sunbutter_apple_snack = new LikeFood("sunbutt_apple", -1, apple, sunbutter, combo_boost1);
    public static final LikeFood sunbutter_carrot_snack = new LikeFood("sunbutt_carot", -1, uncooked_carrot, sunbutter);
    public static final LikeFood fruit_bowl = new LikeFood("frut_bowl", -1, mixed_berries, melon_slice, apple, combo_boost2);
    public static final LikeFood berries_and_cream = new LikeFood("bery_crem", -1, mixed_berries, sweet_cream);
    public static final LikeFood honey_melon_bowl = new LikeFood("melon_bowl", -1, honey_bottle, melon_slice, melon_slice, combo_boost2);
    public static final LikeFood nomads_fullbar = new LikeFood("nomad_mealbar", -1, dried_apple, mixed_berries, acorn_nuts, seed, seed, seed, combo_boost2, combo_boost2).setFeedsWell();
    public static final LikeFood nomads_halfbar = new LikeFood("nomad_minibar", nomads_fullbar.healAmount() / 2, nomads_fullbar.saturationModifier(), NO_PROTOTYPE, false);
    public static final LikeFood decker = new LikeFood("decker", -1, bread, fried_egg);
    public static final LikeFood cyclops_sandwich = new LikeFood("cyclop_sandwch", 10, 0.8f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_kebab = new LikeFood("u_kebab", 4, 0.6f, 0.3f, OneXp.Per06, NO_PROTOTYPE, false);
    public static final LikeFood kebab = new LikeFood("kebab", 6, 0.7f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood kebab_heavy = new LikeFood("kebab_heavy", 7, 0.8f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_nuggets = new LikeFood("u_3nugets", 4, 0.4f, 0.3f, NO_PROTOTYPE, false);
    public static final LikeFood nuggets = new LikeFood("3nugets", 7, 0.75f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood nuggets_heavy = new LikeFood("heavy_3nugets", 9, 0.8f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood nuggets_combo = new LikeFood("nuget_meal", -1, nuggets, fries, combo_boost1);
    public static final LikeFood nuggets_combo_heavy = new LikeFood("nuget_meal_heavy", -1, nuggets_combo, combo_boost3);
    public static final LikeFood pocket_shroowich = new LikeFood("pocket_shrowich", -1, egg, mushroom, bread_pocket);
    public static final LikeFood pocket_eggwich = new LikeFood("pocket_eggwich", -1, egg, meat_portion, bread_pocket);
    public static final LikeFood pocket_vegwich = new LikeFood("pocket_vegwich", -1, roast_veg, seed, bread_pocket);
    public static final LikeFood egg_n_tatoes = new LikeFood("egg_tatoes", -1, fried_egg, potato, potato, combo_boost2);
    public static final LikeFood mashed_potato = new LikeFood("mashed_tato", -1, potato, veg_portion, condiment, combo_boost1);
    public static final LikeFood buttered_potato = new LikeFood("butt_potato", -1, potato, butter_dab);
    public static final LikeFood stuffed_potato = new LikeFood("stufed_tato", 12, 0.9f, NO_PROTOTYPE, false);
    public static final LikeFood overstuffed_potato = new LikeFood("stufed_tato+", -1, stuffed_potato, meat_portion, veg_portion, veg_portion);
    public static final LikeFood HEFTIEST_FOOD = enriched_dessert_pie;
    public static final LikeFood TYPICAL_FOOD_PORTION = bread;
    public static final LikeFood SMALLEST_PROTEIN = fried_egg;
    public static final LikeFood BASE_DECKER = new LikeFood("decker+", -1, sandwich_bread, ravager, roast_veg);
    public static final LikeFood TOWERING_MEGAWICH = new LikeFood("megawich", -1, BASE_DECKER, BASE_DECKER, BASE_DECKER);
    public static final LikeFood MORSEL_PORTION = jerky_bit;
    private static final int _BOOST = 1;
    private static final int _WELLFED = 2;
    private final boolean _readonly;
    private final String _name;
    private final int _healAmount;
    private final float _saturationModifier;
    private float _smeltXp;
    private float _craftXp = 0.0f;
    private final ItemHandle _sampleFood;
    private int _meta;

    private LikeFood(String nm, int healBy, float satModifier, float smeltXp, OneXp craftXp, Item food, boolean locked) {
        this._name = nm;
        this._sampleFood = new ItemHandle(food);
        this._healAmount = healBy;
        this._saturationModifier = satModifier;
        this._smeltXp = smeltXp;
        this._craftXp = craftXp != null ? craftXp.value() : 0.0f;
        this._readonly = locked;
    }

    private LikeFood(String nm, int healBy, float satModifier, float smeltXp, Item food, boolean locked) {
        this(nm, healBy, satModifier, smeltXp, NO_CRAFT_XP, food, locked);
    }

    private LikeFood(String nm, int healBy, float satModifier, Item food, boolean locked) {
        this(nm, healBy, satModifier, -1.0f, food, locked);
    }

    public LikeFood(int healBy, float satModifier, float smeltXp, Item food) {
        this("", healBy, satModifier, smeltXp, food, false);
    }

    public LikeFood(int healBy, float satModifier, Item food) {
        this("", healBy, satModifier, -1.0f, food, false);
    }

    public LikeFood(int healBy, float satModifier) {
        this("", healBy, satModifier, -1.0f, (Item)null, false);
    }

    public LikeFood(String item_resource) {
        Validate.notNull((Object)item_resource, (String)"A non-null prototype food item identifier is required", (Object[])new Object[0]);
        this._name = "";
        this._sampleFood = new ItemHandle(item_resource);
        this._healAmount = 0;
        this._saturationModifier = 0.0f;
        this._smeltXp = -1.0f;
        this._readonly = false;
    }

    public LikeFood(LikeFood from) {
        Validate.notNull((Object)from, (String)"A non-null source like food is required", (Object[])new Object[0]);
        this._name = "";
        this._sampleFood = from._sampleFood.copy();
        this._healAmount = from._healAmount;
        this._saturationModifier = from._saturationModifier;
        this._smeltXp = from._smeltXp;
        this._craftXp = from._craftXp;
        this._readonly = false;
    }

    public LikeFood(String nm, int sampleIndex, LikeFood ... foods) {
        Validate.isTrue((foods != null && foods.length >= 1 ? 1 : 0) != 0, (String)"At least one source food must be defined", (Object[])new Object[0]);
        int healBy = 0;
        float satModifier = 0.0f;
        float satBoost = 0.0f;
        float smeltXp = 0.0f;
        float craftXp = 0.0f;
        LikeFood like = null;
        int i = 0;
        for (LikeFood food : foods) {
            healBy += food.healAmount();
            if (food.isEnhancer()) {
                satBoost += food.saturationModifier();
            } else if (food.saturationModifier() > satModifier) {
                satModifier = food.saturationModifier();
            }
            if (food.smeltExperience() > smeltXp) {
                smeltXp = food.smeltExperience();
            }
            if (food.craftExperience() > craftXp) {
                craftXp = food.craftExperience();
            }
            if (i == sampleIndex) {
                like = food;
            }
            ++i;
        }
        if (healBy < 0) {
            healBy = 0;
        }
        if (satModifier < 0.0f) {
            satModifier = 0.0f;
        }
        this._name = nm;
        this._healAmount = healBy;
        this._saturationModifier = satModifier + satBoost;
        this._smeltXp = smeltXp;
        this._craftXp = craftXp;
        if (like != null) {
            this._sampleFood = like._sampleFood.copy();
            this._readonly = true;
        } else {
            this._sampleFood = new ItemHandle();
            this._readonly = false;
        }
    }

    public LikeFood(int sampleIndex, LikeFood ... foods) {
        this("", sampleIndex, foods);
    }

    public int healAmount() {
        return this._healAmount;
    }

    public float saturationModifier() {
        return this._saturationModifier;
    }

    public float smeltExperience() {
        return this._smeltXp;
    }

    public LikeFood setSmeltExperience(float value) {
        if (!this._readonly) {
            this._smeltXp = value;
        }
        return this;
    }

    public float craftExperience() {
        return this._craftXp;
    }

    public LikeFood setCraftExperience(float value) {
        if (!this._readonly) {
            this._craftXp = value;
        }
        return this;
    }

    public boolean isEnhancer() {
        return (this._meta & 1) == 1;
    }

    public LikeFood setEnhancer() {
        if (!this._readonly) {
            this._meta |= 1;
        }
        return this;
    }

    public final boolean isOversized() {
        return this.healAmount() > SharedGlue.DEFAULT_MAX_PLAYER_FOOD_LEVEL();
    }

    public final boolean feedsWell() {
        return (this._meta & 2) == 2 || this.healAmount() > SharedGlue.WELL_FED_FOOD_POINTS_THRESHOLD();
    }

    public LikeFood setFeedsWell() {
        if (!this._readonly) {
            this._meta |= 2;
        }
        return this;
    }

    @Nonnull
    private ItemStack _sample() {
        return this._sampleFood.item();
    }

    @Nonnull
    public ItemStack sample() {
        ItemStack food = this._sample();
        return !ItemStacks.isEmpty((ItemStack)food) ? food.func_77946_l() : food;
    }

    @Nonnull
    public ItemStack sample(int amount) {
        ItemStack food = this._sample();
        if (!ItemStacks.isEmpty((ItemStack)food)) {
            food = food.func_77946_l();
            ItemStacks.setSize((ItemStack)food, (int)amount);
        }
        return food;
    }

    @Nullable
    public final Item sampleitem() {
        ItemStack underneath = this._sample();
        return ItemStacks.isEmpty((ItemStack)underneath) ? null : underneath.func_77973_b();
    }

    public ItemHandle food() {
        ItemHandle food = this._sampleFood;
        return this._readonly ? food.copy() : food;
    }

    public final Food.Builder food_stat() {
        Food.Builder b = new Food.Builder().func_221456_a(this.healAmount()).func_221454_a(this.saturationModifier());
        if (this.healAmount() <= MORSEL_PORTION.healAmount()) {
            b.func_221457_c();
        }
        return b;
    }

    public static final boolean something(LikeFood arg) {
        return arg != null && arg != air && arg != crumb && (arg._readonly || arg.healAmount() > 0);
    }

    public static final boolean really(LikeFood arg) {
        return LikeFood.something(arg) && !ItemStacks.isEmpty((ItemStack)arg.sample());
    }

    public int hashCode() {
        return Objects.hash(this._healAmount, Float.valueOf(this._saturationModifier), this._sample());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().equals(o.getClass())) {
            LikeFood other = (LikeFood)LikeFood.class.cast(o);
            return ItemStack.func_179545_c((ItemStack)this._sample(), (ItemStack)other._sample()) && this._healAmount == other._healAmount && this._saturationModifier == other._saturationModifier;
        }
        return false;
    }

    public String toString() {
        return "(" + this._name + "," + this._healAmount + "[heal]," + this._saturationModifier + "[sat]," + this._smeltXp + "[smlt]," + this._craftXp + "[crft])";
    }

    @Override
    public final String name() {
        return this._name;
    }
}

