/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public final class PackagedFood
implements Comparable<PackagedFood> {
    private static final Map<String, Integer> TYPE_GROUPS = new Hashtable<String, Integer>();
    private static final Collection<PackagedFood> FOODS = new ArrayList<PackagedFood>(100);
    public static final PackagedFood BREAD = new PackagedFood(Type.bakery, "breads", LikeFood.bread);
    public static final PackagedFood ENRICHED_BREAD = new PackagedFood(Type.bakery, "enriched_breads", LikeFood.enriched_bread);
    public static final PackagedFood CAKE = new PackagedFood(Type.bakery, "cakes", LikeFood.cake, VfpCapacity.HALF_TRAY, VfpCapacity.SMALL_STACK);
    public static final PackagedFood PUMPKIN_PIE = new PackagedFood(Type.bakery, "pumpkin_pies", LikeFood.pumpkin_pie, VfpCapacity.BAKERS_TRAY, VfpCapacity.MEDIUM_STACK);
    public static final PackagedFood COOKIE = new PackagedFood(Type.bakery, "cookies", LikeFood.cookie, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood EGG_PIE = new PackagedFood(Type.bakery, "egg_pies", LikeFood.egg_pie, VfpCapacity.BAKERS_TRAY, VfpCapacity.MEDIUM_STACK);
    public static final PackagedFood SANDWICHES_FRYEGG = new PackagedFood(Type.bakery, "sandwich_fryegg", LikeFood.fryegg_sandwich);
    public static final PackagedFood SANDWICHES_CHEESE = new PackagedFood(Type.bakery, "sandwich_cheeze", LikeFood.cheese_sandwich);
    public static final PackagedFood SANDWICHES_HAMEGG = new PackagedFood(Type.bakery, "sandwich_hamegg", LikeFood.hamegg_sandwich);
    public static final PackagedFood COCOA_SEED = new PackagedFood(Type.bakery, "cocoa", LikeFood.cocoa_seed, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood CANE = new PackagedFood(Type.bakery, "cane", LikeFood.cane_section, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood POTATO = new PackagedFood(Type.vegetable, "potatoes", LikeFood.uncooked_potato, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood BAD_TATOES = new PackagedFood(Type.general, "badpotatoes", LikeFood.bad_potato, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood CARROT = new PackagedFood(Type.vegetable, "carrots", LikeFood.uncooked_carrot, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood BEETROOT = new PackagedFood(Type.vegetable, "beetroot", LikeFood.uncooked_beetroot, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood MUSHROOM = new PackagedFood(Type.vegetable, "mushrooms", LikeFood.mushroom, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood RED_MUSHROOM = new PackagedFood(Type.vegetable, "red_mushrooms", LikeFood.red_mushroom, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood CHORUS_FRUIT = new PackagedFood(Type.fruit, "chorusfruit", LikeFood.chorus_fruit, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood APPLE = new PackagedFood(Type.fruit, "apples", LikeFood.apple, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood EGG = new PackagedFood(Type.meat, "eggs", LikeFood.uncooked_egg, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood COOKED_EGG = new PackagedFood(Type.cooked_meat, "eggs_cooked", LikeFood.egg);
    public static final PackagedFood CHICKEN = new PackagedFood(Type.meat, "chicken", LikeFood.uncooked_chicken);
    public static final PackagedFood COOKED_CHICKEN = new PackagedFood(Type.cooked_meat, "chicken_cooked", LikeFood.chicken);
    public static final PackagedFood CODFISH = new PackagedFood(Type.meat, "cod", LikeFood.uncooked_fish, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood COOKED_CODFISH = new PackagedFood(Type.cooked_meat, "cod_cooked", LikeFood.fish);
    public static final PackagedFood SALMON = new PackagedFood(Type.meat, "salmon", LikeFood.uncooked_salmon, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood COOKED_SALMON = new PackagedFood(Type.cooked_meat, "salmon_cooked", LikeFood.salmon);
    public static final PackagedFood PUFFERFISH = new PackagedFood(Type.meat, "pufferfish", LikeFood.uncooked_pufferfish, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood COOKED_PUFFERFISH = new PackagedFood(Type.cooked_meat, "pufferfish_cooked", LikeFood.pufferfish);
    public static final PackagedFood PORK = new PackagedFood(Type.meat, "pork", LikeFood.uncooked_pork);
    public static final PackagedFood COOKED_PORK = new PackagedFood(Type.cooked_meat, "pork_cooked", LikeFood.pork);
    public static final PackagedFood BEEF = new PackagedFood(Type.meat, "beef", LikeFood.uncooked_beef);
    public static final PackagedFood COOKED_BEEF = new PackagedFood(Type.cooked_meat, "beef_cooked", LikeFood.beef);
    public static final PackagedFood MUTTON = new PackagedFood(Type.meat, "mutton", LikeFood.uncooked_mutton);
    public static final PackagedFood COOKED_MUTTON = new PackagedFood(Type.cooked_meat, "mutton_cooked", LikeFood.mutton);
    public static final PackagedFood RABBIT = new PackagedFood(Type.meat, "rabbit", LikeFood.uncooked_rabbit);
    public static final PackagedFood COOKED_RABBIT = new PackagedFood(Type.cooked_meat, "rabbit_cooked", LikeFood.rabbit);
    public static final PackagedFood HORSE = new PackagedFood(Type.meat, "horse", LikeFood.uncooked_horse);
    public static final PackagedFood COOKED_HORSE = new PackagedFood(Type.cooked_meat, "horse_cooked", LikeFood.horse);
    public static final PackagedFood WOLF = new PackagedFood(Type.meat, "wolf", LikeFood.uncooked_wolf);
    public static final PackagedFood COOKED_WOLF = new PackagedFood(Type.cooked_meat, "wolf_cooked", LikeFood.wolf);
    public static final PackagedFood SQUID = new PackagedFood(Type.meat, "squid", LikeFood.uncooked_squid);
    public static final PackagedFood COOKED_SQUID = new PackagedFood(Type.cooked_meat, "squid_cooked", LikeFood.squid);
    public static final PackagedFood PORK_HOCKS = new PackagedFood(Type.meat, "hocks", LikeFood.uncooked_pork_hocks);
    public static final PackagedFood COOKED_PORK_HOCKS = new PackagedFood(Type.cooked_meat, "hocks_smoked", LikeFood.smoked_pork_hocks);
    public static final PackagedFood PIGTAILS = new PackagedFood(Type.meat, "pigtails", LikeFood.uncooked_pigtail);
    public static final PackagedFood LLAMA = new PackagedFood(Type.meat, "llama", LikeFood.uncooked_llama);
    public static final PackagedFood COOKED_LLAMA = new PackagedFood(Type.cooked_meat, "llama_cooked", LikeFood.llama);
    public static final PackagedFood ROTTEN_FLESH = new PackagedFood(Type.meat, "rotten_flesh", LikeFood.rotten_flesh, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood BONES = new PackagedFood(Type.meat, "bones", LikeFood.bone, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood RAW_SUGAR = new PackagedFood(Type.bakery, "hardened_sugar", LikeFood.hardened_sugar);
    public static final PackagedFood INK_SAC = new PackagedFood(Type.liquids, "ink", LikeFood.air, null, VfpCapacity.LIQUID_STACK);
    public static final PackagedFood LUMINESCE_SAC = new PackagedFood(Type.liquids, "luminesce", LikeFood.air, null, VfpCapacity.LIQUID_STACK);
    private final String _typeid;
    private final int _meta;
    private final String _name;
    private final LikeFood _food;
    private final VfpCapacity _capacity;
    private final Integer _maxstack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void save(PackagedFood pf) {
        Collection<PackagedFood> collection = FOODS;
        synchronized (collection) {
            for (PackagedFood next : FOODS) {
                if (!next._typeid.equals(pf._typeid) || next._food != pf._food) continue;
                return;
            }
            FOODS.add(pf);
        }
    }

    private PackagedFood(Type type, String name, @Nonnull LikeFood like) {
        this(type.name(), name, like);
    }

    public PackagedFood(String type, String name, @Nonnull LikeFood like) {
        Validate.notNull((Object)like, (String)"A packaged food MUST be backed by a sample food item (LikeFood)", (Object[])new Object[0]);
        this._typeid = type;
        this._meta = PackagedFood.incr(type);
        this._food = like;
        this._name = name;
        this._capacity = null;
        this._maxstack = VfpCapacity.LARGE_STACK.count();
        PackagedFood.save(this);
    }

    private PackagedFood(Type type, String name, @Nonnull LikeFood like, VfpCapacity cap, VfpCapacity max) {
        this(type.name(), name, like, cap, max);
    }

    public PackagedFood(String type, String name, @Nonnull LikeFood like, VfpCapacity cap, VfpCapacity max) {
        Validate.notNull((Object)like, (String)"A packaged food MUST be backed by a sample food item (LikeFood)", (Object[])new Object[0]);
        this._typeid = type;
        this._meta = PackagedFood.incr(type);
        this._food = like;
        this._name = name;
        this._capacity = cap;
        this._maxstack = max != null ? max.count() : VfpCapacity.LARGE_STACK.count();
        PackagedFood.save(this);
    }

    public final int typemeta() {
        return this._meta;
    }

    public final String type() {
        return this._typeid;
    }

    public final String fmlid_suffix() {
        return this._name;
    }

    public final LikeFood food() {
        return this._food;
    }

    public final VfpCapacity capacity() {
        return this._capacity;
    }

    public final Integer maxstack() {
        return this._maxstack;
    }

    @Override
    public int compareTo(PackagedFood o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        int i = this._typeid.compareTo(o._typeid);
        if (i == 0) {
            i = this._meta > o._meta ? 1 : (this._meta < o._meta ? -1 : 0);
        }
        return i;
    }

    public String toString() {
        return this._typeid + "/" + this._name + "@" + this._meta + "[cap=" + (Object)((Object)this._capacity) + ",max=" + this._maxstack + "] for " + this._food;
    }

    private static int incr(String typeid) {
        Integer I = TYPE_GROUPS.get(typeid);
        I = I == null ? Integer.valueOf(0) : Integer.valueOf(I + 1);
        TYPE_GROUPS.put(typeid, I);
        return I;
    }

    public static final String[] groups() {
        return TYPE_GROUPS.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static final boolean known(String typeid) {
        return TYPE_GROUPS.containsKey(typeid);
    }

    private static final VfpVariant _new_variant(PackagedFood pf, int index, String fmlid) {
        return new VfpVariant(index, fmlid, pf._food, pf._capacity, pf._maxstack, pf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VfpVariant[] init(String typeid, String what, boolean shortnames, int idoffset, List<PackagedFood> exclusions) {
        if (!PackagedFood.known(typeid)) {
            return null;
        }
        if (exclusions == null) {
            exclusions = Collections.EMPTY_LIST;
        }
        ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(23);
        Collection<PackagedFood> collection = FOODS;
        synchronized (collection) {
            for (PackagedFood pf : FOODS) {
                VfpVariant variant;
                int index;
                if (!typeid.equals(pf.type()) || exclusions.contains(pf)) continue;
                String fmlid = shortnames ? pf.fmlid_suffix() : what + "_" + pf.fmlid_suffix();
                int n = index = exclusions.isEmpty() ? pf._meta : variants.size();
                if (idoffset > 0) {
                    int id = idoffset + pf._meta;
                    variant = new VfpTransientVariant(index, id, fmlid, pf._food, pf._capacity, pf._maxstack, pf, null);
                } else {
                    variant = PackagedFood._new_variant(pf, index, fmlid);
                }
                variants.add(variant);
            }
        }
        Collections.sort(variants);
        return variants.toArray(VfpVariant.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VfpVariant[] init(Type type, String what, Item innerContainerItem, VfpVariant[] contained, List<PackagedFood> filter, boolean exclusion) {
        if (filter == null) {
            filter = Collections.EMPTY_LIST;
        }
        ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(23);
        Collection<PackagedFood> collection = FOODS;
        synchronized (collection) {
            for (PackagedFood pf : FOODS) {
                if (!type.name().equals(pf.type()) || (!exclusion || filter.contains(pf)) && (exclusion || !filter.contains(pf))) continue;
                String fmlid = what + "_" + pf.fmlid_suffix();
                ItemStack subcontainer = null;
                for (VfpVariant inner : contained) {
                    if (inner.metadata() != pf._meta + type.shared_metaoffset()) continue;
                    subcontainer = new ItemStack((IItemProvider)innerContainerItem, VfpCapacity.TRAY.count());
                    break;
                }
                VfpVariant variant = subcontainer != null ? new VfpVariant(-1, fmlid, null, pf._capacity, pf._maxstack, subcontainer, null) : PackagedFood._new_variant(pf, -1, fmlid);
                variants.add(variant);
            }
        }
        Collections.sort(variants);
        return variants.toArray(VfpVariant.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final List<PackagedFood> values(String typeid, boolean exclusion, @Nullable List<PackagedFood> filter) {
        if (!PackagedFood.known(typeid)) {
            return null;
        }
        if (filter == null) {
            filter = Collections.EMPTY_LIST;
        }
        ArrayList<PackagedFood> matches = new ArrayList<PackagedFood>(23);
        Collection<PackagedFood> collection = FOODS;
        synchronized (collection) {
            for (PackagedFood pf : FOODS) {
                if (!typeid.equals(pf.type()) || (!exclusion || filter.contains(pf)) && (exclusion || !filter.contains(pf))) continue;
                matches.add(pf);
            }
        }
        Collections.sort(matches);
        return matches;
    }

    public static enum Type {
        meat(1),
        bakery(272),
        vegetable(544),
        fruit(816),
        cooked_meat(1088),
        general(1360),
        powders(1632),
        liquids(1904);

        private final int _offset;

        private Type(int offset) {
            this._offset = offset;
        }

        public int shared_metaoffset() {
            return this._offset;
        }

        public static int reservedSlotCount() {
            return 128;
        }

        public static int leftoverSlotCount() {
            return 272 - Type.reservedSlotCount();
        }

        public static final int idLastUsed() {
            return 6400;
        }

        @Nullable
        public static final Type from(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

