/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.math.MathHelper;
import net.thirdparty.silentchaos512.utils.config.BooleanValue;
import net.thirdparty.silentchaos512.utils.config.IntValue;
import net.thirdparty.silentchaos512.utils.config.StringValue;
import org.apache.commons.lang3.BooleanUtils;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;
import org.jwaresoftware.mcmods.lib.impl.ModConfigBase;
import org.jwaresoftware.mcmods.lib.integration.ENVHelper;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.VanillaFoodPantry;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public final class VfpConfig
extends ModConfigBase {
    static final String _I18N = ModInfo.uilang("config.");
    static final String _GENERAL = "general.";
    static final String _BAKERY = "bakery.";
    static final String _BUTCHER = "butcher.";
    static final String _PRODUCE = "produce.";
    static final String _UPSIZER = "upsizer.";
    static final String _OTHRMOD = "integration.";
    static final String _MISC = "misc.";
    static final String _INTERNAL = "_internal_";
    private static VfpConfig _INSTANCE;
    static final ModConfigBase.Option<Boolean, BooleanValue> DEBUG_MODE;
    static final ModConfigBase.Option<Boolean, BooleanValue> OWNED_TAB;
    static final ModConfigBase.Option<Boolean, BooleanValue> SHOW_TOOLTIPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> COMPAT_MODE;
    static final ModConfigBase.Option<Boolean, BooleanValue> CRAFTING_XP;
    static final ModConfigBase.Option<Boolean, BooleanValue> GENEROUS_XP;
    static final ModConfigBase.Option<Boolean, BooleanValue> ANY_MOD_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> ORE_GEN;
    static final ModConfigBase.Option<Boolean, BooleanValue> ENRICH_LOOT;
    static final ModConfigBase.Option<String, StringValue> STRICT_PROGRESS;
    static final ModConfigBase.Option<String, StringValue> TREAT_WATER;
    static final ModConfigBase.Option<String, StringValue> SINGLE_USE_FOODS;
    static final ModConfigBase.Option<Boolean, BooleanValue> SEED_DRYING;
    static final ModConfigBase.Option<Boolean, BooleanValue> POTION_BREWING;
    static final ModConfigBase.Option<Boolean, BooleanValue> MOONSHINE_MIXING;
    static final ModConfigBase.Option<Integer, IntValue> MAX_MOONSHINE_POTIONS;
    static final ModConfigBase.Option<Integer, IntValue> MYSTERY_EFFECTS_DURATION;
    static final ModConfigBase.Option<Boolean, BooleanValue> FOOD_ONLY_CUTTERS;
    static final ModConfigBase.Option<Boolean, BooleanValue> INSTA_EAT_MORSELS;
    static final ModConfigBase.Option<Boolean, BooleanValue> INSTA_EAT_SOAKED;
    static final ModConfigBase.Option<Boolean, BooleanValue> BEARS_LUV_SALMON;
    static final ModConfigBase.Option<Integer, IntValue> MAX_DRINKS_STACKSIZE;
    static final ModConfigBase.Option<Integer, IntValue> MAX_SOUPS_STACKSIZE;
    static final ModConfigBase.Option<Boolean, BooleanValue> BAT_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> CALF_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> PIG_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> HORSE_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> WOLF_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> SQUIDD_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> POLARBEAR_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> LLAMA_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> OZELOT_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> GUARDIAN_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> ZOMBIE_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> PHANTOM_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> RAVAGER_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> ENSURE_DEATH_DROPS;
    static final ModConfigBase.Option<String, StringValue> BONE_DROPS;
    static final ModConfigBase.Option<String, StringValue> LEATHER_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> EXCLUDE_HORSE_MEAT;
    static final ModConfigBase.Option<Boolean, BooleanValue> EXCLUDE_SQUID_MEAT;
    static final ModConfigBase.Option<Boolean, BooleanValue> EXCLUDE_WOLF_MEAT;
    static final ModConfigBase.Option<Boolean, BooleanValue> EXCLUDE_POLARBEAR_MEAT;
    static final ModConfigBase.Option<Boolean, BooleanValue> EXCLUDE_LLAMA_MEAT;
    static final ModConfigBase.Option<Boolean, BooleanValue> LLAMAS_DROP_WOOL;
    static final ModConfigBase.Option<Boolean, BooleanValue> EXCLUDE_GUARDIAN_MEAT;
    static final ModConfigBase.Option<Boolean, BooleanValue> EXCLUDE_RAVAGER_MEAT;
    static final ModConfigBase.Option<Boolean, BooleanValue> MUSHROOM_PANTRY_BLOCK;
    static final ModConfigBase.Option<Boolean, BooleanValue> UPSIZE_MUSHROOM_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> ACORN_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> UGLIFRUIT_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> SPRUCETIP_DROPS;
    static final ModConfigBase.Option<Boolean, BooleanValue> HONEY_PANTRY_BLOCKS;
    static final ModConfigBase.Option<Boolean, BooleanValue> SHOW_ALL_ITEMS;
    static final ModConfigBase.Option<Boolean, BooleanValue> SHOW_DECKER_FULLTIP;
    static final ModConfigBase.Option<Boolean, BooleanValue> INTERMOD_RECIPES;
    static final ModConfigBase.Option<String, StringValue> BARTERING;
    static final ModConfigBase.Option<Boolean, BooleanValue> WARMING_COOLING_RECIPES;
    static final String _MOD_CATEGORY = "integration.vanilla.";
    static final ModConfigBase.Option<Boolean, BooleanValue> SMH_INTEGRATE;
    private ItemGroup _uiTab;

    public static final VfpConfig setInstance() {
        assert (_INSTANCE == null);
        _INSTANCE = new VfpConfig();
        return _INSTANCE;
    }

    public static final VfpConfig getInstance() {
        return _INSTANCE;
    }

    private VfpConfig() {
        super((IModInfo)ModInfo.getInstance());
    }

    public final boolean isModLoaded(String modid) {
        return ModIntegration.isPresent((String)modid);
    }

    public final boolean isDebugMode() {
        return VanillaFoodPantry.DESPERATION_DEBUG ? true : (Boolean)DEBUG_MODE.value();
    }

    private void define_isDebugMode() {
        VfpConfig.DEBUG_MODE.val = this._spec.builder(VfpConfig.DEBUG_MODE.PROPERTY).translation(this.i18n(DEBUG_MODE)).comment("INTERNAL. Development workflow enabled. Do NOT enable in regular environment.").defineFlag(((Boolean)VfpConfig.DEBUG_MODE.DFLT).booleanValue());
    }

    public boolean useOwnTab() {
        return (Boolean)OWNED_TAB.value();
    }

    private void define_useOwnTab() {
        VfpConfig.OWNED_TAB.val = this._spec.builder(VfpConfig.OWNED_TAB.PROPERTY).comment("Set to false to distribute VFP items and blocks to vanilla tabs in creative views (VFP table is removed). Enabled by default.").defineFlag(((Boolean)VfpConfig.OWNED_TAB.DFLT).booleanValue());
    }

    public void setTab(ItemGroup tab) {
        this._uiTab = tab;
        VfpUtils.setVfpTabOverride((ItemGroup)(this.useOwnTab() ? tab : null));
    }

    public ItemGroup getTab() {
        return this._uiTab;
    }

    public boolean showDocumentationTooltips() {
        return (Boolean)SHOW_TOOLTIPS.value();
    }

    private void define_showDocumentationTooltips() {
        VfpConfig.SHOW_TOOLTIPS.val = this._spec.builder(VfpConfig.SHOW_TOOLTIPS.PROPERTY).comment("Set to false to turn off documentation tooltips (status tips not affected). Enabled by default.").defineFlag(((Boolean)VfpConfig.SHOW_TOOLTIPS.DFLT).booleanValue());
    }

    public final boolean isAllowed(@Nonnull String option, boolean defaultValue) {
        if ("false".equals(option)) {
            return false;
        }
        if ("debug_recipe".equals(option)) {
            return this.isDebugMode();
        }
        if ("loot_tables".equals(option)) {
            return this.allowLootTableEnrichment();
        }
        if ("vanilla_only".equals(option)) {
            return this.strictVanillaProgression(defaultValue);
        }
        if ("vanilla_plus".equals(option)) {
            return !this.strictVanillaProgression(!defaultValue);
        }
        if ("general_cutters".equals(option)) {
            return this.allowGeneralFlintCutter();
        }
        if ("inter_mod_recipes".equals(option)) {
            return this.includeInterModRecipes();
        }
        if ("hotcold_food".equals(option)) {
            return this.allowReheatingAndChillingRecipes();
        }
        if ("spawn_eggs".equals(option)) {
            return this.allowSpawnEggCrafting() && !this.strictVanillaProgression(false);
        }
        if ("dragon_breath".equals(option)) {
            return this.allowAirSacToDragonBreathConversion() && !this.strictVanillaProgression(false);
        }
        if ("exo_boxes".equals(option)) {
            return this.allowExoBoxes() && !this.strictVanillaProgression(false);
        }
        if ("depth_pearls".equals(option)) {
            return this.allowInkPearlToEnderPearlConversion() && !this.strictVanillaProgression(false);
        }
        if ("addl_water_recipes".equals(option)) {
            return this.craftOtherSourcesOfWater();
        }
        if ("straps_as_string".equals(option)) {
            return this.hideStrapsLikeString() && !this.strictVanillaProgression(defaultValue);
        }
        return super.isAllowed(option, defaultValue);
    }

    public boolean isSuperCompatibilityMode() {
        return (Boolean)COMPAT_MODE.value();
    }

    private void define_isSuperCompatibilityMode() {
        VfpConfig.COMPAT_MODE.val = this._spec.builder(VfpConfig.COMPAT_MODE.PROPERTY).translation(this.i18n(COMPAT_MODE)).comment("Set to true to force all the basic recipes to use a mod-specific element to ensure no collisions with other mod recipes. Off by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.COMPAT_MODE.DFLT).booleanValue());
    }

    public boolean includeCraftingXp() {
        return (Boolean)CRAFTING_XP.value();
    }

    private void define_includeCraftingXp() {
        VfpConfig.CRAFTING_XP.val = this._spec.builder(VfpConfig.CRAFTING_XP.PROPERTY).comment("Set to false to disable generation of experience from crafting foods using VFP's mechanism. Note that this option does not affect cooking or mining experience drops or Xp generated by other mods. Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.CRAFTING_XP.DFLT).booleanValue());
    }

    public boolean generousCraftingXp() {
        return (Boolean)GENEROUS_XP.value();
    }

    private void define_generousCraftingXp() {
        VfpConfig.GENEROUS_XP.val = this._spec.builder(VfpConfig.GENEROUS_XP.PROPERTY).comment("Set to false to disable compensation for Minecraft ignoring small amounts of crafting Xp. Note that this option is ignored if crafting Xp is disabled. Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.GENEROUS_XP.DFLT).booleanValue());
    }

    public boolean includeModDrops() {
        return (Boolean)ANY_MOD_DROPS.value();
    }

    private void define_includeModDrops() {
        VfpConfig.ANY_MOD_DROPS.val = this._spec.builder(VfpConfig.ANY_MOD_DROPS.PROPERTY).comment("Set to false to disable -ALL- custom VFP drops from blocks and mobs unconditionally. Overrides all other settings. OFF by default. Requires restart if changed.").defineFlag(((Boolean)VfpConfig.ANY_MOD_DROPS.DFLT).booleanValue());
    }

    public boolean isOreGenerationEnabled() {
        return (Boolean)ORE_GEN.value();
    }

    private void define_isOreGenerationEnabled() {
        VfpConfig.ORE_GEN.val = this._spec.builder(VfpConfig.ORE_GEN.PROPERTY).comment("Set to false to disable generation of custom VFP ores like rock salt and natron in new worlds and new chunks. Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.ORE_GEN.DFLT).booleanValue());
    }

    public boolean allowLootTableEnrichment() {
        return (Boolean)ENRICH_LOOT.value();
    }

    private void define_allowLootTableEnrichment() {
        VfpConfig.ENRICH_LOOT.val = this._spec.builder(VfpConfig.ENRICH_LOOT.PROPERTY).comment("Set to false to disable all mod-specific additions to structure and activity loot tables. Changing this affects things like fishing and dungeon loot but NOT upsize drops (see individual options). Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.ENRICH_LOOT.DFLT).booleanValue());
    }

    public boolean strictVanillaProgression(boolean preferred_value) {
        return VfpConfig._getBooleanOrDefault((String)((String)STRICT_PROGRESS.value()), (boolean)preferred_value);
    }

    private void define_strictVanillaProgression() {
        VfpConfig.STRICT_PROGRESS.val = this._spec.builder(VfpConfig.STRICT_PROGRESS.PROPERTY).comment("Set to true to disable extra recipes and actions that allow players access to items normally tied to standard progression. For example, if true, disables recipes for blaze powder and ender pearls. Combine with other options to remove all possible vanilla progression changes.").defineString((String)VfpConfig.STRICT_PROGRESS.DFLT);
    }

    public boolean useTreatedWaterRecipes() {
        String PROPERTY = VfpConfig.TREAT_WATER.PROPERTY;
        Boolean b = (Boolean)this._cache.get(VfpConfig.TREAT_WATER.PROPERTY);
        if (b != null) {
            return b;
        }
        String p = (String)TREAT_WATER.value();
        b = Strings.isDefaultValue((String)p) ? Boolean.valueOf(ENVHelper.manageWater()) : Boolean.valueOf(BooleanUtils.toBoolean((String)p));
        this._cache.put(_GENERAL + PROPERTY, b);
        return b;
    }

    private void define_useTreatedWaterRecipes() {
        VfpConfig.TREAT_WATER.val = this._spec.builder(VfpConfig.TREAT_WATER.PROPERTY).comment("Set to true to force crafting recipes to require treated water for VFP's food recipes. Defaults false unless a mod like Tough As Nails is present. Does not require these other mods be present to set true! Requires restart if changed.").defineString((String)VfpConfig.TREAT_WATER.DFLT);
    }

    public boolean preferSingleUseFood(String what, boolean preferred_value) {
        return VfpConfig._getBooleanOrDefault((String)((String)SINGLE_USE_FOODS.value()), (boolean)preferred_value);
    }

    private void define_preferSingleUseFood() {
        VfpConfig.SINGLE_USE_FOODS.val = this._spec.builder(VfpConfig.SINGLE_USE_FOODS.PROPERTY).comment("Set to true to have VFP create single-use food items if possible. 'If possible' is defined as having a total food value less than or equal to the max food points allowed by vanilla Minecraft (20pts). Off for most multi-use capable foods by default. Requires restart if changed.").defineString((String)VfpConfig.SINGLE_USE_FOODS.DFLT);
    }

    public boolean allowSeedDrying() {
        return (Boolean)SEED_DRYING.value();
    }

    private void define_allowSeedDrying() {
        VfpConfig.SEED_DRYING.val = this._spec.builder(VfpConfig.SEED_DRYING.PROPERTY).comment("Set to false to disable seed drying from source produce. By default you can use seed drying paper to extract seeds from melons, pumpkins, wheat, and a few modded crops. Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.SEED_DRYING.DFLT).booleanValue());
    }

    public boolean includePotionBrewing() {
        return (Boolean)POTION_BREWING.value();
    }

    private void define_includePotionBrewing() {
        VfpConfig.POTION_BREWING.val = this._spec.builder(VfpConfig.POTION_BREWING.PROPERTY).comment("Set to false to disable installation of VFP's potions like Wolf's Spirit potion. Does NOT affect adhoc mixing of existing potions into moonshine potions or the temperature effects of chilled and heated foods. Enabled by default. Requires restart if changed.").defineFlag(((Boolean)VfpConfig.POTION_BREWING.DFLT).booleanValue());
    }

    public boolean allowMoonshineMixing() {
        return (Boolean)MOONSHINE_MIXING.value();
    }

    private void define_allowMoonshineMixing() {
        VfpConfig.MOONSHINE_MIXING.val = this._spec.builder(VfpConfig.MOONSHINE_MIXING.PROPERTY).comment("Set to false to disable all moonshine potions (tonics) and bootleg gelos features. Does not affect availability of VFP's custom potions. Existing items will still work. Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.MOONSHINE_MIXING.DFLT).booleanValue());
    }

    public int maxMoonshineMixCapacity() {
        return MathHelper.func_76125_a((int)((Integer)MAX_MOONSHINE_POTIONS.value()), (int)1, (int)12);
    }

    private void define_maxMoonshineMixCapacity() {
        VfpConfig.MAX_MOONSHINE_POTIONS.val = this._spec.builder(VfpConfig.MAX_MOONSHINE_POTIONS.PROPERTY).comment("Set to the max number of distinct potions allowed in a single moonshine mixture. Hard-limit is 12. Set to one (1) to disable moonshine mixing but keep potion-to-tonic conversion for stackable potions.").defineInRange(((Integer)VfpConfig.MAX_MOONSHINE_POTIONS.DFLT).intValue(), 1, 12);
    }

    public int maxMysteriousEffectDurationSecs() {
        return MathHelper.func_76125_a((int)((Integer)MYSTERY_EFFECTS_DURATION.value()), (int)15, (int)480);
    }

    private void define_maxMysteriousEffectDuration() {
        VfpConfig.MYSTERY_EFFECTS_DURATION.val = this._spec.builder(VfpConfig.MYSTERY_EFFECTS_DURATION.PROPERTY).comment("Set to the max number of seconds the effect given by a mysterious fruit salad should last. Note this value may be ignored if the given effect is an instant effect (like Healing). Limited to a range of 15s to 480s (or 8min).").defineInRange(((Integer)VfpConfig.MYSTERY_EFFECTS_DURATION.DFLT).intValue(), 15, 480);
    }

    public boolean allowGeneralFlintCutter() {
        return (Boolean)FOOD_ONLY_CUTTERS.value() == false;
    }

    private void define_allowGeneralFlintCutter() {
        VfpConfig.FOOD_ONLY_CUTTERS.val = this._spec.builder(VfpConfig.FOOD_ONLY_CUTTERS.PROPERTY).comment("Set to true to limit the use of the flint-cutter to only food RELATED recipes. Disabled by default (cutter can be used to cut things like wool blocks and leather).").defineFlag(((Boolean)VfpConfig.FOOD_ONLY_CUTTERS.DFLT).booleanValue());
    }

    public boolean allowInstaEating() {
        return (Boolean)INSTA_EAT_MORSELS.value();
    }

    private void define_allowInstaEating() {
        VfpConfig.INSTA_EAT_MORSELS.val = this._spec.builder(VfpConfig.INSTA_EAT_MORSELS.PROPERTY).comment("Set to true to allow player to instantly consume VFP morsels on right-click. Morsels are defined as any consumable item with less than 4pts of food value. Disabled by default.").defineFlag(((Boolean)VfpConfig.INSTA_EAT_MORSELS.DFLT).booleanValue());
    }

    public boolean allowInstaPotions() {
        return (Boolean)INSTA_EAT_SOAKED.value();
    }

    private void define_allowInstaPotions() {
        VfpConfig.INSTA_EAT_SOAKED.val = this._spec.builder(VfpConfig.INSTA_EAT_SOAKED.PROPERTY).comment("Set to true to allow player to instantly consume soaked VFP foods and bootleg gelos on right-click. This option is independent of the 'insta_eat_morsels' option. Does NOT apply to suspicious stews or mysterious fruit salads. Disabled by default.").defineFlag(((Boolean)VfpConfig.INSTA_EAT_SOAKED.DFLT).booleanValue());
    }

    public boolean allowPolarbearBreeding() {
        return (Boolean)BEARS_LUV_SALMON.value();
    }

    private void define_allowPolarbearBreeding() {
        VfpConfig.BEARS_LUV_SALMON.val = this._spec.builder(VfpConfig.BEARS_LUV_SALMON.PROPERTY).comment("Set to false to disable breeding polar bears with raw salmon. Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.BEARS_LUV_SALMON.DFLT).booleanValue());
    }

    public VfpCapacity maxDrinksStackCapacity(VfpCapacity defaultSize) {
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get(VfpConfig.MAX_DRINKS_STACKSIZE.PROPERTY));
        if (n != null) {
            return n;
        }
        n = VfpCapacity.fromConfig((Integer)MAX_DRINKS_STACKSIZE.value(), defaultSize);
        this._cache.put(VfpConfig.MAX_DRINKS_STACKSIZE.PROPERTY, n);
        return n;
    }

    private void define_maxDrinksStackCapacity() {
        VfpConfig.MAX_DRINKS_STACKSIZE.val = this._spec.builder(VfpConfig.MAX_DRINKS_STACKSIZE.PROPERTY).comment("Max stack size for all bottled items like fizzy drinks and juices. Default stack size is " + VfpCapacity.LIQUID_STACK.count() + ". Allowed sizes are [1,4,8,16,24,32,64].").defineInRange(((Integer)VfpConfig.MAX_DRINKS_STACKSIZE.DFLT).intValue(), 1, 64);
    }

    public VfpCapacity maxSoupsStackCapacity(VfpCapacity defaultSize) {
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get(VfpConfig.MAX_SOUPS_STACKSIZE.PROPERTY));
        if (n != null) {
            return n;
        }
        n = VfpCapacity.fromConfig((Integer)MAX_SOUPS_STACKSIZE.value(), defaultSize);
        this._cache.put(VfpConfig.MAX_SOUPS_STACKSIZE.PROPERTY, n);
        return n;
    }

    private void define_maxSoupsStackCapacity() {
        VfpConfig.MAX_SOUPS_STACKSIZE.val = this._spec.builder(VfpConfig.MAX_SOUPS_STACKSIZE.PROPERTY).comment("Max stack size for all soupy items like creamy soups, chowders, and stews. Default stack size is " + VfpCapacity.LIQUID_STACK.count() + ". Allowed sizes are [1,4,8,16,24,32,64].").defineInRange(((Integer)VfpConfig.MAX_SOUPS_STACKSIZE.DFLT).intValue(), 1, 64);
    }

    public boolean includeBatDrops() {
        return (Boolean)BAT_DROPS.value();
    }

    private void define_includeBatDrops() {
        VfpConfig.BAT_DROPS.val = this._spec.builder(VfpConfig.BAT_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing a bat. VFP adds bat meat, bat poop (use like bonemeal or to create rotten flesh), and special drops for potions. Enabled by default.").defineFlag(((Boolean)VfpConfig.BAT_DROPS.DFLT).booleanValue());
    }

    public boolean includeCalfDrops() {
        return (Boolean)CALF_DROPS.value();
    }

    private void define_includeCalfDrops() {
        VfpConfig.CALF_DROPS.val = this._spec.builder(VfpConfig.CALF_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing baby cows. VFP adds calf stomach lining for use in creating curdling agent for cheese. Enabled by default.").defineFlag(((Boolean)VfpConfig.CALF_DROPS.DFLT).booleanValue());
    }

    public boolean includePigDrops() {
        return (Boolean)PIG_DROPS.value();
    }

    private void define_includePigDrops() {
        VfpConfig.PIG_DROPS.val = this._spec.builder(VfpConfig.PIG_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing pigs. VFP adds drops like raw pork hocks and pig tails for intriguing culinary delights. Enabled by default.").defineFlag(((Boolean)VfpConfig.PIG_DROPS.DFLT).booleanValue());
    }

    public boolean includeHorseDrops() {
        return (Boolean)HORSE_DROPS.value();
    }

    private void define_includeHorseDrops() {
        VfpConfig.HORSE_DROPS.val = this._spec.builder(VfpConfig.HORSE_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing horses. VFP adds drops like raw horse meat and horse tears for brewing potions. Enabled by default.").defineFlag(((Boolean)VfpConfig.HORSE_DROPS.DFLT).booleanValue());
    }

    public boolean includeWolfDrops() {
        return (Boolean)WOLF_DROPS.value();
    }

    private void define_includeWolfDrops() {
        VfpConfig.WOLF_DROPS.val = this._spec.builder(VfpConfig.WOLF_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing wolves (tamed and untamed). VFP adds raw wolf meat and special drops for custom potions. Enabled by default.").defineFlag(((Boolean)VfpConfig.WOLF_DROPS.DFLT).booleanValue());
    }

    public boolean includeSquidDrops() {
        return (Boolean)SQUIDD_DROPS.value();
    }

    private void define_includeSquidDrops() {
        VfpConfig.SQUIDD_DROPS.val = this._spec.builder(VfpConfig.SQUIDD_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing squid. VFP adds raw squid meat and ink pearl fragment drops from squid. Enabled by default.").defineFlag(((Boolean)VfpConfig.SQUIDD_DROPS.DFLT).booleanValue());
    }

    public boolean includePolarBearDrops() {
        return (Boolean)POLARBEAR_DROPS.value();
    }

    private void define_includePolarBearDrops() {
        VfpConfig.POLARBEAR_DROPS.val = this._spec.builder(VfpConfig.POLARBEAR_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing polar bears. VFP adds raw  bear meat and special drops for custom potions. Enabled by default.").defineFlag(((Boolean)VfpConfig.POLARBEAR_DROPS.DFLT).booleanValue());
    }

    public boolean includeLlamaDrops() {
        return (Boolean)LLAMA_DROPS.value();
    }

    private void define_includeLlamaDrops() {
        VfpConfig.LLAMA_DROPS.val = this._spec.builder(VfpConfig.LLAMA_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing llamas. VFP adds raw llama meat and fleece (like wool) blocks. Enabled by default.").defineFlag(((Boolean)VfpConfig.LLAMA_DROPS.DFLT).booleanValue());
    }

    public boolean includeOcelotDrops() {
        return (Boolean)OZELOT_DROPS.value();
    }

    private void define_includeOcelotDrops() {
        VfpConfig.OZELOT_DROPS.val = this._spec.builder(VfpConfig.OZELOT_DROPS.PROPERTY).comment("Set to false to disable the ability to steal lives from ocelots as Felis Life Essence. Also controls Bane of Ocelot drop from creepers. Enabled by default.").defineFlag(((Boolean)VfpConfig.OZELOT_DROPS.DFLT).booleanValue());
    }

    public boolean includeGuardianDrops() {
        return (Boolean)GUARDIAN_DROPS.value();
    }

    private void define_includeGuardianDrops() {
        VfpConfig.GUARDIAN_DROPS.val = this._spec.builder(VfpConfig.GUARDIAN_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing guardians and elder guardians. VFP adds guardian air sacs, tail fins, meat, and other items. Enabled by default.").defineFlag(((Boolean)VfpConfig.GUARDIAN_DROPS.DFLT).booleanValue());
    }

    public boolean includeZombieDrops() {
        return (Boolean)ZOMBIE_DROPS.value();
    }

    private void define_includeZombieDrops() {
        VfpConfig.ZOMBIE_DROPS.val = this._spec.builder(VfpConfig.ZOMBIE_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing zombies of all kinds. VFP adds tainted souls for use with Felis Life Essence in potion brewing. Enabled by default.").defineFlag(((Boolean)VfpConfig.ZOMBIE_DROPS.DFLT).booleanValue());
    }

    public boolean includePhantomDrops() {
        return (Boolean)PHANTOM_DROPS.value();
    }

    private void define_includePhantomDrops() {
        VfpConfig.PHANTOM_DROPS.val = this._spec.builder(VfpConfig.PHANTOM_DROPS.PROPERTY).comment("Set to true to enable mod drops from killing phantoms. VFP adds phantom meat and other items used in potion brewing. Disabled by default.").defineFlag(((Boolean)VfpConfig.PHANTOM_DROPS.DFLT).booleanValue());
    }

    public boolean includeRavagerDrops() {
        return (Boolean)RAVAGER_DROPS.value();
    }

    private void define_includeRavagerDrops() {
        VfpConfig.RAVAGER_DROPS.val = this._spec.builder(VfpConfig.RAVAGER_DROPS.PROPERTY).comment("Set to false to disable mod drops from killing ravager beasts. VFP adds ravager meat, bones, and other items used in potion brewing. Enabled by default.").defineFlag(((Boolean)VfpConfig.RAVAGER_DROPS.DFLT).booleanValue());
    }

    public boolean ensureDeathDrops() {
        return (Boolean)ENSURE_DEATH_DROPS.value();
    }

    private void define_ensureDeathDrops() {
        VfpConfig.ENSURE_DEATH_DROPS.val = this._spec.builder(VfpConfig.ENSURE_DEATH_DROPS.PROPERTY).comment("Set to true to guarantee a minimum amount of items are dropped from killing cows, pigs, sheep, etc. The meat drop increase is from 0 to 3 more pieces with other items like hides, feathers, shells, and bones also guaranteed (1 per kill) unless blocked by another config option. This option applies to standard Minecraft mobs only. Enabled by default; requires restart if changed. Ignored if mod drops disabled.").defineFlag(((Boolean)VfpConfig.ENSURE_DEATH_DROPS.DFLT).booleanValue());
    }

    public boolean includeBoneDrops() {
        Boolean b = (Boolean)this._cache.get(VfpConfig.BONE_DROPS.PROPERTY);
        if (b != null) {
            return b;
        }
        b = true;
        String p = (String)BONE_DROPS.value();
        if (Strings.isDefaultValue((String)p)) {
            if (this.isSuperCompatibilityMode()) {
                b = false;
            }
        } else {
            b = BooleanUtils.toBoolean((String)p);
        }
        this._cache.put(VfpConfig.BONE_DROPS.PROPERTY, b);
        return b;
    }

    private void define_includeBoneDrops() {
        VfpConfig.BONE_DROPS.val = this._spec.builder(VfpConfig.BONE_DROPS.PROPERTY).comment("Set to true to enable mod bone drops regardless of the other mods present and super-compatibility mode setting. Leave as *DEFAULT* to let VFP decide if bone drops are appropriate per animal type. Requires game restart if changed.").defineString((String)VfpConfig.BONE_DROPS.DFLT);
    }

    public boolean includeLeatherDrops() {
        Boolean b = (Boolean)this._cache.get(VfpConfig.LEATHER_DROPS.PROPERTY);
        if (b != null) {
            return b;
        }
        b = true;
        String p = (String)LEATHER_DROPS.value();
        if (Strings.isDefaultValue((String)p)) {
            if (this.isSuperCompatibilityMode() || this.strictVanillaProgression(false)) {
                b = false;
            }
        } else {
            b = BooleanUtils.toBoolean((String)p);
        }
        this._cache.put(VfpConfig.LEATHER_DROPS.PROPERTY, b);
        return b;
    }

    private void define_includeLeatherDrops() {
        VfpConfig.LEATHER_DROPS.val = this._spec.builder(VfpConfig.LEATHER_DROPS.PROPERTY).comment("Set to false to completely disable mod leather drops. Leave as *DEFAULT* to let VFP decide if leather drops are appropriate per animal type. Note that super-compatibility mode defines the default value to be false. Requires game restart if changed.").defineString((String)VfpConfig.LEATHER_DROPS.DFLT);
    }

    public boolean excludeHorseMeatDrops() {
        return (Boolean)EXCLUDE_HORSE_MEAT.value();
    }

    private void define_excludeHorseMeatDrops() {
        VfpConfig.EXCLUDE_HORSE_MEAT.val = this._spec.builder(VfpConfig.EXCLUDE_HORSE_MEAT.PROPERTY).comment("Set to true to disable ONLY meat drops from killing horses when 'include_horse_drops' is enabled; ignored otherwise. Use if you have another mod that already drops horse meat.").defineFlag(((Boolean)VfpConfig.EXCLUDE_HORSE_MEAT.DFLT).booleanValue());
    }

    public boolean excludeSquidMeatDrops() {
        return (Boolean)EXCLUDE_SQUID_MEAT.value();
    }

    private void define_excludeSquidMeatDrops() {
        VfpConfig.EXCLUDE_SQUID_MEAT.val = this._spec.builder(VfpConfig.EXCLUDE_SQUID_MEAT.PROPERTY).comment("Set to true to disable ONLY meat drops from killing squid when 'include_squid_drops' is enabled; ignored otherwise. Use if you have another mod that already drops squid meat.").defineFlag(((Boolean)VfpConfig.EXCLUDE_SQUID_MEAT.DFLT).booleanValue());
    }

    public boolean excludeWolfMeatDrops() {
        return (Boolean)EXCLUDE_WOLF_MEAT.value();
    }

    private void define_excludeWolfMeatDrops() {
        VfpConfig.EXCLUDE_WOLF_MEAT.val = this._spec.builder(VfpConfig.EXCLUDE_WOLF_MEAT.PROPERTY).comment("Set to true to disable ONLY meat drops from killing wolves when 'include_wolf_drops' is enabled; ignored otherwise. Use if you have another mod that already drops wolf meat.").defineFlag(((Boolean)VfpConfig.EXCLUDE_WOLF_MEAT.DFLT).booleanValue());
    }

    public boolean excludePolarBearMeatDrops() {
        return (Boolean)EXCLUDE_POLARBEAR_MEAT.value();
    }

    private void define_excludePolarBearMeatDrops() {
        VfpConfig.EXCLUDE_POLARBEAR_MEAT.val = this._spec.builder(VfpConfig.EXCLUDE_POLARBEAR_MEAT.PROPERTY).comment("Set to true to disable ONLY meat drops from killing polar bears when 'include_polarbear_drops' is enabled; ignored otherwise. Use if you have another mod that already drops polar bear meat.").defineFlag(((Boolean)VfpConfig.EXCLUDE_POLARBEAR_MEAT.DFLT).booleanValue());
    }

    public boolean excludeLlamaMeatDrops() {
        return (Boolean)EXCLUDE_LLAMA_MEAT.value();
    }

    private void define_excludeLlamaMeatDrops() {
        VfpConfig.EXCLUDE_LLAMA_MEAT.val = this._spec.builder(VfpConfig.EXCLUDE_LLAMA_MEAT.PROPERTY).comment("Set to true to disable ONLY meat drops from killing llamas when 'include_llama_drops' is enabled; ignored otherwise. Use if you have another mod that already drops llama meat.").defineFlag(((Boolean)VfpConfig.EXCLUDE_LLAMA_MEAT.DFLT).booleanValue());
    }

    public boolean llamasDropRegularWool() {
        return (Boolean)LLAMAS_DROP_WOOL.value();
    }

    private void define_llamasDropRegularWool() {
        VfpConfig.LLAMAS_DROP_WOOL.val = this._spec.builder(VfpConfig.LLAMAS_DROP_WOOL.PROPERTY).comment("Set to true to have llamas drop regular (sheep) wool blocks instead of the custom VFP fleece wool blocks. Disabled by default. Ignored if llama drops in general are disabled.").defineFlag(((Boolean)VfpConfig.LLAMAS_DROP_WOOL.DFLT).booleanValue());
    }

    public boolean excludeGuardianMeatDrops() {
        return (Boolean)EXCLUDE_GUARDIAN_MEAT.value();
    }

    private void define_excludeGuardianMeatDrops() {
        VfpConfig.EXCLUDE_GUARDIAN_MEAT.val = this._spec.builder(VfpConfig.EXCLUDE_GUARDIAN_MEAT.PROPERTY).comment("Set to true to disable ONLY meat drops from killing guardians when 'include_guardian_drops' is enabled; ignored otherwise. Use if you're interested in tail fins and air sac drops only.").defineFlag(((Boolean)VfpConfig.EXCLUDE_GUARDIAN_MEAT.DFLT).booleanValue());
    }

    public boolean excludeRavagerMeatDrops() {
        return (Boolean)EXCLUDE_RAVAGER_MEAT.value();
    }

    private void define_excludeRavagerMeatDrops() {
        VfpConfig.EXCLUDE_RAVAGER_MEAT.val = this._spec.builder(VfpConfig.EXCLUDE_RAVAGER_MEAT.PROPERTY).comment("Set to true to disable ONLY meat drops from killing ravagers when 'include_ravager_drops' is enabled; ignored otherwise. Use if you're interested in bone, hide, and horn drops only.").defineFlag(((Boolean)VfpConfig.EXCLUDE_RAVAGER_MEAT.DFLT).booleanValue());
    }

    public boolean useMushroomBlocksForPantry() {
        return (Boolean)MUSHROOM_PANTRY_BLOCK.value();
    }

    private void define_useMushroomBlocksForPantry() {
        VfpConfig.MUSHROOM_PANTRY_BLOCK.val = this._spec.builder(VfpConfig.MUSHROOM_PANTRY_BLOCK.PROPERTY).comment("Set to true to enable (un)crafting of 9 mushrooms from standard mushroom blocks. If enabled you can increase storage size of mushrooms per slot and unlock all the mushroomy goodness of giant mushrooms! Disabled by default.").defineFlag(((Boolean)VfpConfig.MUSHROOM_PANTRY_BLOCK.DFLT).booleanValue());
    }

    public boolean increaseShroomDrops() {
        return (Boolean)UPSIZE_MUSHROOM_DROPS.value();
    }

    private void define_increaseShroomDrops() {
        VfpConfig.UPSIZE_MUSHROOM_DROPS.val = this._spec.builder(VfpConfig.UPSIZE_MUSHROOM_DROPS.PROPERTY).comment("Set to false to disable additional mushroom drops from chopping down huge mushrooms with a butchering axe or other tool with fortune enchantment. Also adds mushrooms to mooshroom drops. Enabled by default. Needs restart if changed.").defineFlag(((Boolean)VfpConfig.UPSIZE_MUSHROOM_DROPS.DFLT).booleanValue());
    }

    public boolean includeAcornDrops() {
        return (Boolean)ACORN_DROPS.value();
    }

    private void define_includeAcornDrops() {
        VfpConfig.ACORN_DROPS.val = this._spec.builder(VfpConfig.ACORN_DROPS.PROPERTY).comment("Set to false to stop acorn drops when you break oak and dark-oak leaves. Will not disable acornmeal based recipes (as acorns can be obtained from other mods). Enabled by default.").defineFlag(((Boolean)VfpConfig.ACORN_DROPS.DFLT).booleanValue());
    }

    public boolean includeUgliFruitDrops() {
        return (Boolean)UGLIFRUIT_DROPS.value();
    }

    private void define_includeUgliFruitDrops() {
        VfpConfig.UGLIFRUIT_DROPS.val = this._spec.builder(VfpConfig.UGLIFRUIT_DROPS.PROPERTY).comment("Set to false to stop raftugli fruit drops when you break jungle leaves. Enabled by default.").defineFlag(((Boolean)VfpConfig.UGLIFRUIT_DROPS.DFLT).booleanValue());
    }

    public boolean includeSpruceTipDrops() {
        return (Boolean)SPRUCETIP_DROPS.value();
    }

    private void define_includeSpruceTipDrops() {
        VfpConfig.SPRUCETIP_DROPS.val = this._spec.builder(VfpConfig.SPRUCETIP_DROPS.PROPERTY).comment("Set to false to stop spruce tip drops when you break spruce leaves. Enabled by default.").defineFlag(((Boolean)VfpConfig.SPRUCETIP_DROPS.DFLT).booleanValue());
    }

    public boolean useHoneyBlocksForPantry() {
        return (Boolean)HONEY_PANTRY_BLOCKS.value();
    }

    private void define_useHoneyBlocksForPantry() {
        VfpConfig.HONEY_PANTRY_BLOCKS.val = this._spec.builder(VfpConfig.HONEY_PANTRY_BLOCKS.PROPERTY).comment("Set to false to disable (un)crafting of 4 honeycombs from standard honeycomb blocks and the reheating of honey blocks back into liquid form (honey buckets). If enabled you can use both honey and honeycomb blocks as a simple storage block for all your honey! Enabled by default.").defineFlag(((Boolean)VfpConfig.HONEY_PANTRY_BLOCKS.DFLT).booleanValue());
    }

    public boolean showAllItemsInUI() {
        return (Boolean)SHOW_ALL_ITEMS.value() != false || this.isDebugMode();
    }

    private void define_showAllItemsInUI() {
        VfpConfig.SHOW_ALL_ITEMS.val = this._spec.builder(VfpConfig.SHOW_ALL_ITEMS.PROPERTY).comment("Set to true to show all of the mod's items whether or not they are directly obtainable by the player using a VFP-made recipe. This option is useful if you want to see what items are available when requisite food or materials are provided by other means like merchants, quests, etc. Disabled by default.").defineFlag(((Boolean)VfpConfig.SHOW_ALL_ITEMS.DFLT).booleanValue());
    }

    public boolean showDeckerIngredients() {
        return (Boolean)SHOW_DECKER_FULLTIP.value() != false || this.isDebugMode();
    }

    private void define_showDeckerIngredients() {
        VfpConfig.SHOW_DECKER_FULLTIP.val = this._spec.builder(VfpConfig.SHOW_DECKER_FULLTIP.PROPERTY).comment("Set to false to disable decker sandwich ingredient (name) tooltips. If enabled you will see the name of each food item that went into your decker sandwich. Overrides the general 'show_doc_tooltips' option. Enabled by default.").defineFlag(((Boolean)VfpConfig.SHOW_DECKER_FULLTIP.DFLT).booleanValue());
    }

    public boolean includeInterModRecipes() {
        return (Boolean)INTERMOD_RECIPES.value();
    }

    private void define_includeInterModRecipes() {
        VfpConfig.INTERMOD_RECIPES.val = this._spec.builder(VfpConfig.INTERMOD_RECIPES.PROPERTY).comment("Set to false to disable direct recipe making with non-vanilla and non-VFP foodstuffs (for example using Harvestcraft DIRECTLY). Does not affect tag-based recipe ingredients. Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.INTERMOD_RECIPES.DFLT).booleanValue());
    }

    public boolean includeBartering(boolean preferred_value) {
        return VfpConfig._getBooleanOrDefault((String)((String)BARTERING.value()), (boolean)preferred_value);
    }

    private void define_includeBartering() {
        VfpConfig.BARTERING.val = this._spec.builder(VfpConfig.BARTERING.PROPERTY).comment("Set to false to disable direct integration with villager merchant trades tables and trading mods like FarmingForBlockheads. Leave as '*DEFAULT*' to permit trading depending on context and availability of other mods.").defineString((String)VfpConfig.BARTERING.DFLT);
    }

    public boolean allowReheatingAndChillingRecipes() {
        return (Boolean)WARMING_COOLING_RECIPES.value();
    }

    private void define_includeReheatingAndChillingRecipes() {
        VfpConfig.WARMING_COOLING_RECIPES.val = this._spec.builder(VfpConfig.WARMING_COOLING_RECIPES.PROPERTY).comment("Set to false to disable builtin reheating and chilling recipes. You can still provide hot/cold foods via loot tables, trading, and shops (modded). This option does NOT alter any bonus effects from consuming such foods. Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.WARMING_COOLING_RECIPES.DFLT).booleanValue());
    }

    private void define_getVanillaProgressionOption(String PROPERTY, boolean defaultValue, String commentString) {
        String property = _MOD_CATEGORY + PROPERTY;
        ModConfigBase.Option option = new ModConfigBase.Option(PROPERTY, _MOD_CATEGORY, (Object)defaultValue);
        option.val = this._spec.builder(property).comment(commentString).defineFlag(defaultValue);
        this._cache.put(_INTERNAL + PROPERTY, option);
    }

    private boolean getVanillaProgressionOption(String PROPERTY, boolean errorValue) {
        String property = _INTERNAL + PROPERTY;
        ModConfigBase.Option option = (ModConfigBase.Option)this._cache.get(property);
        return option != null ? (Boolean)option.value() : errorValue;
    }

    private void define_craftOtherSourcesOfWater() {
        this.define_getVanillaProgressionOption("extra_water_crafting", true, "Set to false to disable extra craft recipes for water buckets and bottles; for instance the recipe to convert ice blocks to buckets of water.");
    }

    public boolean craftOtherSourcesOfWater() {
        return this.getVanillaProgressionOption("extra_water_crafting", false);
    }

    private void define_allowInkPearlToEnderPearlConversion() {
        this.define_getVanillaProgressionOption("ink_pearls_to_ender_pearls", true, "Set to false to disable smelting of Ink Pearls to ender pearls. Ignored if strict vanilla progression enabled.");
    }

    public boolean allowInkPearlToEnderPearlConversion() {
        return this.getVanillaProgressionOption("ink_pearls_to_ender_pearls", false);
    }

    private void define_allowLavaSandToBlazeRodConversion() {
        this.define_getVanillaProgressionOption("lava_sand_to_blaze_rods", true, "Set to false to disable crafting of Lava Sand to blaze rods, magma cream, fire charges, and eyes of ender. Basically affects any recipe that uses lava sand instead of blaze powder. Ignored if strict vanilla progression enabled.");
    }

    public boolean allowLavaSandToBlazeRodConversion() {
        return this.getVanillaProgressionOption("lava_sand_to_blaze_rods", false);
    }

    private void define_allowAirSacToDragonBreathConversion() {
        this.define_getVanillaProgressionOption("airsac_to_dragon_breath", true, "Set to false to disable crafting of dragon's breath using Guardian Air Sacs. Ignored if strict vanilla progression or guardian drops are disabled.");
    }

    public boolean allowAirSacToDragonBreathConversion() {
        return this.getVanillaProgressionOption("airsac_to_dragon_breath", false);
    }

    private void define_increaseWoolDrops() {
        this.define_getVanillaProgressionOption("upsized_wool_drops", true, "Set to false to disable upsizing of wool drops from sheep-- VFP will no longer ensure at least 3 wool blocks are dropped per kill. Ignored if strict vanilla progression or general drops upsizing option disabled.");
    }

    public boolean increaseWoolDrops() {
        return this.getVanillaProgressionOption("upsized_wool_drops", true);
    }

    private void define_allowExoBoxes() {
        this.define_getVanillaProgressionOption("guardian_fins_to_shulkerbox", true, "Set to false to disable crafting of 'Exo' shulker boxes using guardian drops. Ignored if strict vanilla progression or guardian drops are disabled.");
    }

    public boolean allowExoBoxes() {
        return this.getVanillaProgressionOption("guardian_fins_to_shulkerbox", false);
    }

    private void define_allowSpawnEggCrafting() {
        this.define_getVanillaProgressionOption("spawnegg_crafting", false, "Set to true to enable Felis Life Essence based craft recipes for some spawn eggs. Disabled by default; requires restart if changed. Ignored if strict vanilla progression is enabled.");
    }

    public boolean allowSpawnEggCrafting() {
        return this.getVanillaProgressionOption("spawnegg_crafting", false);
    }

    private void define_hideStrapsLikeString() {
        this.define_getVanillaProgressionOption("straps_as_string", true, "Set to false to disable substitution of Animal Hide Straps as 'string' in some recipes. Ignored if strict vanilla progression is enabled.");
    }

    public boolean hideStrapsLikeString() {
        return this.getVanillaProgressionOption("straps_as_string", true);
    }

    private void define_canDispenseWoodenBowls() {
        this.define_getVanillaProgressionOption("dispense_wooden_bowls", true, "Set to false to disable the ability to dispense empty wooden bowls to pick up honey, water, and milk. Ignored if strict vanilla progression is enabled.");
    }

    public boolean canDispenseWoodenBowls() {
        return this.getVanillaProgressionOption("dispense_wooden_bowls", true);
    }

    public boolean isAutocraftingEnabled() {
        return (Boolean)SMH_INTEGRATE.value();
    }

    private void define_isAutocraftingEnabled() {
        VfpConfig.SMH_INTEGRATE.val = this._spec.builder(VfpConfig.SMH_INTEGRATE.PROPERTY).comment("Set to false to disable integration with SmartHoppers mod's various auto-crafting hoppers. Enabled by default; requires restart if changed.").defineFlag(((Boolean)VfpConfig.SMH_INTEGRATE.DFLT).booleanValue());
    }

    public static final boolean manageThirst() {
        return true;
    }

    public static final boolean manageTemperature() {
        return true;
    }

    public void setRecipeFlagsEarly() {
        super.setRecipeFlagsEarly();
        Tooltips.setHidden((ModIntegration)ModInfo.ID, (!this.showDocumentationTooltips() ? 1 : 0) != 0);
        this.setRecipeFlag(this.allowInkPearlToEnderPearlConversion(), "ender_pearl_recipes");
        this.setRecipeFlag(this.allowLavaSandToBlazeRodConversion(), "blazerod_recipes");
        this.setRecipeFlag(this.allowAirSacToDragonBreathConversion(), "dragonbreath_recipe");
        this.setRecipeFlag(this.allowExoBoxes(), "exo_boxes");
        this.setRecipeFlag(this.includePotionBrewing(), "potion_brewing");
        this.setRecipeFlag(this.includeModDrops(), "mod_drops");
        this.setRecipeFlag(this.includeInterModRecipes(), "inter_mod_recipes");
        this.setRecipeFlag(this.useTreatedWaterRecipes(), "treated_water");
        this.setRecipeFlag(this.useMushroomBlocksForPantry(), "mushroom_block_storage");
        this.setRecipeFlag(this.useHoneyBlocksForPantry(), "honey_blocks_storage");
        this.setRecipeFlag(this.allowSeedDrying(), "seed_drying");
        this.setRecipeFlag(this.allowSpawnEggCrafting(), "craftable_spawneggs");
        this.setRecipeFlag(this.allowMoonshineMixing(), "moonshine_mixing");
        this.setRecipeFlag(this.allowGeneralFlintCutter(), "general_cutters");
        this.setRecipeFlag(this.allowReheatingAndChillingRecipes(), "hotcold_food");
        this.setRecipeFlag(this.allowInstaEating(), "insta_eat");
        this.setRecipeFlag(this.allowInstaPotions(), "insta_potion");
        this.setRecipeFlag(this.craftOtherSourcesOfWater(), "addl_water_recipes");
        this.setRecipeFlag(this.hideStrapsLikeString(), "straps_as_string");
        this.setRecipeFlag(this.includeBatDrops(), "bat_drops");
        this.setRecipeFlag(this.includeCalfDrops(), "calf_drops");
        this.setRecipeFlag(this.includePigDrops(), "pig_drops");
        this.setRecipeFlag(this.includeHorseDrops(), "horse_drops");
        this.setRecipeFlag(!this.excludeHorseMeatDrops(), "horse_meat");
        this.setRecipeFlag(this.includeWolfDrops(), "wolf_drops");
        this.setRecipeFlag(!this.excludeWolfMeatDrops(), "wolf_meat");
        this.setRecipeFlag(this.includeSquidDrops(), "squid_drops");
        this.setRecipeFlag(!this.excludeSquidMeatDrops(), "squid_meat");
        this.setRecipeFlag(this.includePolarBearDrops(), "polarbear_drops");
        this.setRecipeFlag(!this.excludePolarBearMeatDrops(), "polarbear_meat");
        this.setRecipeFlag(this.includeLlamaDrops(), "llama_drops");
        this.setRecipeFlag(!this.excludeLlamaMeatDrops(), "llama_meat");
        this.setRecipeFlag(this.includeOcelotDrops(), "ocelot_drops");
        this.setRecipeFlag(this.includeGuardianDrops(), "guardian_drops");
        this.setRecipeFlag(!this.excludeGuardianMeatDrops(), "guardian_meat");
        this.setRecipeFlag(this.includeZombieDrops(), "zombie_drops");
        this.setRecipeFlag(this.includePhantomDrops(), "phantom_drops");
        this.setRecipeFlag(this.includeRavagerDrops(), "ravager_drops");
        this.setRecipeFlag(this.includeAcornDrops(), "acorn_drops");
        this.setRecipeFlag(this.includeUgliFruitDrops(), "ugli_drops");
        this.setRecipeFlag(this.includeSpruceTipDrops(), "sprucetips");
    }

    protected void fullyDefineInternal() {
        this.define_isDebugMode();
        this.define_useOwnTab();
        this.define_isSuperCompatibilityMode();
        this.define_showDocumentationTooltips();
        this.define_strictVanillaProgression();
        this.define_includeCraftingXp();
        this.define_includePotionBrewing();
        this.define_includeModDrops();
        this.define_generousCraftingXp();
        this.define_isOreGenerationEnabled();
        this.define_allowLootTableEnrichment();
        this.define_preferSingleUseFood();
        this.define_includeBoneDrops();
        this.define_includeLeatherDrops();
        this.define_ensureDeathDrops();
        this.define_includeBatDrops();
        this.define_includeCalfDrops();
        this.define_includePigDrops();
        this.define_includeHorseDrops();
        this.define_includeWolfDrops();
        this.define_includeSquidDrops();
        this.define_includePolarBearDrops();
        this.define_includeLlamaDrops();
        this.define_includeOcelotDrops();
        this.define_includeGuardianDrops();
        this.define_includeZombieDrops();
        this.define_includePhantomDrops();
        this.define_includeRavagerDrops();
        this.define_allowGeneralFlintCutter();
        this.define_excludeHorseMeatDrops();
        this.define_excludeSquidMeatDrops();
        this.define_excludeWolfMeatDrops();
        this.define_excludePolarBearMeatDrops();
        this.define_excludeLlamaMeatDrops();
        this.define_excludeGuardianMeatDrops();
        this.define_excludeRavagerMeatDrops();
        this._spec.builder("integration.vanilla").comment("These options can affect typical vanilla progression");
        this.define_showAllItemsInUI();
        this.define_includeInterModRecipes();
        this.define_includeBartering();
        this.define_useTreatedWaterRecipes();
        this.define_increaseWoolDrops();
        this.define_llamasDropRegularWool();
        this.define_allowPolarbearBreeding();
        this.define_allowInkPearlToEnderPearlConversion();
        this.define_allowLavaSandToBlazeRodConversion();
        this.define_allowAirSacToDragonBreathConversion();
        this.define_allowExoBoxes();
        this.define_hideStrapsLikeString();
        this.define_maxDrinksStackCapacity();
        this.define_maxSoupsStackCapacity();
        this.define_craftOtherSourcesOfWater();
        this.define_useMushroomBlocksForPantry();
        this.define_useHoneyBlocksForPantry();
        this.define_canDispenseWoodenBowls();
        this.define_increaseShroomDrops();
        this.define_includeAcornDrops();
        this.define_includeUgliFruitDrops();
        this.define_includeSpruceTipDrops();
        this.define_isAutocraftingEnabled();
        this.define_showDeckerIngredients();
        this.define_includeReheatingAndChillingRecipes();
        this.define_allowSeedDrying();
        this.define_allowSpawnEggCrafting();
        this.define_allowMoonshineMixing();
        this.define_maxMoonshineMixCapacity();
        this.define_maxMysteriousEffectDuration();
        this.define_allowInstaEating();
        this.define_allowInstaPotions();
    }

    static {
        DEBUG_MODE = new ModConfigBase.Option("debug_mode", _GENERAL, (Object)false);
        OWNED_TAB = new ModConfigBase.Option("use_custom_tab", _GENERAL, (Object)true);
        SHOW_TOOLTIPS = new ModConfigBase.Option("show_doc_tooltips", _GENERAL, (Object)true);
        COMPAT_MODE = new ModConfigBase.Option("super_compatibility_mode", _GENERAL, (Object)false);
        CRAFTING_XP = new ModConfigBase.Option("crafting_xp_enabled", _GENERAL, (Object)true);
        GENEROUS_XP = new ModConfigBase.Option("generous_xp", _GENERAL, (Object)true);
        ANY_MOD_DROPS = new ModConfigBase.Option("drops_enabled", _GENERAL, (Object)true);
        ORE_GEN = new ModConfigBase.Option("ore_generate_enabled", _GENERAL, (Object)true);
        ENRICH_LOOT = new ModConfigBase.Option("enrich_loot_tables", _GENERAL, (Object)true);
        STRICT_PROGRESS = new ModConfigBase.Option("strict_progression", _GENERAL, (Object)"*DEFAULT*");
        TREAT_WATER = new ModConfigBase.Option("treat_raw_water", _GENERAL, (Object)"*DEFAULT*");
        SINGLE_USE_FOODS = new ModConfigBase.Option("prefer_singleuse", _GENERAL, (Object)"*DEFAULT*");
        SEED_DRYING = new ModConfigBase.Option("seed_drying_enabled", _GENERAL, (Object)true);
        POTION_BREWING = new ModConfigBase.Option("potions_enabled", _GENERAL, (Object)true);
        MOONSHINE_MIXING = new ModConfigBase.Option("moonshine_mixing_enabled", _GENERAL, (Object)true);
        MAX_MOONSHINE_POTIONS = new ModConfigBase.Option("moonshine_max_potions", _UPSIZER, (Object)7);
        MYSTERY_EFFECTS_DURATION = new ModConfigBase.Option("mystery_effects_duration_secs", _UPSIZER, (Object)180);
        FOOD_ONLY_CUTTERS = new ModConfigBase.Option("flint_cutter_for_food_only", _GENERAL, (Object)false);
        INSTA_EAT_MORSELS = new ModConfigBase.Option("insta_eat_morsels", _GENERAL, (Object)false);
        INSTA_EAT_SOAKED = new ModConfigBase.Option("insta_eat_soaked", _GENERAL, (Object)false);
        BEARS_LUV_SALMON = new ModConfigBase.Option("polarbear_breeding", _GENERAL, (Object)true);
        MAX_DRINKS_STACKSIZE = new ModConfigBase.Option("drinks_max_stacksize", _UPSIZER, (Object)VfpCapacity.LIQUID_STACK.count());
        MAX_SOUPS_STACKSIZE = new ModConfigBase.Option("soups_max_stacksize", _UPSIZER, (Object)VfpCapacity.LIQUID_STACK.count());
        BAT_DROPS = new ModConfigBase.Option("include_bat_drops", _BUTCHER, (Object)true);
        CALF_DROPS = new ModConfigBase.Option("include_calf_drops", _BUTCHER, (Object)true);
        PIG_DROPS = new ModConfigBase.Option("include_pig_drops", _BUTCHER, (Object)true);
        HORSE_DROPS = new ModConfigBase.Option("include_horse_drops", _BUTCHER, (Object)true);
        WOLF_DROPS = new ModConfigBase.Option("include_wolf_drops", _BUTCHER, (Object)true);
        SQUIDD_DROPS = new ModConfigBase.Option("include_squid_drops", _BUTCHER, (Object)true);
        POLARBEAR_DROPS = new ModConfigBase.Option("include_polarbear_drops", _BUTCHER, (Object)true);
        LLAMA_DROPS = new ModConfigBase.Option("include_llama_drops", _BUTCHER, (Object)true);
        OZELOT_DROPS = new ModConfigBase.Option("include_ocelot_drops", _BUTCHER, (Object)true);
        GUARDIAN_DROPS = new ModConfigBase.Option("include_guardian_drops", _BUTCHER, (Object)true);
        ZOMBIE_DROPS = new ModConfigBase.Option("include_zombie_drops", _BUTCHER, (Object)true);
        PHANTOM_DROPS = new ModConfigBase.Option("include_phantom_drops", _BUTCHER, (Object)false);
        RAVAGER_DROPS = new ModConfigBase.Option("include_ravager_drops", _BUTCHER, (Object)true);
        ENSURE_DEATH_DROPS = new ModConfigBase.Option("ensure_death_drops", _BUTCHER, (Object)true);
        BONE_DROPS = new ModConfigBase.Option("include_bone_drops", _BUTCHER, (Object)"*DEFAULT*");
        LEATHER_DROPS = new ModConfigBase.Option("include_leather_drops", _BUTCHER, (Object)"*DEFAULT*");
        EXCLUDE_HORSE_MEAT = new ModConfigBase.Option("exclude_horse_meat", _BUTCHER, (Object)false);
        EXCLUDE_SQUID_MEAT = new ModConfigBase.Option("exclude_squid_meat", _BUTCHER, (Object)false);
        EXCLUDE_WOLF_MEAT = new ModConfigBase.Option("exclude_wolf_meat", _BUTCHER, (Object)false);
        EXCLUDE_POLARBEAR_MEAT = new ModConfigBase.Option("exclude_polarbear_meat", _BUTCHER, (Object)false);
        EXCLUDE_LLAMA_MEAT = new ModConfigBase.Option("exclude_llama_meat", _BUTCHER, (Object)false);
        LLAMAS_DROP_WOOL = new ModConfigBase.Option("llamas_drop_wool", _BUTCHER, (Object)false);
        EXCLUDE_GUARDIAN_MEAT = new ModConfigBase.Option("exclude_guardian_meat", _BUTCHER, (Object)false);
        EXCLUDE_RAVAGER_MEAT = new ModConfigBase.Option("exclude_ravager_meat", _BUTCHER, (Object)false);
        MUSHROOM_PANTRY_BLOCK = new ModConfigBase.Option("mushroom_pantry_blocks", _PRODUCE, (Object)false);
        UPSIZE_MUSHROOM_DROPS = new ModConfigBase.Option("upsize_mushroom_drops", _PRODUCE, (Object)true);
        ACORN_DROPS = new ModConfigBase.Option("include_acorn_drops", _PRODUCE, (Object)true);
        UGLIFRUIT_DROPS = new ModConfigBase.Option("include_raftugli_drops", _PRODUCE, (Object)true);
        SPRUCETIP_DROPS = new ModConfigBase.Option("include_spruce_tip_drops", _PRODUCE, (Object)true);
        HONEY_PANTRY_BLOCKS = new ModConfigBase.Option("honey_pantry_blocks", _PRODUCE, (Object)true);
        SHOW_ALL_ITEMS = new ModConfigBase.Option("show_all_items_in_ui", _OTHRMOD, (Object)false);
        SHOW_DECKER_FULLTIP = new ModConfigBase.Option("show_sandwich_ingredients", _MISC, (Object)true);
        INTERMOD_RECIPES = new ModConfigBase.Option("modded_ingredients", _OTHRMOD, (Object)true);
        BARTERING = new ModConfigBase.Option("modded_trading_allowed", _OTHRMOD, (Object)"*DEFAULT*");
        WARMING_COOLING_RECIPES = new ModConfigBase.Option("hotcold_food_crafting", _OTHRMOD, (Object)true);
        SMH_INTEGRATE = new ModConfigBase.Option("auto_integrate", "integration.smarthoppers.", (Object)true);
    }
}

