/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public abstract class VfpLiquidFood
extends VfpPantryItem {
    public static final VfpCapacity DEFAULT_STACK_SIZE = VfpCapacity.LIQUID_STACK;

    protected VfpLiquidFood(@Nonnull VfpProfile profile, LikeFood food, ItemGroup tab) {
        super(profile, food, tab, true);
        this.setMaxStackSize(this.getItemMaxStackSize().count());
        this.setContainerItem(this.getNewEmptyContainer());
        this.completeInit(profile);
    }

    protected VfpLiquidFood(@Nonnull VfpProfile profile, LikeFood food) {
        this(profile, food, null);
    }

    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(DEFAULT_STACK_SIZE);
    }

    protected abstract Item getNewEmptyContainer();

    @Override
    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        return VfpLiquidFood.returnOrDropContainer((ItemStack)remaining, (PlayerEntity)player, (ItemStack)ItemStacks.create((Item)this.getNewEmptyContainer()));
    }
}

