/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IDrink;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.integration.ENVHelper;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public abstract class VfpLiquidNonFood
extends VfpPlainItem
implements IDrink {
    protected boolean _instaDrinkingAllowed = false;
    protected final LiquidType _drinkType;

    protected VfpLiquidNonFood(@Nonnull VfpProfile profile, @Nonnull LiquidType type, ItemGroup tab) {
        super(profile, false, tab);
        Validate.notNull((Object)type, (String)"Non-null liquid type required", (Object[])new Object[0]);
        this._drinkType = type;
        this.setMaxStackSize(this.getItemMaxStackSize().count());
        Item c = this.getNewEmptyContainer();
        if (SharedGlue.isDefined((Item)c)) {
            this.setContainerItem(c);
        }
    }

    protected VfpLiquidNonFood(@Nonnull VfpProfile profile, @Nonnull LiquidType type) {
        this(profile, type, null);
    }

    protected VfpCapacity getItemMaxStackSize() {
        return VfpLiquidFood.DEFAULT_STACK_SIZE;
    }

    protected Item getNewEmptyContainer() {
        return VfpObj.Our_Empty_Bottle_obj;
    }

    public final int getThirstQuenched(ItemStack drink) {
        return this._drinkType.getThirstQuenched(drink);
    }

    public final float getHydrationAdded(ItemStack drink) {
        return this._drinkType.getHydrationAdded(drink);
    }

    public final float getThirstTriggerChance(ItemStack drink) {
        return this._drinkType.getThirstTriggerChance(drink);
    }

    protected boolean isDrinkable(ItemStack drinking) {
        return !drinking.func_190926_b();
    }

    protected boolean isInstaDrink(ItemStack drink) {
        return this.isDrinkable(drink) && this._instaDrinkingAllowed && VfpConfig.getInstance().allowInstaPotions();
    }

    protected int getRegularItemUseDuration() {
        return SharedGlue.DEFAULT_FOOD_CONSUME_DURATION();
    }

    public int func_77626_a(ItemStack drink) {
        return this.isInstaDrink(drink) ? 0 : this.getRegularItemUseDuration();
    }

    protected UseAction getRegularItemUseAction() {
        return UseAction.DRINK;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return this.isInstaDrink(stack) || !this.isDrinkable(stack) ? UseAction.NONE : this.getRegularItemUseAction();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ActionResultType result;
        ItemStack helditem = player.func_184586_b(hand);
        ActionResultType actionResultType = result = this.isDrinkable(helditem) ? ActionResultType.CONSUME : ActionResultType.FAIL;
        if (result == ActionResultType.CONSUME && this.isInstaDrink(helditem)) {
            helditem = this.func_77654_b(helditem, world, (LivingEntity)player);
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(result, (Object)helditem);
    }

    public ItemStack func_77654_b(ItemStack drink, World world, LivingEntity entity) {
        ItemStack original = ItemStacks.copy1((ItemStack)drink);
        ItemStack remaining = drink;
        PlayerEntity player = SharedGlue.getPlayerOrNull((Entity)entity);
        if ((player == null || SharedGlue.getPlayerInSurvival((PlayerEntity)player)) && ItemStacks.decrBy((ItemStack)drink, (int)1)) {
            remaining = ItemStack.field_190927_a;
        }
        if (player != null) {
            Effects.playFoodConsumed((World)world, (PlayerEntity)player);
            this.addUsedStat(player);
            this.onDrinkDrunk(original, drink, world, player);
            remaining = this.onItemConsumedFully(original, remaining, world, player);
        }
        return remaining;
    }

    protected void onDrinkDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            this.applyPotionEffectsOnDrunk(original, remaining, world, player);
        }
        ItemSupport.noteItemConsumed((PlayerEntity)player, (ItemStack)original);
    }

    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        return VfpPantryItem.returnOrDropContainer((ItemStack)remaining, (PlayerEntity)player, (ItemStack)ItemStacks.create((Item)this.getNewEmptyContainer()));
    }

    protected void applyPotionEffectsOnDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (VfpConfig.manageThirst()) {
            ENVHelper.quenchThirst((PlayerEntity)player, (IDrink)this, (ItemStack)original);
        }
    }
}

