/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.ILootedListener;
import org.jwaresoftware.mcmods.lib.api.ISoakable;
import org.jwaresoftware.mcmods.lib.loot.RandomPotionFunction;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpSoakableSimpleFood
extends VfpPantryItem
implements ISoakable,
ILootedListener {
    public VfpSoakableSimpleFood(@Nonnull VfpProfile profile, LikeFood like, ItemGroup tab, boolean delayed) {
        super(profile, like, tab, delayed);
    }

    public VfpSoakableSimpleFood(@Nonnull VfpProfile profile, LikeFood like, ItemGroup tab) {
        this(profile, like, tab, false);
    }

    protected VfpSoakableSimpleFood(VfpProfile profile, Item.Properties ip, LikeFood like, boolean delayed) {
        super(profile, ip, like, delayed);
    }

    @Override
    protected void completeInit(@Nonnull VfpProfile profile) {
        super.completeInit(profile);
        this.func_185043_a(new ResourceLocation("soaked"), ISoakable.SoakedPropertyGetter.INSTANCE);
    }

    @Override
    public float getCompostChance() {
        return 0.15f;
    }

    public boolean canSoak(ItemStack stack) {
        return this.isEdible(stack);
    }

    protected final boolean isSimpleSoaked(ItemStack stack) {
        return Potions.isa((ItemStack)stack, (boolean)true);
    }

    public boolean isSoaked(ItemStack stack) {
        return this.isSimpleSoaked(stack);
    }

    public List<EffectInstance> getSoakingEffects(ItemStack stack) {
        return Potions.getEffects((ItemStack)stack, (boolean)true);
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return this.isSoaked(stack) ? SharedGlue.SHORT_FOOD_CONSUME_DURATION() : super.func_77626_a(stack);
    }

    @Override
    protected boolean canConsume(ItemStack held, World world, PlayerEntity player) {
        return this.isSoaked(held) || super.canConsume(held, world, player);
    }

    @Override
    protected boolean isInstaConsume(ItemStack held) {
        if (super.isInstaConsume(held)) {
            return true;
        }
        return VfpConfig.getInstance().allowInstaPotions() && this.isSoaked(held);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (this.isSoaked(original)) {
            Potions.addPotionEffects((LivingEntity)player, (ItemStack)original);
        }
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
    }

    public void notifyLooted(@Nonnull ItemStack loot, World world, PlayerEntity player, float luckLevel, String context) {
        if (loot.func_77973_b() == this) {
            VfpSoakableSimpleFood.checkForSoakedLootItem(loot, this, -1, Effects.field_76429_m);
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent displayName = super.func_200295_i(stack);
        if (this.isSoakedOrShouldBeSoaked(stack)) {
            displayName = new TranslationTextComponent("tooltip.itemsuffix.footnoted", new Object[]{displayName, "*"});
        }
        return displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isShowingUiTips(ItemStack stack) {
        return this.isSoaked(stack) ? false : super.isShowingUiTips(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        if (this.isSoaked(stack)) {
            if (this.isMultiuse(stack) || this._debugFlag) {
                tooltip.add(Tooltips.NL());
            }
            Potions.addPotionInformation((Collection)Potions.getEffects((ItemStack)stack, (boolean)false), tooltip, (boolean)flags.func_194127_a());
        }
    }

    public static final ItemStack checkForSoakedLootItem(ItemStack loot, @Nonnull ISoakable soakable, int duration_secs, @Nullable Effect eifError) {
        if (!loot.func_190926_b() && soakable.shouldBeSoaked(loot)) {
            String potion_name;
            if (duration_secs <= 0) {
                duration_secs = 180;
            }
            if ((potion_name = soakable.stripShouldBeSoakedWith(loot)).isEmpty() || "*random*".equalsIgnoreCase(potion_name)) {
                if (!RandomPotionFunction.doApply((ItemStack)loot, (RandomPotionFunction.Type)RandomPotionFunction.Type.BENEFICIAL, (boolean)true)) {
                    EffectInstance e = Potions.newPotionTypeEffect((Effect)Effects.field_76429_m, (int)duration_secs, (int)0);
                    Potions.addEffect((ItemStack)loot, (EffectInstance)e);
                }
            } else {
                Potion p;
                ResourceLocation pid = ResourceLocation.func_208304_a((String)potion_name);
                Potion potion = p = pid != null && ForgeRegistries.POTION_TYPES.containsKey(pid) ? (Potion)ForgeRegistries.POTION_TYPES.getValue(pid) : null;
                if (p != null) {
                    PotionUtils.func_185184_a((ItemStack)loot, (Collection)p.func_185170_a());
                } else if (eifError != null) {
                    EffectInstance e = Potions.newPotionTypeEffect((Effect)eifError, (int)duration_secs, (int)0);
                    Potions.addEffect((ItemStack)loot, (EffectInstance)e);
                }
            }
        }
        return loot;
    }
}

