/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.vfp.common.VfpBrewingItem;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class AirSac
extends VfpBrewingItem {
    private static final int _MAX_STACKSIZE = SharedGlue.VANILLA_MAX_STACK_SIZE();
    private static final int _MAX_USES = 4;
    private static final int _MAX_LEVEL_AIR = SharedGlue.PLAYER_MAX_AIR_LEVEL();
    private static final int _HIGH_LEVEL_AIR = (int)((float)_MAX_LEVEL_AIR * 0.9f);
    private static final int _2MINS = 120;

    public AirSac(boolean brewingEnabled) {
        super((VfpProfile)VfpOid.Guardian_Air_Sac, (BrewEffect)(brewingEnabled ? BrewEffect.dragonbreathEffect : null), SharedGlue.CreativeTabs_misc);
        this.setMaxStackSize(_MAX_STACKSIZE);
        this.setMaxDamage(4);
        this.autoregister();
    }

    public final int getItemStackLimit(ItemStack airsac) {
        return airsac.func_77952_i() > 0 ? 1 : _MAX_STACKSIZE;
    }

    public int getMaxDamage(ItemStack airsac) {
        return 4;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ActionResultType result = ActionResultType.PASS;
        ItemStack airsac = player.func_184586_b(hand);
        if (airsac.func_190916_E() > 1) {
            result = ActionResultType.FAIL;
        } else if (player.func_70086_ai() < _HIGH_LEVEL_AIR) {
            if (SharedGlue.isaClientWorld((IWorldReader)world)) {
                Effects.playSoundFor((World)world, (PlayerEntity)player, (SoundEvent)SoundEvents.field_189109_ed, (float)6.0f, (float)1.0f);
                if (player.func_70026_G() || player.func_208600_a(Fluids.Tags.SWIMMABLE_IN)) {
                    Vec3d looking = player.func_70040_Z().func_72441_c(1.0, 0.0, 1.0);
                    player.func_70653_a((Entity)player, 0.4f, looking.field_72450_a - player.func_226277_ct_(), looking.field_72449_c - player.func_226281_cx_());
                }
            } else {
                int bonus = 0;
                if (EnchantmentHelper.func_185292_c((LivingEntity)player) <= 0) {
                    bonus = player.func_70681_au().nextInt(3) * SharedGlue.PLAYER_ONE_AIR_LEVEL();
                }
                Potions.cureChokingEffects((PlayerEntity)player);
                player.func_70050_g(_MAX_LEVEL_AIR + bonus);
                if (player.func_203008_ap() || player.func_208600_a(Fluids.Tags.SWIMMABLE_IN)) {
                    Potions.addPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_waterBreathing, (int)120, (int)0, (boolean)false, (boolean)false);
                }
                int uses = airsac.func_77952_i() + 1;
                ItemSupport.noteItemNewDurability((LivingEntity)player, (ItemStack)airsac, (int)uses);
                if (SharedGlue.getPlayerInSurvival((PlayerEntity)player)) {
                    if (uses == 1) {
                        ItemStacks.stampUnique((ItemStack)airsac, (String)"AIR");
                    }
                    airsac.func_196085_b(uses);
                    if (uses >= airsac.func_77958_k()) {
                        airsac.func_190918_g(1);
                    }
                }
                this.addUsedStat(player);
                result = ActionResultType.SUCCESS;
            }
        }
        return new ActionResult(result, (Object)airsac);
    }
}

