/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTables;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.meats.AirSac;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;

public class HostileMobItems
extends VfpBuildHelperSupport {
    private static final String _MOBDROPS = "mobdrops";

    @Override
    protected String categoryName() {
        return "HostilesDrops";
    }

    private Item addPhantomMeatBuff(Item to, int a) {
        Potions.addPotionEffect((Item)to, (Effect)SharedGlue.Potion_slowfall, (int)90, (int)a, (float)1.0f);
        return to;
    }

    private Item addRavagerMeatBuff(Item to, int a) {
        Potions.addPotionEffect((Item)to, (Effect)SharedGlue.Potion_resistance, (int)90, (int)0, (float)1.0f);
        Potions.addPotionEffect((Item)to, (Effect)SharedGlue.Potion_strength, (int)90, (int)a, (float)1.0f);
        return to;
    }

    @Override
    public void makeObjects(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        VfpObj.Villager_Soul_obj = VfpBuilder.newMisc(_MOBDROPS, VfpOid.Tainted_Villager_Soul);
        VfpObj.Bane_of_Ocelots_obj = VfpBuilder.newMisc(_MOBDROPS, VfpOid.Bane_Of_Ocelots).setRarity(Rarity.UNCOMMON);
        VfpObj.Guardian_Fins_obj = VfpBuilder.newMisc(_MOBDROPS, VfpOid.Guardian_Fins, 1.0f);
        VfpObj.Guardian_Raw_obj = (Item)VfpBuilder.newWolfFood(VfpOid.Guardian_Meat_Raw, LikeFood.uncooked_fish).inGroup(_MOBDROPS);
        VfpObj.Guardian_Cooked_obj = (Item)VfpBuilder.newWolfFood(VfpOid.Guardian_Meat, LikeFood.bear).inGroup(_MOBDROPS);
        VfpObj.Guardian_AirSac_obj = (Item)new AirSac(config.includePotionBrewing()).inGroup(_MOBDROPS);
        VfpObj.Phantom_Raw_obj = this.addPhantomMeatBuff((Item)VfpBuilder.newWolfFood(VfpOid.Phantom_Meat_Raw, LikeFood.rotten_flesh).inGroup(_MOBDROPS), 1);
        VfpObj.Phantom_Cooked_obj = this.addPhantomMeatBuff((Item)VfpBuilder.newWolfFood(VfpOid.Phantom_Meat, LikeFood.chicken).inGroup(_MOBDROPS), 0);
        VfpObj.Ravager_Raw_obj = this.addRavagerMeatBuff((Item)VfpBuilder.newFood(_MOBDROPS, VfpOid.Ravager_Meat_Raw, LikeFood.uncooked_ravager), 1);
        VfpObj.Ravager_Raw_Prepped_obj = this.addRavagerMeatBuff((Item)VfpBuilder.newWolfFood(VfpOid.Ravager_Meat_Prepped, LikeFood.uncooked_ravager), 0);
        VfpObj.Ravager_Cooked_obj = this.addRavagerMeatBuff((Item)VfpBuilder.newWolfFood(VfpOid.Ravager_Meat, LikeFood.ravager), 0);
        VfpObj.Ravager_Raw_Charred_obj = this.addRavagerMeatBuff((Item)VfpBuilder.newFood(_MOBDROPS, VfpOid.Ravager_Meat_Charred, LikeFood.charred_ravager), 1);
        VfpObj.Ravager_Hide_obj = VfpBuilder.newMisc(VfpOid.Ravager_Hide);
        VfpObj.Ravager_Left_Horn_obj = VfpBuilder.newMisc(_MOBDROPS, VfpOid.Ravager_Left_Horn);
        VfpObj.Ravager_Right_Horn_obj = VfpBuilder.newMisc(_MOBDROPS, VfpOid.Ravager_Right_Horn);
        VfpObj.Ravager_Bone_obj = VfpBuilder.newMisc(_MOBDROPS, VfpOid.Ravager_Bone);
    }

    @Override
    public void addDictionaryEntries(IModRuntime runtime) {
        RID.addToGroup((String)"carrots:villager_souls", (Item)VfpObj.Villager_Soul_obj);
        RID.addToGroup((String)"ingredients/kebabs/adventure", (Item)VfpObj.Guardian_Raw_obj);
        RID.addToGroup((String)"ingredients/fish_sausage_main", (Item)VfpObj.Guardian_Raw_obj);
        RID.addToGroup((String)"ingredients/fish_chowder_main", (Item)VfpObj.Guardian_Cooked_obj);
        RID.addToGroup((String)"foods/cooked_proteins", (Item)VfpObj.Guardian_Cooked_obj);
        RID.addToGroup((String)"ingredients/kebabs/adventure", (Item)VfpObj.Phantom_Raw_obj);
        RID.addToGroup((String)"foods/cooked_proteins", (Item)VfpObj.Phantom_Cooked_obj);
        RID.addToGroup((String)"ingredients/kebabs/adventure", (Item)VfpObj.Ravager_Raw_Prepped_obj);
        RID.addToGroup((String)"foods/cooked_proteins", (Item)VfpObj.Ravager_Cooked_obj);
    }

    @Override
    public void addLootEntries(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        if (!config.includeModDrops()) {
            return;
        }
        if (config.includePhantomDrops()) {
            Loot.addLootEntry((String)"vanillafoodpantry", (ResourceLocation)LootTables.field_215797_af, null, (LootEntry.Builder)Loot.createEntryItem((String)VfpOid.Phantom_Meat_Raw.fmlid(), (Item)VfpObj.Phantom_Raw_obj, (int)SharedGlue.UNCOMMON_WEIGHT(), (int)-1));
        }
        if (config.includeOcelotDrops()) {
            Loot.addLootEntry((String)"vanillafoodpantry", (ResourceLocation)LootTables.field_215797_af, null, (LootEntry.Builder)Loot.createEntryItem((String)VfpOid.Bane_Of_Ocelots.fmlid(), (Item)VfpObj.Bane_of_Ocelots_obj, (int)1, (int)-1));
        }
    }

    @Override
    public void setRecipeRewards(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        if (config.includePotionBrewing()) {
            BrewEffect.addRecipeFor((Item)VfpObj.Phantom_Raw_obj, (Potion)SharedGlue.PotionType_slow_falling);
            BrewEffect.addConversionFor((Potion)VfpPotions.BADD_JUJU, (Item)VfpObj.Ravager_Left_Horn_obj, (Potion)VfpPotions.VILLAGE_HEXED);
            BrewEffect.addConversionFor((Potion)VfpPotions.BADD_JUJU, (Item)VfpObj.Ravager_Right_Horn_obj, (Potion)VfpPotions.VILLAGE_HEXED);
        }
    }
}

