/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public final class MeatPortions
extends VfpPantryMultiItem {
    private static MeatPortions[] INSTANCES;
    private static List<PackagedFood> _MEATS;
    private static ItemStack[] TYPED_INSTANCES;

    MeatPortions(VfpVariant variant) {
        super((VfpProfile)VfpOid.Portion, true, variant);
        this.autoregister();
    }

    @Override
    public float getCompostChance() {
        return 0.25f;
    }

    private static final boolean isFish(VfpVariant variant) {
        return variant.fmlid().endsWith("fish") || variant.fmlid().endsWith("cod") || variant.fmlid().endsWith("salmon");
    }

    static final synchronized MeatPortions[] makeObjects() {
        if (INSTANCES == null) {
            String basename = VfpOid.Portion.fmlid();
            _MEATS = PackagedFood.values(PackagedFood.Type.meat.name(), true, Arrays.asList(PackagedFood.EGG, PackagedFood.BONES, PackagedFood.ROTTEN_FLESH, PackagedFood.WOLF, PackagedFood.PORK_HOCKS, PackagedFood.PIGTAILS));
            int j = 0;
            INSTANCES = new MeatPortions[_MEATS.size()];
            for (PackagedFood meat : _MEATS) {
                String fmlid = basename + "_" + meat.fmlid_suffix();
                VfpVariant variant = new VfpVariant(j, fmlid, LikeFood.uncooked_meat_portion);
                MeatPortions.INSTANCES[j++] = new MeatPortions(variant);
            }
        }
        return INSTANCES;
    }

    static final void addDictionaryEntries() {
        if (INSTANCES != null) {
            for (int j = 0; j < INSTANCES.length; ++j) {
                VfpVariant variant = MeatPortions.INSTANCES[j]._variant;
                ItemStack a_portion = new ItemStack((IItemProvider)INSTANCES[j]);
                RID.addToGroup((String)"carrots:portions_meat", (ItemStack)a_portion);
                if (!MeatPortions.isFish(variant)) continue;
                RID.addToGroup((String)"carrots:portions_fish", (ItemStack)a_portion);
            }
        }
    }

    static final void setRecipeRewards(Item jerky_obj) {
        if (INSTANCES != null && TYPED_INSTANCES == null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(23);
            for (int j = 0; j < INSTANCES.length; ++j) {
                instances.add(new ItemStack((IItemProvider)INSTANCES[j]));
            }
            TYPED_INSTANCES = instances.toArray(ItemStacks.EMPTY_ARRAY);
        }
    }

    public static final ItemStack get(PackagedFood food) {
        if (PackagedFood.Type.meat.name().equals(food.type())) {
            for (int i = 0; i < _MEATS.size(); ++i) {
                if (food != _MEATS.get(i)) continue;
                return TYPED_INSTANCES != null ? TYPED_INSTANCES[i].func_77946_l() : new ItemStack((IItemProvider)INSTANCES[i]);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static final ItemStackDef getDef(PackagedFood food) {
        if (PackagedFood.Type.meat.name().equals(food.type())) {
            for (int i = 0; i < _MEATS.size(); ++i) {
                if (food != _MEATS.get(i)) continue;
                return new ItemStackDef((Item)INSTANCES[i]);
            }
        }
        return ItemStackDef.EMPTY;
    }

    public static final boolean registerSourcesUnderGroup(String dictid) {
        boolean done = false;
        if (INSTANCES != null) {
            for (int i = 0; i < _MEATS.size(); ++i) {
                ItemStack meat = _MEATS.get(i).food().sample();
                RID.addToGroup((String)dictid, (ItemStack)meat);
            }
            done = true;
        }
        return done;
    }
}

