/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class Nuggets
extends VfpPantryMultiItem
implements IVariant {
    private static final String DARK_MEAT = "dark_meat";
    private static final String LIGHT_MEAT = "light_meat";
    private static final String ANY_FISH = "fish";
    private static final String ANY_VEGGIE = "veggie";
    private static final String SQUID = "squid";
    static VfpVariant[] VARIANT_ARRAY;
    private static Map<Integer, Nuggets> INSTANCES;

    public Nuggets(VfpVariant variant) {
        super((VfpProfile)VfpOid.Nuggets, false, variant);
        this._gid = "nuggets";
        if (variant.fmlid().startsWith("nugget_")) {
            this.setInstaConsume();
        }
        this.autoregister();
    }

    @Override
    public float getCompostChance() {
        return 0.55f;
    }

    public String varid() {
        return this.getVariant().fmlid();
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> only_cooked = new ArrayList<ItemStack>(INSTANCES.size());
        for (Nuggets nuggets : INSTANCES.values()) {
            if (nuggets._instaConsumeAllowed || nuggets._variant.fmlid().endsWith("_prep")) continue;
            only_cooked.add(new ItemStack((IItemProvider)nuggets));
        }
        return only_cooked;
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(71);
            for (NuggetDef nuggetDef : NuggetDef.values()) {
                nuggetDef.installVariants(variants);
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCES = new HashMap<Integer, Nuggets>(71, 0.9f);
            for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
                VfpVariant variant = VARIANT_ARRAY[i];
                INSTANCES.put(variant.metadata(), new Nuggets(variant));
            }
            VfpObj.Nuggets_NewYorker_obj = VfpBuilder.newFood("nuggets", VfpOid.Nuggets_NewYorker, new LikeFood("ny_nugets", -1, LikeFood.nuggets_combo_heavy, LikeFood.veg_portion, LikeFood.combo_boost1));
        }
    }

    static final void linkLikeFoods() {
        LikeFood.uncooked_nuggets.food().item((Item)INSTANCES.get(NuggetDef.Chicken.fried_prep_meta()));
        LikeFood.nuggets_combo.food().item((Item)INSTANCES.get(NuggetDef.Beef.combo_meta()));
        LikeFood.nuggets_combo_heavy.food().item((Item)INSTANCES.get(NuggetDef.Porkchop.combo_meta()));
    }

    static final void addDictionaryEntries() {
        if (INSTANCES != null) {
            for (Nuggets nuggets : INSTANCES.values()) {
                String fmlid = nuggets._variant.fmlid();
                if (nuggets._instaConsumeAllowed) {
                    RID.addToGroup((String)"foods/nugget", (Item)nuggets);
                }
                if (fmlid.endsWith("_prep") || fmlid.endsWith("_combo")) continue;
                RID.addToGroup((String)"foods/cooked_proteins", (Item)nuggets);
            }
            RID.addToGroup((String)"foods/cooked_proteins", (Item)VfpObj.Nuggets_NewYorker_obj);
        }
    }

    static final void setRecipeRewards(VfpConfig config) {
        if (INSTANCES != null) {
            VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Nuggets_NewYorker_obj), OneXp.Always.value());
            for (Nuggets nuggets : INSTANCES.values()) {
                if (!nuggets._variant.fmlid().endsWith("_combo")) continue;
                VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)nuggets), OneXp.Per03.value());
            }
        }
    }

    public static final ItemStack fried(NuggetDef def) {
        ItemStack out = ItemStack.field_190927_a;
        if (INSTANCES != null && def != null && def._can_fry) {
            out = new ItemStack((IItemProvider)INSTANCES.get(def.fried_meta()));
        }
        return out;
    }

    public static enum NuggetDef {
        Chicken(12, "chicken", "light_meat", true, false, true, false, true),
        Beef(24, "beef", "dark_meat", true, true, true, false, false),
        Mutton(36, "mutton", "dark_meat", true, false, true, false, false),
        Pork(48, "pork", "light_meat", true, false, true, false, true),
        Fish(60, "fish", "fish", true, true, true, false, false),
        Mushroom(72, "mushrooms", "mushroom", true, false, true, false, false),
        Veggie(84, "veggies", "veggie", true, false, true, false, false),
        Squid(96, "squid", "squid", true, false, true, false, false),
        Porkchop(108, "cooked_pork", "cooked_pork", true, false, true, true, false),
        Carrots(120, "carrots", "carrots", true, false, true, true, false);

        private final int _meta_raw;
        private final String _name;
        final String _type;
        final boolean _can_fry;
        final boolean _can_dry;
        final boolean _can_mix;
        private final boolean _heavy;
        final boolean _harmful;

        private NuggetDef(int meta, String name, String kind, boolean fry, boolean dry, boolean mix, boolean heavy, boolean harmful) {
            this._meta_raw = meta;
            this._name = name;
            this._type = kind;
            this._heavy = heavy;
            this._can_fry = fry;
            this._can_dry = dry;
            this._can_mix = mix;
            this._harmful = harmful;
        }

        private void install(int prep_meta, String variety, LikeFood plate, List<VfpVariant> variants) {
            String rendername;
            String fmlid;
            boolean jerky = "jerky".equals(variety);
            if (plate == null) {
                fmlid = "nuggets_" + this._name + "_" + variety + "_prep";
                rendername = "nuggets_" + this._type + "_" + variety + "_prep";
                variants.add(new VfpTransientVariant(variants.size(), prep_meta + 0, fmlid, LikeFood.uncooked_nuggets, rendername, null));
                if (this._harmful) {
                    variants.get(variants.size() - 1).setHarmful();
                }
                if (jerky) {
                    fmlid = "nugget_" + this._name + "_" + variety;
                    rendername = "nugget_" + this._type + "_" + variety;
                    variants.add(new VfpTransientVariant(variants.size(), prep_meta + 2, fmlid, LikeFood.jerky_bit, rendername, null));
                    if (this._harmful) {
                        variants.get(variants.size() - 1).setHarmful();
                    }
                }
            }
            fmlid = "nuggets_" + this._name + "_" + variety;
            rendername = "nuggets_" + this._type + "_" + variety;
            variants.add(new VfpTransientVariant(variants.size(), prep_meta + 1, fmlid, plate == null ? (jerky ? LikeFood.jerky_bit_x3 : (this._heavy ? LikeFood.nuggets_heavy : LikeFood.nuggets)) : plate, rendername, null));
        }

        void installVariants(List<VfpVariant> variants) {
            if (this._can_fry) {
                this.install(this.fried_prep_meta(), "fried", null, variants);
            }
            if (this._can_dry) {
                this.install(this.jerky_prep_meta(), "jerky", null, variants);
            }
            if (this._can_mix) {
                this.install(this.combo_prep_meta(), "combo", this._heavy ? LikeFood.nuggets_combo_heavy : LikeFood.nuggets_combo, variants);
            }
        }

        final int fried_prep_meta() {
            return this._meta_raw + 0;
        }

        final int fried_meta() {
            return this._meta_raw + 1;
        }

        final int fried_one_meta() {
            return this._meta_raw + 2;
        }

        final int jerky_prep_meta() {
            return this._meta_raw + 3;
        }

        final int jerky_meta() {
            return this._meta_raw + 4;
        }

        final int jerky_one_meta() {
            return this._meta_raw + 5;
        }

        final int combo_prep_meta() {
            return this._meta_raw + 6;
        }

        final int combo_meta() {
            return this._meta_raw + 7;
        }

        final String combo_fmlid() {
            return "nuggets_" + this._name + "_combo";
        }

        final String fried_fmlid() {
            return "nuggets_" + this._name + "_fried";
        }

        final String jerky_fmlid() {
            return "nuggets_" + this._name + "_jerky";
        }

        final String jerky_one_fmlid() {
            return "nugget_" + this._name + "_jerky";
        }
    }
}

