/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICompostable;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class UndeadCrunchies
extends VfpPlainItem
implements ICompostable {
    UndeadCrunchies() {
        super((VfpProfile)VfpOid.Undead_Crunchies, false, SharedGlue.CreativeTabs_food);
        this.autoregister();
    }

    public UseAction func_77661_b(ItemStack wotsit) {
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack wotsit) {
        return 0;
    }

    boolean isInstaEat(PlayerEntity player, ItemStack wotsit) {
        return player.func_70996_bM() || VfpConfig.getInstance().allowInstaEating();
    }

    public float getCompostChance() {
        return 0.45f;
    }

    private void feed(PlayerEntity player, ItemStack wotsit) {
        player.func_71024_bL().func_75122_a(4, 0.3f);
    }

    private void zeroExhaustion(PlayerEntity player, FoodStats food) {
        CompoundNBT stats = new CompoundNBT();
        food.func_75117_b(stats);
        int exhaustionLevel = stats.func_74762_e("foodExhaustionLevel");
        if (exhaustionLevel > 0) {
            player.func_71020_j((float)(exhaustionLevel *= -1));
        }
    }

    private void onWotsitConsumed(ItemStack original, ItemStack left, World world, PlayerEntity player) {
        if (SharedGlue.isaClientWorld((IWorldReader)world) || world.func_175659_aa() == Difficulty.PEACEFUL) {
            return;
        }
        int paymentAmount = SharedGlue.PLAYER_ONE_FOOD_LEVEL();
        FoodStats food = player.func_71024_bL();
        float chance = 0.5f;
        boolean hunger = true;
        if (player.func_70996_bM()) {
            if (food.func_75116_a() > paymentAmount) {
                player.func_70691_i(SharedGlue.LIVING_ENTITY_ONE_HEALTH_LEVEL());
                this.zeroExhaustion(player, food);
                food.func_75119_b(0.0f);
                food.func_75114_a(food.func_75116_a() - paymentAmount);
                hunger = false;
            } else {
                this.feed(player, original);
            }
        } else {
            this.feed(player, original);
            chance = 0.8f;
        }
        if (hunger && player.func_70681_au().nextFloat() < chance) {
            Potions.addPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_hunger, (int)15, (int)0);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack wotsit = player.func_184586_b(hand);
        wotsit = this.func_77654_b(wotsit, world, (LivingEntity)player);
        return new ActionResult(ActionResultType.CONSUME, (Object)wotsit);
    }

    public ItemStack func_77654_b(ItemStack wotsit, World world, LivingEntity entity) {
        ItemStack original = ItemStacks.copy1((ItemStack)wotsit);
        ItemStack remaining = wotsit;
        PlayerEntity player = SharedGlue.getPlayerOrNull((Entity)entity);
        if ((player == null || SharedGlue.getPlayerInSurvival((PlayerEntity)player)) && ItemStacks.decrBy((ItemStack)wotsit, (int)1)) {
            remaining = ItemStack.field_190927_a;
        }
        if (player != null) {
            Effects.playFoodConsumed((World)world, (PlayerEntity)player);
            this.addUsedStat(player);
            this.onWotsitConsumed(original, remaining, world, player);
            ItemSupport.noteItemConsumed((PlayerEntity)player, (ItemStack)original);
        }
        return remaining;
    }
}

