/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.integration.FluidsHelper;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRuntimeSkeleton;

public final class VfpRuntimeSP
extends VfpRuntimeSkeleton {
    private final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private static IItemColor ItemColorImplInstance = new IItemColor(){

        public int getColor(ItemStack stack, int tintIndex) {
            int color = 0xFFFFFF;
            if (!ItemStacks.isEmpty((ItemStack)stack)) {
                color = ((IMultiColored)stack.func_77973_b()).getColorFrom(stack, tintIndex);
            }
            return color;
        }
    };
    static Method _JEI_ColorGetter = null;

    public VfpRuntimeSP() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::renderlayersinit);
    }

    public final String getId() {
        return "SP";
    }

    public final boolean hasUI() {
        return true;
    }

    public PlayerEntity getClientPlayer() {
        return this.MINECRAFT.field_71439_g;
    }

    public World getClientWorld() {
        return this.MINECRAFT.field_71441_e;
    }

    public PlayerEntity getPlayer(NetworkEvent.Context context) {
        return context.getDirection() == NetworkDirection.PLAY_TO_CLIENT ? this.MINECRAFT.field_71439_g : super.getPlayer(context);
    }

    @Override
    public void midStartUp(ModLifecycleEvent e) {
        super.midStartUp(e);
        this.initFluidColorGetter();
        for (Item item : VfpUtils.getItemsWithColor()) {
            this.MINECRAFT.getItemColors().func_199877_a(ItemColorImplInstance, new IItemProvider[]{item});
        }
    }

    private void renderlayersinit(FMLClientSetupEvent event) {
        if (VfpObj.Gelatin_Pantry_Block_obj != null) {
            RenderTypeLookup.setRenderLayer((Block)VfpObj.Gelatin_Pantry_Block_obj, (RenderType)RenderType.func_228645_f_());
        }
    }

    private void initFluidColorGetter() {
        if (ModIntegration.JEI.isLoaded()) {
            try {
                Class<?> colorGetter = Class.forName("mezz.jei.color.ColorGetter");
                _JEI_ColorGetter = colorGetter.getMethod("getColors", TextureAtlasSprite.class, Integer.TYPE, Integer.TYPE);
                FluidsHelper.initFinalize((ModIntegration)ModInfo.ID, (FluidsHelper.SPILink)new FluidsHelper.SPILink(){

                    public ModIntegration modid() {
                        return ModInfo.ID;
                    }

                    public int getColorFrom(FluidStack f) {
                        TextureAtlasSprite[] sprites;
                        if (_JEI_ColorGetter != null && ModIntegration.JEI.isLoaded() && !f.isEmpty() && (sprites = ForgeHooksClient.getFluidSprites((ILightReader)VfpRuntimeSP.this.getClientWorld(), (BlockPos)BlockPos.field_177992_a, (IFluidState)f.getFluid().func_207188_f())).length > 0) {
                            try {
                                List colors = (List)List.class.cast(_JEI_ColorGetter.invoke(null, sprites[0], 0xFFFFFF, 1));
                                if (!colors.isEmpty()) {
                                    return (Integer)colors.get(0);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return 0xFFFFFF;
                    }
                });
                FluidsHelper.initFinalize((ModIntegration)ModIntegration.FORGE_LIB, (ModIntegration)ModInfo.ID);
            }
            catch (Throwable igX) {
                ModInfo.LOG.warn("Unable to initialize JEI fluids texture color hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
            }
        }
    }
}

