/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.recipes.JR;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrink;
import org.jwaresoftware.mcmods.vfp.water.Water;

public final class KeepEmptyBottlesShapelessRecipe
extends ShapelessRecipe {
    public static final String NAME = ModInfo.rstring("keep_bottles_shapeless");
    final boolean _keepJars;
    final boolean _keepBowls;

    KeepEmptyBottlesShapelessRecipe(boolean keepJars, boolean keepBowls, ShapelessRecipe from) {
        super(from.func_199560_c(), from.func_193358_e(), from.func_77571_b(), from.func_192400_c());
        this._keepJars = keepJars;
        this._keepBowls = keepBowls;
    }

    @Nullable
    private static final ItemStack getEmptyContainer(ItemStack input, boolean keepJars, boolean keepBowls) {
        ItemStack empties = null;
        if (!input.func_190926_b()) {
            Item item = input.func_77973_b();
            if (MilkDrink.isa(input) || Water.isa(input)) {
                empties = new ItemStack((IItemProvider)VfpObj.Our_Empty_Bottle_obj);
            } else if (item == Items.field_151068_bn) {
                empties = new ItemStack((IItemProvider)Items.field_151069_bo);
            } else if (keepJars && (item == VfpObj.Empty_Jar_obj || item == VfpObj.Dark_Empty_Jar_obj || item == VfpObj.Small_Empty_Jar_obj || RID.matches((ItemStack)input, (String)"carrots:empty_jars"))) {
                empties = ItemStacks.copy1((ItemStack)input);
            } else if (keepBowls && (item == Items.field_151054_z || RID.matches((ItemStack)input, (String)"bowls"))) {
                empties = ItemStacks.copy1((ItemStack)input);
            }
        }
        return empties;
    }

    static final NonNullList<ItemStack> getRemainingIncludingEmptyGlassBottles(CraftingInventory grid, boolean keepJars, boolean keepBowls) {
        NonNullList out = JR.defaultRecipeGetRemainingItems((CraftingInventory)grid);
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack empties = null;
            if (!((ItemStack)out.get(i)).func_190926_b() || (empties = KeepEmptyBottlesShapelessRecipe.getEmptyContainer(grid.func_70301_a(i), keepJars, keepBowls)) == null) continue;
            out.set(i, (Object)empties);
        }
        return out;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return KeepEmptyBottlesShapelessRecipe.getRemainingIncludingEmptyGlassBottles(grid, this._keepJars, this._keepBowls);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<KeepEmptyBottlesShapelessRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public KeepEmptyBottlesShapelessRecipe read(ResourceLocation recipeId, JsonObject json) {
            boolean keepJars = JSONUtils.func_151209_a((JsonObject)json, (String)"keepjars", (boolean)false);
            boolean keepBowls = JSONUtils.func_151209_a((JsonObject)json, (String)"keepbowls", (boolean)false);
            return new KeepEmptyBottlesShapelessRecipe(keepJars, keepBowls, JR.readShapeless((ResourceLocation)recipeId, (JsonObject)json));
        }

        public void write(PacketBuffer data, KeepEmptyBottlesShapelessRecipe recipe) {
            data.writeBoolean(recipe._keepJars);
            data.writeBoolean(recipe._keepBowls);
            JR.writeShapeless((PacketBuffer)data, (ShapelessRecipe)recipe);
        }

        public KeepEmptyBottlesShapelessRecipe read(ResourceLocation recipeId, PacketBuffer data) {
            boolean keepJars = data.readBoolean();
            boolean keepBowls = data.readBoolean();
            return new KeepEmptyBottlesShapelessRecipe(keepJars, keepBowls, JR.readShapeless((ResourceLocation)recipeId, (PacketBuffer)data));
        }
    }
}

