/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sandwiches;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.recipes.JR;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;
import org.jwaresoftware.mcmods.vfp.meats.Nuggets;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.sandwiches.DeckerSandwich;
import org.jwaresoftware.mcmods.vfp.wheat.Bread;

public class GenericDeckerSandwichRecipe
extends VfpRecipe {
    public static final String NAME = ModInfo.rstring("generic_decker_shaped");
    private static ItemStack _FLAT_BREAD;
    private static List<ItemStack> _ROASTED_VEGGIES_MAIN;
    private static List<ItemStack> _ROASTED_VEGGIES_FILL;
    private static String[] _PROTEIN_CATEGORIES;
    private static String[] _VEGFRUIT_CATEGORIES;

    private static final boolean is_cooked_protein(ItemStack stack) {
        if (!ItemStacks.isEmpty((ItemStack)stack) && stack.func_222117_E()) {
            for (ItemStack protein : _ROASTED_VEGGIES_MAIN) {
                if (!ItemStack.func_179545_c((ItemStack)protein, (ItemStack)stack)) continue;
                return true;
            }
            for (String tag : _PROTEIN_CATEGORIES) {
                if (!RID.matches((ItemStack)stack, (String)tag)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean is_cooked_vegfruit(ItemStack stack) {
        if (!ItemStacks.isEmpty((ItemStack)stack) && stack.func_222117_E()) {
            for (ItemStack vegfruit : _ROASTED_VEGGIES_FILL) {
                if (!ItemStack.func_179545_c((ItemStack)vegfruit, (ItemStack)stack)) continue;
                return true;
            }
            for (String tag : _VEGFRUIT_CATEGORIES) {
                if (!RID.matches((ItemStack)stack, (String)tag)) continue;
                return true;
            }
        }
        return false;
    }

    GenericDeckerSandwichRecipe() {
        super(new ResourceLocation(NAME));
    }

    static final void initFinalize() {
        _FLAT_BREAD = Bread.flat(1);
        _ROASTED_VEGGIES_MAIN = Arrays.asList(VfpBuilder.newItemInstance(VfpObj.Roasted_Veg_Medley_obj), VfpBuilder.newItemInstance(VfpObj.Edible_Cactus_Roasted_obj), VfpBuilder.newItemInstance(VfpObj.Glazed_Carrots_obj), VfpBuilder.newItemInstance(VfpObj.Pile_Mushrooms_obj));
        _ROASTED_VEGGIES_FILL = Arrays.asList(_ROASTED_VEGGIES_MAIN.get(0).func_77946_l(), _ROASTED_VEGGIES_MAIN.get(1).func_77946_l(), _ROASTED_VEGGIES_MAIN.get(2).func_77946_l(), _ROASTED_VEGGIES_MAIN.get(3).func_77946_l(), VfpBuilder.newItemInstance(VfpObj.Portion_Roasted_Veg_obj), VfpBuilder.newItemInstance(VfpObj.Edible_Cactus_Steamed_obj), Nuggets.fried(Nuggets.NuggetDef.Veggie), Nuggets.fried(Nuggets.NuggetDef.Mushroom), Nuggets.fried(Nuggets.NuggetDef.Carrots));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return this.canFitCommonTableGrid(width, height, true);
    }

    public boolean func_192399_d() {
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return JR.defaultRecipeGetRemainingItems((CraftingInventory)grid);
    }

    public boolean matches(CraftingInventory grid, World world) {
        int i;
        if (grid.func_70302_i_() < SharedGlue.TABLE_CRAFT_GRID_SIZE()) {
            return false;
        }
        ItemStack stack = grid.func_70301_a(0);
        if (!RID.matches((ItemStack)stack, (String)"foods/sandwich_breads", (Item)Items.field_151025_P) && !ItemStack.func_179545_c((ItemStack)_FLAT_BREAD, (ItemStack)stack)) {
            return false;
        }
        stack = grid.func_70301_a(8);
        if (stack.func_77973_b() != VfpObj.Sandwich_Press_Plate_obj) {
            return false;
        }
        int n = 0;
        for (i = 1; i < 3; ++i) {
            stack = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)stack)) continue;
            if (!GenericDeckerSandwichRecipe.is_cooked_protein(stack)) {
                return false;
            }
            ++n;
        }
        if (n < 1) {
            return false;
        }
        for (i = 3; i < 6; ++i) {
            stack = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)stack) || GenericDeckerSandwichRecipe.is_cooked_vegfruit(stack)) continue;
            return false;
        }
        for (i = 6; i < 8; ++i) {
            stack = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)stack) || RID.matches((ItemStack)stack, (String)"ingredients/condiments")) continue;
            return false;
        }
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        return DeckerSandwich.create((IItemHandler)new InvWrapper((IInventory)grid));
    }

    static {
        _ROASTED_VEGGIES_MAIN = Collections.EMPTY_LIST;
        _ROASTED_VEGGIES_FILL = Collections.EMPTY_LIST;
        _PROTEIN_CATEGORIES = new String[]{ModInfo.rstring("decker_proteins")};
        _VEGFRUIT_CATEGORIES = new String[]{"forge:foods/cheeses", ModInfo.rstring("decker_vegfruits")};
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<GenericDeckerSandwichRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public GenericDeckerSandwichRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new GenericDeckerSandwichRecipe();
        }

        public GenericDeckerSandwichRecipe read(ResourceLocation recipeId, PacketBuffer data) {
            return new GenericDeckerSandwichRecipe();
        }

        public void write(PacketBuffer data, GenericDeckerSandwichRecipe recipe) {
        }
    }
}

