/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableFood;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public final class Gelo
extends VfpSoakableFood
implements IVariant {
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>(23);
    private static Gelo[] INSTANCES;

    public static final boolean register(Ingredient flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null ingredient is required for an edible gelo", (Object[])new Object[0]);
        boolean added = false;
        if (!VARIANT_FLAVORS.contains(flavor)) {
            VARIANT_FLAVORS.add(flavor);
            added = true;
        }
        return added;
    }

    public static final synchronized boolean register(FoodPowder.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for an edible gelo", (Object[])new Object[0]);
        String name = null;
        name = flavor == FoodPowder.Type.CARROT ? "orange" : (flavor == FoodPowder.Type.DANDELION ? "dandy" : (flavor == FoodPowder.Type.POPPY ? "poppy" : (flavor == FoodPowder.Type.CACTUS ? "klingon" : (flavor == FoodPowder.Type.INK ? "midnight" : (flavor == FoodPowder.Type.SYRUP ? "sugarbomb" : (flavor == FoodPowder.Type.UGLI_FRUIT ? "ugli" : flavor.name_lowercased()))))));
        return Gelo.register(FoodPowder.toIngredient(flavor, FoodPowder.Usage.DRINK_FLAVOR, name));
    }

    Gelo(VfpVariant variant) {
        super((VfpProfile)VfpOid.Gelo, false, variant);
        this.inGroup("gelos");
        this.autoregister();
    }

    private static final LikeFood like(Ingredient ingredient) {
        String name = ingredient.name().toUpperCase();
        LikeFood baseline = LikeFood.sugarbomb;
        if ("HONEY".equals(name)) {
            return LikeFood.honey_bottle;
        }
        if ("SUGARBOMB".equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.sugar);
        }
        if (FoodPowder.Type.APPLE.name().equals(name) || FoodPowder.Type.CHORUSFRUIT.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.apple);
        }
        if (FoodPowder.Type.BERRY_MIX.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.sweet_berries, LikeFood.sweet_berries);
        }
        if (FoodPowder.Type.MELON.name().equals(name) || FoodPowder.Type.MANGO.name().equals(name) || FoodPowder.Type.PINEAPPLE.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.melon_slice);
        }
        return baseline;
    }

    @Nonnull
    private Ingredient ingredientFrom() {
        return this._variant.datadata(Ingredient.class);
    }

    @Override
    public int getPortionFoodPoints(ItemStack stack) {
        int fp = super.getPortionFoodPoints(stack);
        if (this.isSoaked(stack)) {
            fp = LikeFood.soaked_gelo.healAmount();
        }
        return fp;
    }

    @Override
    public float getSaturationModifier(ItemStack stack) {
        float sm = super.getSaturationModifier(stack);
        if (this.isSoaked(stack)) {
            sm = LikeFood.soaked_gelo.saturationModifier();
        }
        return sm;
    }

    public final String varid() {
        return this._variant.name();
    }

    public final List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (Gelo gelo : INSTANCES) {
            all.add(gelo.createInstance((Item)gelo));
        }
        return all;
    }

    @Override
    public boolean isHiddenByDefault() {
        return VfpConfig.getInstance().showAllItemsInUI() ? false : !this.ingredientFrom().isEnabled();
    }

    static final void makeObjects() {
        if (INSTANCES == null && !VARIANT_FLAVORS.isEmpty()) {
            INSTANCES = new Gelo[VARIANT_FLAVORS.size()];
            String baseName = VfpOid.Gelo.fmlid() + "_";
            for (int i = 0; i < INSTANCES.length; ++i) {
                Ingredient flavor = VARIANT_FLAVORS.get(i);
                String fmlid = baseName + flavor.name().toLowerCase(Locale.US);
                Gelo.INSTANCES[i] = new Gelo(new VfpTransientVariant(i, fmlid, Gelo.like(flavor), flavor, null));
            }
        }
        VARIANT_FLAVORS.clear();
    }

    static final void addDictionaryEntries() {
        if (INSTANCES != null) {
            for (int i = 0; i < INSTANCES.length; ++i) {
                ItemStack a_gelo = new ItemStack((IItemProvider)INSTANCES[i]);
                RID.addToGroup((String)"foods/jellos", (ItemStack)a_gelo);
                RID.addToGroup((String)"carrots:gelos", (ItemStack)a_gelo);
            }
        }
    }
}

