/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.api.IEssential;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;

public final class HoneyPortion
extends VfpPantryItem
implements IEssential,
ICurative {
    public HoneyPortion() {
        super(VfpOid.Portion_Honey, LikeFood.water, null);
        this.setAlwaysEdible();
        Potions.addMilkBasedRegenEffect((Item)this, (int)this.getPotionEffectDurationSecs(true), (int)0);
        this.autoregister();
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        Potions.removePotionEffect((LivingEntity)player, (Effect)Effects.field_76436_u);
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
    }

    public boolean onCureDirectly(PlayerEntity player, ItemStack honey) {
        ItemStack remaining = ItemStacks.copysplit((ItemStack)honey);
        this.onFoodEaten(honey, remaining, player.func_130014_f_(), player);
        return true;
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? 3 : super.getPotionEffectDurationSecs(good);
    }
}

