/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.recipes.JR;
import org.jwaresoftware.mcmods.lib.recipes.ShapedRecipeWrapping;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class BasicTonicRecipe
extends ShapedRecipeWrapping {
    public static final String NAME = ModInfo.rstring("basic_tonic_shaped");
    public static final ShapedRecipeWrapping.Serializer<BasicTonicRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer(BasicTonicRecipe::new);

    BasicTonicRecipe(ShapedRecipe from) {
        super(from);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public ItemStack func_77572_b(CraftingInventory grid) {
        ItemStack out = ItemStack.field_190927_a;
        if (!VfpConfig.getInstance().allowMoonshineMixing()) {
            return out;
        }
        ItemStack potion = null;
        int n_spread = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next)) continue;
            if (RID.matches((ItemStack)next, (String)"empty_bottles", (Item)VfpObj.Our_Empty_Bottle_obj)) {
                ++n_spread;
                continue;
            }
            if (!Potions.isa((ItemStack)next, (boolean)false)) continue;
            if (potion != null) {
                return out;
            }
            potion = next;
        }
        if (n_spread == 1 && potion != null) {
            out = TonicDrink.create(potion, n_spread);
        }
        return out;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return BasicTonicRecipe.getRemainingIncludingEmptyGlassBottles(grid);
    }

    static final NonNullList<ItemStack> getRemainingIncludingEmptyGlassBottles(CraftingInventory grid) {
        NonNullList out = JR.defaultRecipeGetRemainingItems((CraftingInventory)grid);
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            if (!((ItemStack)out.get(i)).func_190926_b() || !Potions.isap((ItemStack)grid.func_70301_a(i), (boolean)false)) continue;
            out.set(i, (Object)new ItemStack((IItemProvider)Items.field_151069_bo));
        }
        return out;
    }
}

