/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;

public final class AddToBucketJarRecipe
extends VfpRecipe {
    public static final String NAME = ModInfo.rstring("addto_bigjar_shaped");

    AddToBucketJarRecipe() {
        super(new ResourceLocation(NAME));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 1;
    }

    public boolean matches(CraftingInventory grid, World world) {
        int N = grid.func_70302_i_();
        if (N < 2) {
            return false;
        }
        ItemStack from = grid.func_70301_a(0);
        IFluidHandlerItem fH_from = ItemStacks.getFluidHandler((ItemStack)ItemStacks.copy1((ItemStack)from));
        if (fH_from == null || fH_from.getFluidInTank(0).isEmpty()) {
            return false;
        }
        int jar_count = 0;
        for (int i = 1; i < N; ++i) {
            ItemStack to = grid.func_70301_a(i);
            if (to.func_190926_b()) continue;
            if (jar_count == 0 && (to.func_77973_b() == VfpObj.Empty_Bucket_Jar_obj || to.func_77973_b() == VfpObj.Full_Bucket_Jar_obj)) {
                ++jar_count;
                continue;
            }
            return false;
        }
        return jar_count == 1;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        ItemStack out = ItemStack.field_190927_a;
        IFluidHandlerItem fH_to = null;
        ItemStack next = grid.func_70301_a(0);
        IFluidHandlerItem fH_from = ItemStacks.getFluidHandler((ItemStack)ItemStacks.copy1((ItemStack)next));
        for (int i = 1; i < grid.func_70302_i_(); ++i) {
            next = grid.func_70301_a(i);
            if (next.func_190926_b()) continue;
            fH_to = ItemStacks.getFluidHandler((ItemStack)ItemStacks.copy1((ItemStack)next));
            if (fH_to != null) break;
            return out;
        }
        if (fH_from != null && fH_to != null) {
            int wantAmount = 1000 - fH_to.getFluidInTank(0).getAmount();
            if (wantAmount <= 0) {
                return out;
            }
            FluidStack got = fH_from.drain(wantAmount, IFluidHandler.FluidAction.EXECUTE);
            if (!got.isEmpty() && got.getAmount() <= wantAmount && fH_to.fill(got, IFluidHandler.FluidAction.EXECUTE) == got.getAmount()) {
                out = fH_to.getContainer();
            }
        }
        return out;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        NonNullList leftovers = NonNullList.func_191197_a((int)grid.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStack from = grid.func_70301_a(0);
        IFluidHandlerItem fH_from = ItemStacks.getFluidHandler((ItemStack)ItemStacks.copy1((ItemStack)from));
        for (int i = 1; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (next.func_190926_b()) continue;
            IFluidHandlerItem fH_to = ItemStacks.getFluidHandler((ItemStack)ItemStacks.copy1((ItemStack)next));
            int wantAmount = 1000 - fH_to.getFluidInTank(0).getAmount();
            fH_from.drain(wantAmount, IFluidHandler.FluidAction.EXECUTE);
            leftovers.set(0, (Object)fH_from.getContainer());
            break;
        }
        return leftovers;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AddToBucketJarRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public AddToBucketJarRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new AddToBucketJarRecipe();
        }

        public AddToBucketJarRecipe read(ResourceLocation recipeId, PacketBuffer data) {
            return new AddToBucketJarRecipe();
        }

        public void write(PacketBuffer data, AddToBucketJarRecipe recipe) {
        }
    }
}

