/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpToolItem;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.utensils.WorkedFlintTier;

public class FlintCutterItem
extends VfpToolItem {
    public static final int MAX_USES = 32;

    public static final FlintCutterItem tool() {
        return new FlintCutterItem(VfpOid.Flint_Cutter, 32);
    }

    public FlintCutterItem(VfpProfile profile, int durability) {
        super(profile, WorkedFlintTier.INSTANCE, VfpUtils.newproperties(VfpUtils.bestTab(profile, SharedGlue.CreativeTabs_tools)).addToolType(ToolType.get((String)SharedGlue.KNIFE_TOOLNAME()), SharedGlue.STONE_TOOL_LEVEL()).func_200918_c(durability <= 0 ? 32 : durability).setNoRepair());
        this.autoregister();
    }

    protected FlintCutterItem(VfpProfile profile, IItemTier material, Item.Properties ip) {
        super(profile, material, ip);
        this.autoregister();
    }

    protected final boolean isa(ItemStack cutter) {
        return !cutter.func_190926_b() && cutter.func_77973_b() == VfpObj.Flint_Cutter_obj;
    }

    public boolean func_82789_a(ItemStack cutter, ItemStack material) {
        return this.isa(cutter) && (RID.matches((ItemStack)material, (String)"flint", (Item)Items.field_151145_ak) || super.func_82789_a(cutter, material));
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment e) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canCraftWith(ItemStack cutter) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack cutter) {
        int usesLeft = ItemStacks.getUsesLeft((ItemStack)cutter);
        ItemStack output = ItemStack.field_190927_a;
        if (usesLeft > 1) {
            output = ItemStacks.copy1((ItemStack)cutter);
            this.setUsed(output, cutter.func_77952_i() + 1);
        }
        return output;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack cutter, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        super.func_77624_a(cutter, world, tooltip, flags);
        if (this.isa(cutter)) {
            Tooltips.addUsesLeftTipLine((int)ItemStacks.getUsesLeft((ItemStack)cutter), tooltip);
        }
    }

    static final FlintCutterItem cutterInstance() {
        return (FlintCutterItem)VfpObj.Flint_Cutter_obj;
    }

    public static final ItemStack gold() {
        return new ItemStack((IItemProvider)FlintCutterItem.cutterInstance());
    }

    public static final ItemStack repaired(int usesLeft) {
        usesLeft = Math.min(usesLeft, 32);
        ItemStack cutter = FlintCutterItem.gold();
        FlintCutterItem.cutterInstance().setUsed(cutter, cutter.func_77958_k() - usesLeft);
        return cutter;
    }
}

