/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.veggies;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.KelpTopBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public final class InkKelpTopBlock
extends KelpTopBlock
implements IModBlock,
VfpAware {
    private final VfpProfile _profile;
    private String _i18n = "";
    private final Supplier<Block> _kelpbody;

    public InkKelpTopBlock(@Nonnull VfpProfile profile, Supplier<Block> plant) {
        super(Block.Properties.func_200950_a((Block)Blocks.field_203214_jx));
        this._profile = Objects.requireNonNull(profile);
        this._kelpbody = Objects.requireNonNull(plant);
        VfpUtils.autoregisterBlock((Block)this, profile);
    }

    public final String itemid_prefix() {
        return this._profile.itemid_prefix();
    }

    @Override
    public final VfpProfile vfplink() {
        return this._profile;
    }

    @Nonnull
    public final String oid() {
        return this._profile.fmlid();
    }

    public String getTranslationKey(ItemStack stack) {
        if (this._i18n.isEmpty()) {
            this._i18n = ItemSupport.defaultTranslationKey((Block)this);
        }
        return this._i18n;
    }

    public final String func_149739_a() {
        return this.getTranslationKey(ItemStack.field_190927_a);
    }

    public BlockItem makeItemBlock(@Nonnull Block block, Item.Properties ip) {
        return new VfpPlainBlock.VfpBlockItem(block, ip);
    }

    public boolean func_196260_a(BlockState kelp, IWorldReader worldr, BlockPos pos) {
        if (kelp.func_177230_c() != this) {
            return super.func_196260_a(kelp, worldr, pos);
        }
        BlockPos below_pos = pos.func_177977_b();
        BlockState below = worldr.func_180495_p(below_pos);
        Block block_below = below.func_177230_c();
        return block_below == Blocks.field_196814_hQ || below.func_203425_a(RID.Tags.MAGMA_LIKE) ? false : block_below == this || block_below == this._kelpbody.get() || below.func_224755_d((IBlockReader)worldr, below_pos, Direction.UP);
    }

    public BlockState func_196271_a(BlockState kelp, Direction facing, BlockState facing_state, IWorld worldr, BlockPos kelp_pos, BlockPos facing_pos) {
        if (!kelp.func_196955_c((IWorldReader)worldr, kelp_pos)) {
            if (facing == Direction.DOWN) {
                return Blocks.field_150350_a.func_176223_P();
            }
            worldr.func_205220_G_().func_205360_a(kelp_pos, (Object)this, 1);
        }
        if (facing == Direction.UP && facing_state.func_177230_c() == this) {
            return this._kelpbody.get().func_176223_P();
        }
        worldr.func_205219_F_().func_205360_a(kelp_pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldr));
        return super.func_196271_a(kelp, facing, facing_state, worldr, kelp_pos, facing_pos);
    }
}

