/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.veggies;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.ILootedListener;
import org.jwaresoftware.mcmods.lib.api.ISoakable;
import org.jwaresoftware.mcmods.lib.capability.IGradeable;
import org.jwaresoftware.mcmods.lib.capability.QualityGrade;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableSimpleFood;

public class MysteriousFruitSalad
extends VfpSoakableSimpleFood
implements IGradeable,
ILootedListener {
    public static final String NBT_PROPERTY = "vfp_MysteryType";
    public static final String NBT_ADDLINFO = "vfp_MysteryData";
    protected static final List<String> _FLOWERS = (List)Util.func_200696_a(new ArrayList(), a -> {
        a.add("dandelion");
        a.add("poppy");
        a.add("allium");
        a.add("azure_bluet");
        a.add("pink_tulip");
        a.add("cornflower");
    });

    protected MysteriousFruitSalad(VfpProfile profile, Item.Properties ip, LikeFood like) {
        super(profile, ip, like, false);
        this._hidden = true;
    }

    public MysteriousFruitSalad() {
        super(VfpOid.Mysterious_Fruit_Salad, LikeFood.golden_berries, null);
        this.autoregister();
    }

    @Override
    public ItemStack createInstance(Item of, int amount) {
        if (of == null) {
            of = this;
        }
        return new ItemStack((IItemProvider)of, amount);
    }

    @Override
    public int getItemStackLimit(ItemStack salad) {
        return VfpCapacity.SMALL_STACK.count();
    }

    @Override
    public float getCompostChance() {
        return 1.0f;
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return SharedGlue.HEARTY_FOOD_CONSUME_DURATION();
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? 360 : 120;
    }

    protected void applyMysteriousEffects(ItemStack salad, PlayerEntity player) {
        if (!MysteryEffect.present(salad) && player.func_70681_au().nextFloat() < 0.9f) {
            salad = MysteryEffect.add_random(salad.func_77946_l(), player.func_70681_au());
        }
        MysteryEffect.from(salad).accept(player, salad);
    }

    @Override
    protected final void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        Potions.cureBadPotionEffectsWithMilk((LivingEntity)player, (boolean)true, (boolean)true, (boolean)false);
        Potions.addMilkBoostRegenEffect((LivingEntity)player);
        this.applyMysteriousEffects(original, player);
    }

    public QualityGrade getQualityGrade(ItemStack salad) {
        QualityGrade qg = super.getQualityGrade(salad);
        return qg.isKnown() ? qg : QualityGrade.GOLD;
    }

    @Override
    public final boolean isSoaked(ItemStack salad) {
        return false;
    }

    @Override
    public boolean canSoak(ItemStack salad) {
        return !MysteryEffect.present(salad);
    }

    @Override
    protected boolean canConsume(ItemStack held, World world, PlayerEntity player) {
        return player.func_71043_e(this.getBaseFood().func_221468_d());
    }

    @Override
    protected final boolean isInstaConsume(ItemStack held) {
        return false;
    }

    @Override
    public void onCookedOrCrafted(ItemStack salad) {
        if (!MysteryEffect.present(salad)) {
            salad.func_196083_e(NBT_PROPERTY);
            salad.func_196083_e(NBT_ADDLINFO);
        }
    }

    @Override
    public void notifyLooted(ItemStack salad, World world, PlayerEntity player, float luckLevel, String unused) {
        this.func_77622_d(salad, world, player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack salad, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (!MysteryEffect.present(salad)) {
            super.func_77624_a(salad, world, tooltip, flags);
        } else {
            if (ItemStacks.isFlaggedAsSample((ItemStack)salad)) {
                Tooltips.addSampleTipLine(tooltip);
            }
            this.addDebugInformation(salad, tooltip, flags);
        }
    }

    public static enum MysteryEffect implements BiConsumer<PlayerEntity, ItemStack>
    {
        NONE(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221803_eL}), (p, i) -> {}),
        RESILIENCE(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221687_cF}), (p, i) -> MysteryEffect.addEffect(p, Effects.field_76443_y, Effects.field_76444_x)),
        DARKSIGHT(() -> Ingredient.func_199805_a((Tag)Tags.Items.CROPS_CARROT), (p, i) -> MysteryEffect.addEffect(p, Effects.field_76439_r)),
        MOVEMENT(() -> Ingredient.func_199805_a((Tag)Tags.Items.CROPS_BEETROOT), (p, i) -> MysteryEffect.addEffect(p, Effects.field_76424_c, Effects.field_76430_j)),
        FAST_MOVEMENT(() -> Ingredient.func_199805_a((Tag)Tags.Items.CROPS_BEETROOT), (p, i) -> MysteryEffect.addEffect(p, 2, Effects.field_76424_c, Effects.field_76430_j)),
        BREATH(() -> Ingredient.func_199805_a((Tag)RID.getTag((String)"forge:foods/raw_kelp")), (p, i) -> MysteryEffect.addEffect(p, Effects.field_76427_o)),
        STRENGTH(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222065_kN}), (p, i) -> MysteryEffect.addEffect(p, 1, Effects.field_76420_g)),
        SHIELDING(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151072_bj}), (p, i) -> MysteryEffect.addEffect(p, Effects.field_76426_n, Effects.field_76429_m)),
        HEAVY_SHIELDING(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151072_bj}), (p, i) -> MysteryEffect.addEffect(p, 1, Effects.field_76426_n, Effects.field_76429_m)),
        ANYTHING(() -> Ingredient.func_199805_a((Tag)RID.getTag((String)"carrots:drinkable_potion_bottles")), (p, i) -> {
            if (i.func_190926_b() || !(i.func_77973_b() instanceof ISoakable)) {
                return;
            }
            String thing = ItemStacks.getString((ItemStack)(i = i.func_77946_l()), (String)MysteriousFruitSalad.NBT_ADDLINFO);
            if (thing.isEmpty()) {
                thing = "*random*";
            }
            ItemStacks.setString((ItemStack)i, (String)ISoakable.NBT_CREATE_SOAKED, (String)thing);
            int secs = VfpConfig.getInstance().maxMysteriousEffectDurationSecs();
            i = VfpSoakableSimpleFood.checkForSoakedLootItem(i, (ISoakable)i.func_77973_b(), secs, null);
            Potions.addPotionEffects((LivingEntity)p, (ItemStack)i);
        }),
        SUSPICION(() -> Ingredient.func_199805_a((Tag)ItemTags.field_219770_E), (p, i) -> {
            Block b;
            ResourceLocation rid;
            String flower = ItemStacks.getString((ItemStack)i, (String)MysteriousFruitSalad.NBT_ADDLINFO);
            if (flower.isEmpty()) {
                flower = _FLOWERS.get(p.func_70681_au().nextInt(_FLOWERS.size()));
            }
            if ((rid = ResourceLocation.func_208304_a((String)flower)) != null && ForgeRegistries.BLOCKS.containsKey(rid) && (b = (Block)ForgeRegistries.BLOCKS.getValue(rid)) instanceof FlowerBlock) {
                MysteryEffect.addEffect(p, -1, ((FlowerBlock)b).func_220094_d());
            }
        });

        private static final MysteryEffect[] _VALUES;
        private final String _id;
        private final Supplier<Ingredient> _ingredient;
        private final BiConsumer<PlayerEntity, ItemStack> _effect;

        private MysteryEffect(Supplier<Ingredient> i, BiConsumer<PlayerEntity, ItemStack> c) {
            this._ingredient = i;
            this._id = this.name().toLowerCase();
            this._effect = c;
        }

        public final String id() {
            return this._id;
        }

        public final Ingredient ingredient() {
            return this._ingredient.get();
        }

        public final ItemStack add(ItemStack to, @Nullable String addl) {
            if (this != NONE) {
                ItemStacks.setString((ItemStack)to, (String)MysteriousFruitSalad.NBT_PROPERTY, (String)this.id());
                if (addl != null) {
                    ItemStacks.setString((ItemStack)to, (String)MysteriousFruitSalad.NBT_ADDLINFO, (String)addl);
                }
            }
            return to;
        }

        @Nonnull
        public static final MysteryEffect fromString(String s) {
            if (s != null) {
                for (MysteryEffect i : _VALUES) {
                    if (!i.id().equals(s)) continue;
                    return i;
                }
            }
            return NONE;
        }

        @Nonnull
        public static final MysteryEffect from(ItemStack stack) {
            return ItemStacks.hasString((ItemStack)stack, (String)MysteriousFruitSalad.NBT_PROPERTY) ? MysteryEffect.fromString(ItemStacks.getString((ItemStack)stack, (String)MysteriousFruitSalad.NBT_PROPERTY)) : NONE;
        }

        public static final boolean present(ItemStack stack) {
            return MysteryEffect.from(stack) != NONE;
        }

        private static final void addEffect(PlayerEntity player, int max_amplifier, Effect ... es) {
            int secs = VfpConfig.getInstance().maxMysteriousEffectDurationSecs();
            int amplifier = 0;
            if (max_amplifier > 0) {
                amplifier = player.func_70681_au().nextInt(max_amplifier + 1);
            }
            for (Effect e : es) {
                Potions.addStubbornPotionEffect((LivingEntity)player, (Effect)e, (int)secs, (int)amplifier, (boolean)false, (boolean)false);
            }
        }

        private static final void addEffect(PlayerEntity player, Effect ... es) {
            MysteryEffect.addEffect(player, -1, es);
        }

        public static final MysteryEffect random(@Nullable Random rng) {
            if (rng == null) {
                rng = LibInfo.RNG;
            }
            return _VALUES[rng.nextInt(_VALUES.length)];
        }

        public static final ItemStack add_random(@Nonnull ItemStack stack, @Nullable Random rng) {
            MysteryEffect.random(rng).add(stack, null);
            return stack;
        }

        @Override
        public void accept(PlayerEntity eater, ItemStack stack) {
            this._effect.accept(eater, stack);
        }

        static {
            _VALUES = MysteryEffect.values();
        }
    }
}

