/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.water;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IDrink;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.integration.ENVHelper;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;

public final class BucketOfPotableWater
extends VfpLiquidFood
implements IDrink,
IReheatable {
    private static final int _1MIN = 60;
    private static final int _4MINS = 240;
    private static final int _COOLDOWN_TICKS_VAN = 60 * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();
    private static final int _COOLDOWN_TICKS_EXT = 300 * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();

    public BucketOfPotableWater() {
        super(VfpOid.Bucket_Potable_Water, LikeFood.water);
        this.setContainerItem(Items.field_151133_ar);
        this.setAlwaysEdible();
        this.func_185043_a(new ResourceLocation("temperature"), ITemperatureChangeable.TemperaturePropertyGetter.forHeatable());
        this.autoregister();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return Items.field_151133_ar;
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpCapacity.NONE;
    }

    @Override
    public final int getItemStackLimit(ItemStack bucket) {
        return 1;
    }

    public final int getThirstQuenched(ItemStack drink) {
        return LiquidType.POWER.getThirstQuenched(drink);
    }

    public final float getHydrationAdded(ItemStack drink) {
        return LiquidType.POWER.getHydrationAdded(drink);
    }

    public final int getCoolDuration(ItemStack bucket) {
        return 480;
    }

    @Override
    public boolean canPlayerHeat(ItemStack stack) {
        return true;
    }

    @Override
    public void onCookedOrCrafted(ItemStack bucket) {
        ITemperatureChangeable.UsedEffect e = this.onCreateCheckBonusTemperature(bucket);
        super.onCookedOrCrafted(bucket);
        if (ITemperatureChangeable.UsedEffect.HEATED.equals((Object)e)) {
            this.setHeated(bucket);
        }
    }

    @Override
    protected void onFoodEaten(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        Potions.cureFireBurningEffects((PlayerEntity)player, (boolean)true);
        super.onFoodEaten(original, remaining, world, player);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        int cooldown = _COOLDOWN_TICKS_VAN;
        if (VfpConfig.manageThirst()) {
            ENVHelper.quenchThirst((PlayerEntity)player, (IDrink)this, (ItemStack)original);
            cooldown = _COOLDOWN_TICKS_EXT;
        }
        if (VfpConfig.manageTemperature()) {
            int baseDuration = this.getBonusTemperatureTimeLeftForApply(original, 240);
            if (this.isHeated(original)) {
                ENVHelper.warmIfCold((PlayerEntity)player, (int)2, (int)baseDuration, (int)baseDuration);
            } else {
                ENVHelper.coolIfHot((PlayerEntity)player, (int)2, (int)baseDuration, (int)baseDuration);
            }
            cooldown = _COOLDOWN_TICKS_EXT;
        }
        player.func_184811_cZ().func_185145_a((Item)this, cooldown);
    }

    public void func_77663_a(ItemStack bucket, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(bucket, world, holder, slotindex, selected);
    }
}

