/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.water;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.api.IDrinkableFluid;
import org.jwaresoftware.mcmods.lib.api.IEssential;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public final class Water
extends VfpLiquidMultiItem
implements IReheatable,
IEssential,
ICurative {
    private static final int _1MINS = 60;
    private static final int _2MINS = 120;
    private static final int _3MINS = 180;
    public static final int GENERIC_COLOR = 3694022;
    public static final int SWEET_COLOR = 9411776;
    public static final int ROSE_COLOR = 15059658;
    public static final int TONICS_COLOR = 15708682;
    public static final int TULIP_COLOR = 0xFFCACA;
    public static final int FIZZY_COLOR = 33731;
    public static final int SWAMP_COLOR = 4354870;
    public static final int BIRCH_COLOR = 12503149;
    public static final int DIRTY_COLOR = 6970698;
    private static final int _PLAIN = 0;
    private static final int _SWEET = 1;
    private static final int _ROSE = 2;
    private static final int _TULIP = 3;
    private static final int _FIZZY = 4;
    private static final int _SWAMP = 5;
    private static final int _DIRTY = 6;
    private static final int _BIRCH = 7;
    static final int _IDS_END = 8;
    private static final ItemStackDef _PLACEHOLDER = ItemStackDef.UNUSED;
    private static final List<Ingredient> VARIANTS = new ArrayList<Ingredient>(23);
    private static Water[] INSTANCES;
    private static boolean _INCLUDE_BIRCH;
    private static boolean _INCLUDE_DIRTY;

    public static final synchronized boolean register(String name, String primary, int colorValue) {
        Validate.notNull((Object)name, (String)"A non-null flavor is required for a flavored water drink", (Object[])new Object[0]);
        Flavor flavor = new Flavor(VARIANTS.size(), name, DictionaryNameItemAdaptor.newi(primary), colorValue);
        return Water.register(flavor, VARIANTS, "water");
    }

    Water(VfpVariant variant) {
        super((VfpProfile)VfpOid.Water_Bottle, variant, LiquidType.WATER);
        this.func_185043_a(new ResourceLocation("temperature"), ITemperatureChangeable.TemperaturePropertyGetter.forCoolable());
        this.setAlwaysEdible();
        this.autoregister();
    }

    @Nonnull
    private Ingredient ingredientFrom() {
        return this._variant.datadata(Ingredient.class);
    }

    public String oid() {
        Ingredient ingredient = this.ingredientFrom();
        return ingredient.id() == 4 ? VfpOid.Water_Bottle_Fizzy.fmlid() : VfpOid.Water_Bottle.fmlid();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return VfpObj.Our_Empty_Bottle_obj;
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpCapacity.MAX_STACK;
    }

    @Override
    public int func_77626_a(ItemStack drink) {
        Ingredient ingredient = this.ingredientFrom();
        return ingredient.id() == 3 ? SharedGlue.SHORT_FOOD_CONSUME_DURATION() : SharedGlue.DEFAULT_LIQUID_USE_DURATION();
    }

    @Override
    protected Integer getColorFromIngredient(Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getColorFromIngredient(ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 3694022;
        }
        return colorValue;
    }

    @Override
    protected boolean showSubItem(VfpVariant variant, ItemGroup forTab, ItemGroup pickedTab) {
        boolean show = true;
        if (!VfpConfig.getInstance().showAllItemsInUI()) {
            int id = variant.metadata();
            if (id == 7) {
                show = _INCLUDE_BIRCH;
            } else if (id == 6) {
                show = _INCLUDE_DIRTY;
            }
        }
        return show;
    }

    public boolean isCureAvailable(@Nonnull PlayerEntity player, ItemStack drink) {
        int id = this.ingredientFrom().id();
        return id != 5 && id != 1;
    }

    public boolean onCureDirectly(PlayerEntity player, ItemStack drink) {
        ItemStack remaining = ItemStacks.copysplit((ItemStack)drink);
        this.onFoodEaten(drink, remaining, player.func_130014_f_(), player);
        return true;
    }

    @Override
    protected void onFoodEaten(ItemStack drink, ItemStack remaining, World world, PlayerEntity player) {
        int id = this.ingredientFrom().id();
        if (id == 3) {
            Potions.cureFireBurningEffects((PlayerEntity)player, (boolean)true);
        }
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            if (id == 7) {
                IDrinkableFluid.BIRCH_SAP.onDrunk(drink, (LivingEntity)player);
            }
            if (id == 2) {
                Potions.removePotionEffectUnconditionally((LivingEntity)player, (Effect)SharedGlue.Potion_poison);
            }
            if (id == 3) {
                Potions.removePotionEffectUnconditionally((LivingEntity)player, (Effect)SharedGlue.Potion_poison);
                boolean badJuJu = player.func_70644_a(SharedGlue.Potion_badLuck);
                if (badJuJu) {
                    Potions.removePotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_badLuck);
                } else if (player.func_70681_au().nextInt(8) == 0) {
                    Potions.addStubbornPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_luck, (int)180, (int)0, (boolean)false, (boolean)true);
                }
            }
            if (!VfpConfig.manageThirst() && player.func_70681_au().nextFloat() < this.getThirstTriggerChance(drink)) {
                Potions.addPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_hunger, (int)(60 + player.func_70681_au().nextInt(60)), (int)0, (boolean)false, (boolean)true);
            }
            if (id == 5 && player.func_70681_au().nextInt(4) == 0) {
                Potions.addPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_levitation, (int)(60 + player.func_70681_au().nextInt(120)), (int)0, (boolean)false, (boolean)true);
                Potions.addPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_glowing, (int)180, (int)0, (boolean)false, (boolean)true);
            }
        }
        super.onFoodEaten(drink, remaining, world, player);
    }

    @Override
    public int getThirstQuenched(ItemStack drink) {
        Ingredient ingredient;
        int amount = super.getThirstQuenched(drink);
        if (!(drink.func_190926_b() || (ingredient = this.ingredientFrom()).id() != 1 && ingredient.id() != 5)) {
            amount = LiquidType.SLIGHT.getThirstQuenched(drink);
        }
        return amount;
    }

    @Override
    public float getHydrationAdded(ItemStack drink) {
        Ingredient ingredient;
        float amount = super.getHydrationAdded(drink);
        if (!(drink.func_190926_b() || (ingredient = this.ingredientFrom()).id() != 1 && ingredient.id() != 5)) {
            amount = LiquidType.SLIGHT.getHydrationAdded(drink);
        }
        return amount;
    }

    @Override
    public int getTemperatureModifier(ItemStack drink) {
        Ingredient ingredient = this.ingredientFrom();
        int chillModifier = 0;
        int id = ingredient.id();
        if (id == 0) {
            chillModifier = 3;
        } else if (id == 4 || id == 6) {
            chillModifier = 2;
        } else if (id == 3 || id == 2) {
            chillModifier = 2;
        }
        return chillModifier;
    }

    public int getCoolDuration(ItemStack drink) {
        return 480;
    }

    public int getBonusTemperatureTimeLeftForApply(ItemStack drink, int min) {
        if (this.getTemperatureModifier(drink) < 1) {
            return 0;
        }
        if (min <= 0) {
            min = 90;
        }
        return Math.max(min, this.getBonusTemperatureTimeLeft(drink));
    }

    @Override
    public float getThirstTriggerChance(ItemStack drink) {
        float chance = 0.0f;
        int id = this.ingredientFrom().id();
        if (id == 5) {
            chance = 0.9f;
        } else if (id == 6) {
            chance = 0.75f;
        } else if (id == 1) {
            chance = 0.15f;
        }
        return chance;
    }

    @Override
    public void onCookedOrCrafted(ItemStack drink) {
        ITemperatureChangeable.UsedEffect e = ITemperatureChangeable.UsedEffect.UNCHANGED;
        if (this.getTemperatureModifier(drink) > 0) {
            e = this.onCreateCheckBonusTemperature(drink);
        }
        super.onCookedOrCrafted(drink);
        if (ITemperatureChangeable.UsedEffect.COOLED.equals((Object)e)) {
            this.setCooled(drink);
        }
    }

    public void func_77663_a(ItemStack drink, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(drink, world, holder, slotindex, selected);
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            INSTANCES = new Water[VARIANTS.size()];
            String baseName = "bottle_";
            for (int i = 0; i < INSTANCES.length; ++i) {
                LikeFood like;
                Ingredient ingredient = VARIANTS.get(i);
                int iid = ingredient.id();
                LikeFood likeFood = like = ingredient.isPlaceholder() ? LikeFood.water : LikeFood.flavored_water;
                if (iid == 7 || iid == 3) {
                    like = LikeFood.birch_sap;
                } else if (iid == 2 || iid == 5) {
                    like = LikeFood.bush_tea;
                }
                Water.INSTANCES[i] = new Water(new VfpTransientVariant(ingredient.id(), "bottle_" + ingredient.name(), like, ingredient, null));
            }
        }
    }

    static final void addDictionaryEntries() {
        if (INSTANCES != null) {
            ItemStack plain_water = Water.plain(1);
            RID.addToGroup((String)"carrots:portions_water", (ItemStack)plain_water);
            RID.addToGroup((String)"water_bottles", (ItemStack)plain_water);
            for (Ingredient ingredient : VARIANTS) {
                int id = ingredient.id();
                ItemStack a_water_drink = new ItemStack((IItemProvider)INSTANCES[id]);
                if (id != 5 && id != 6) {
                    RID.addToGroup((String)"foods/drinks", (ItemStack)a_water_drink);
                }
                if (id != 0 && id != 7 && id != 3) continue;
                RID.addToGroup((String)"carrots:curatives/foods", (ItemStack)a_water_drink);
            }
        }
    }

    static final void setRecipeRewards(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        _INCLUDE_DIRTY = config.useTreatedWaterRecipes();
        boolean bl = _INCLUDE_BIRCH = config.isSuperBlocksPresent() && !ModIntegration.SUPERBLOCKS.itemstack("tree_tapping_basin").func_190926_b();
        if (config.includePotionBrewing()) {
            BrewEffect.addRecipeFor((Item)INSTANCES[5], (Potion)VfpPotions.SWAMP_ESSENCE);
            BrewEffect.addStrengthConversionFor((Potion)VfpPotions.SWAMP_ESSENCE, (Potion)VfpPotions.STRONG_SWAMP_ESSENCE);
        }
    }

    public static final boolean isa(ItemStack stack) {
        return !ItemStacks.isEmpty((ItemStack)stack) && stack.func_77973_b() instanceof Water;
    }

    public static final Item bottle() {
        return INSTANCES[0];
    }

    public static final ItemStack plain(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[0], amount);
    }

    public static final ItemStack sweet(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[1], amount);
    }

    public static final ItemStack fizzy(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[4], amount);
    }

    public static final ItemStack rose(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[2], amount);
    }

    public static final ItemStack tulip(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[3], amount);
    }

    public static final ItemStack swamp(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[5], amount);
    }

    public static final ItemStack dirty(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[6], amount);
    }

    public static final ItemStack birch(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[7], amount);
    }

    public static final boolean canWaterCrops(ItemStack with) {
        int i;
        return Water.isa(with) && (i = ((Water)with.func_77973_b())._variant.index()) != 7 && i != 1;
    }

    static {
        Flavor plain_water = new Flavor(0, "water", _PLACEHOLDER, -1);
        VARIANTS.add(plain_water);
        Flavor sweet_water = new Flavor(1, "syrup_base", "ingredients/sweeteners", 9411776);
        VARIANTS.add(sweet_water);
        Flavor rose_water = new Flavor(2, "rose_water", "foods/flowers/roses", 15059658);
        VARIANTS.add(rose_water);
        Flavor tulip_water = new Flavor(3, "tulip_tonic", _PLACEHOLDER, 0xFFCACA);
        VARIANTS.add(tulip_water);
        Flavor fizzy_water = new Flavor(4, "fizzy_water", _PLACEHOLDER, 33731);
        VARIANTS.add(fizzy_water);
        Flavor swamp_water = new Flavor(5, "swamp_water", _PLACEHOLDER, 4354870);
        VARIANTS.add(swamp_water);
        Flavor dirty_water = new Flavor(6, "dirty_water", _PLACEHOLDER, 6970698);
        VARIANTS.add(dirty_water);
        Flavor birch_sap = new Flavor(7, "birch_sap", _PLACEHOLDER, 12503149);
        VARIANTS.add(birch_sap);
        _INCLUDE_BIRCH = false;
        _INCLUDE_DIRTY = false;
    }

    public static final class Flavor
    extends Ingredient
    implements FoodColor {
        private final int _colorValue;

        Flavor(int id, String name, ItemStackDef primary, int colorValue) {
            super(name, id, primary, 1);
            this._colorValue = colorValue >= 0 ? colorValue : 3694022;
        }

        Flavor(int id, String name, String primary, int colorValue) {
            this(id, name, DictionaryNameItemAdaptor.newi(primary), colorValue);
        }

        @Override
        public int color(ItemStack stack) {
            return this._colorValue;
        }
    }
}

