/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class Association {
    public String uuid;
    @Nullable
    public ITextComponent name;

    Association() {
    }

    public Association(@Nonnull LivingEntity living) {
        this.uuid = living.func_189512_bd();
        this.name = SharedGlue.isaPlayer((Entity)living) ? SharedGlue.getPlayerOrNull((Entity)living).func_200200_C_() : (living.func_145818_k_() ? living.func_200201_e() : living.func_145748_c_());
    }

    public Association(@Nonnull TileEntity machine) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("m||").append(machine.func_200662_C().getRegistryName().toString()).append("||");
        BlockPos bp = machine.func_174877_v();
        sb.append(bp.func_218275_a());
        this.uuid = sb.toString();
        if (machine instanceof INameable) {
            INameable spi = (INameable)machine;
            this.name = spi.func_145818_k_() ? spi.func_200201_e() : spi.func_145748_c_();
        }
    }

    public Association(@Nonnull LivingEntity living, ITextComponent display) {
        this.uuid = living.func_189512_bd();
    }

    @Nonnull
    public final String displayName() {
        return this.name != null ? this.name.getString() : "";
    }

    public final boolean isMachine() {
        return this.uuid != null && this.uuid.startsWith("m||") && this.uuid.lastIndexOf("||") > 1;
    }

    public static final class NBTKey
    implements Comparable<NBTKey> {
        public final String ID;
        public final String NAME;
        public static final NBTKey BLANK = new NBTKey();
        public static final NBTKey OWNER = new NBTKey("OwnerUUID", "OwnerName");
        public static final NBTKey CREATOR = new NBTKey("MakerUUID", "MakerName");
        public static final NBTKey VENDOR = new NBTKey("VendorUUID", "VendorName");

        public NBTKey(String id, String name) {
            this.ID = id;
            this.NAME = name;
        }

        private NBTKey() {
            this(null, null);
        }

        public static final boolean isEmpty(NBTKey key) {
            return key == null || key == BLANK || key.ID == null || key.ID.isEmpty();
        }

        @Override
        public int compareTo(NBTKey other) {
            if (other == null) {
                throw new NullPointerException();
            }
            if (other == this) {
                return 0;
            }
            return this.ID.compareTo(other.ID);
        }
    }
}

