/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.lib.advancements.CarrotsTriggers;
import org.jwaresoftware.mcmods.lib.barter.Bartering;
import org.jwaresoftware.mcmods.lib.impl.AttributeSupport;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.PlaceboEffect;
import org.jwaresoftware.mcmods.lib.impl.block.BlockSupport;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalFluids;
import org.jwaresoftware.mcmods.lib.impl.item.NutritionProfile;
import org.jwaresoftware.mcmods.lib.impl.network.LibNetworkMessages;
import org.jwaresoftware.mcmods.lib.integration.BaublesHelper;
import org.jwaresoftware.mcmods.lib.integration.EnvironHelper;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.recipes.JR;

@Mod(value="carrots")
@Mod.EventBusSubscriber(modid="carrots", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CarrotsLib {
    public static final String NAME = "Carrots Lib";
    public static final String MOD_ID = "carrots";
    public static final String RESOURCES_ID = "carrots:";
    public static final String PREFIX = "carrots.";
    public static final String CAMEL_PREFIX = "carrots_";
    public static final String VERSION = "3.0b1";
    public static final String VERSION_CHECK_URL = "http://jwaresoftware.org/files/mcmods/versions/carrotslib.json";
    public static CarrotsLib instance;
    LibConfig _libConfig;

    public CarrotsLib() {
        instance = this;
        this.getLog().info("{} mod constructor called", (Object)NAME);
        Tooltips.initLanguageSupport();
        LibNetworkMessages.initIDSupport();
        AttributeSupport.initAttributeSupport();
        this._libConfig = new LibConfig().setInstance();
        BlockSupport.initAmendmentSupport();
        ItemSupport.initAmendmentSupport();
        Potions.initAmendmentSupport();
        BrewEffect.initRecipeSupport();
        JR.initRecipeSupport();
        Armory.initAmendmentSupport();
        Loot.initAmendmentSupport();
        Whatis.initLoad0();
        PlaceboEffect.initRecipeSupport();
        EnvironHelper.initDefaults();
        BaublesHelper.initDefaults();
        Loot.initDefaults();
        IEventBus initEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        initEventBus.addListener(this::init1);
        initEventBus.addListener(this::init2);
        initEventBus.addListener(this::init3);
        MinecraftForge.EVENT_BUS.addListener(this::serverHasStarted);
    }

    @Nonnull
    public final Logger getLog() {
        return LibInfo.LOG;
    }

    private void init1(FMLCommonSetupEvent event) {
        CarrotsTriggers.initTriggerSupport();
    }

    private void init2(InterModEnqueueEvent event) {
        EnvironHelper.initFinalize();
        BaublesHelper.initFinalize();
    }

    private void init3(InterModProcessEvent event) {
        this._libConfig.initFinalize();
        Loot.initFinalize();
        Potions.initFinalize();
        CarrotsTriggers.initFinalize();
    }

    private void serverHasStarted(FMLServerStartedEvent unused) {
        Locations.cacheDimensionTypes();
        NutritionProfile.initFinalize();
        Loot.cacheEnchantProfileSamples();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEventsHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            CarrotsLib.instance._libConfig.initEarly();
            UniversalFluids.makeFluids();
            IniRegistries.autoregisterBlocks(CarrotsLib.MOD_ID, (IForgeRegistry<Block>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            Bartering.makeTokens();
            IniRegistries.autoregisterItems(CarrotsLib.MOD_ID, (IForgeRegistry<Item>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerFluids(RegistryEvent.Register<Fluid> event) {
            IniRegistries.autoregisterFluids(CarrotsLib.MOD_ID, (IForgeRegistry<Fluid>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerPotions(RegistryEvent.Register<Effect> event) {
            IniRegistries.autoregisterPotions(CarrotsLib.MOD_ID, (IForgeRegistry<Effect>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerPotionMixes(RegistryEvent.Register<Potion> event) {
            IniRegistries.autoregisterPotionMixes(CarrotsLib.MOD_ID, (IForgeRegistry<Potion>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            JR.autoregisterSerializers(event.getRegistry());
        }
    }
}

