/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class Effects {
    private static final int[] RAINBOW = new int[]{0xFF00FF, 65280, 16766464, 0xFF7700, 16737969, 0xFF0000, 10367436, 4194284, 865008, 12979696, 15732160, 15740941, 15784461, 12185613, 4452365, 913520};

    public static final void play(int eventid, World world, BlockPos at) {
        world.func_217379_c(eventid, at, 0);
    }

    public static final void play(int eventid, World world, BlockPos at, int data) {
        world.func_217379_c(eventid, at, data);
    }

    public static final void playThisBlockBreak(World world, BlockPos at, Block block) {
        BlockState bs = world.func_180495_p(at);
        int id = bs.func_177230_c() == block ? Block.func_196246_j((BlockState)world.func_180495_p(at)) : Block.func_196246_j((BlockState)block.func_176223_P());
        world.func_217379_c(SharedGlue.BLOCK_BREAK_SFX(), at, id);
    }

    public static final void playHappySplashed(World world, BlockPos at) {
        Effects.play(SharedGlue.BONEMEAL_SPARKLE_SFX(), world, at);
    }

    public static final void playFertilizedSuccessfully(World world, BlockPos at) {
        Effects.play(SharedGlue.BONEMEAL_SPARKLE_SFX(), world, at);
    }

    public static final void playUsedHoeSuccessfully(World world, BlockPos at) {
        world.func_184133_a((PlayerEntity)null, at, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static final void playPoisonSplashed(World world, BlockPos at) {
        world.func_217379_c(SharedGlue.POTION_SFX(), at, 32660);
    }

    public static final void playPotionSplashed(World world, BlockPos at) {
        world.func_217379_c(SharedGlue.POTION_SFX(), at, Potions.getColor(SharedGlue.PotionType_harmless));
    }

    public static final void playPotionSplashed(World world, BlockPos at, int color) {
        world.func_217379_c(SharedGlue.POTION_SFX(), at, color);
    }

    public static final void playThrowingItemSound(World world, @Nonnull PlayerEntity player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), sound, SoundCategory.PLAYERS, volume, pitch);
    }

    public static final void playUseItemFailedSound(World world, @Nonnull PlayerEntity player) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SharedGlue.RANDOM_CLICK_SOUND(), SoundCategory.BLOCKS, 0.9f, player.func_70681_au().nextFloat() * 0.1f + 0.9f);
    }

    public static final void playUseItemFailedSoundFromServer(World world, @Nonnull PlayerEntity player) {
        world.func_217379_c(SharedGlue.DISPENSER_FAILED_SFX(), new BlockPos(player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_()), 0);
    }

    public static final void playTargetedItemSound(World world, @Nonnull PlayerEntity player) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SharedGlue.RANDOM_FIZZ_SOUND(), SoundCategory.NEUTRAL, 0.9f, player.func_70681_au().nextFloat() * 0.1f + 0.9f);
    }

    public static final void playDispenserSound(World world, BlockPos at, boolean successful) {
        world.func_217379_c(successful ? SharedGlue.DISPENSER_SUCCEEDED_SFX() : SharedGlue.DISPENSER_FAILED_SFX(), at, 0);
    }

    public static final void playExtinguishingHissss(World world, BlockPos at, float volume) {
        world.func_184148_a(null, (double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, SharedGlue.RANDOM_FIZZ_SOUND(), SoundCategory.NEUTRAL, volume, world.func_201674_k().nextFloat() * 0.1f + 0.9f);
    }

    public static final void playExtinguishingHissssEvent(World world, BlockPos at) {
        Effects.play(1009, world, at);
    }

    public static final void playExtinguishedBurning(World world, @Nonnull PlayerEntity player) {
        world.func_184148_a(null, player.func_226277_ct_() + 0.5, player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, SharedGlue.RANDOM_FIZZ_SOUND(), SoundCategory.PLAYERS, 1.0f, 1.6f + (world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.4f);
    }

    public static final void playVeryHeavyThingLanded(World world, BlockPos at) {
        Effects.play(SharedGlue.ANVIL_LANDED_SFX(), world, at);
    }

    public static final void playHarvestedCropSound(World world, BlockPos at) {
        world.func_184133_a(null, at, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + world.func_201674_k().nextFloat() * 0.4f);
    }

    public static final void playSound(World world, @Nonnull PlayerEntity player, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), sound, category == null ? SoundCategory.NEUTRAL : category, volume, pitch);
    }

    public static final void playSoundFor(World world, @Nonnull PlayerEntity player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), sound, SoundCategory.PLAYERS, volume, pitch);
    }

    public static final void playSound(World world, @Nonnull PlayerEntity player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), sound, SoundCategory.PLAYERS, volume, pitch);
    }

    public static final void playHostileSound(World world, @Nonnull PlayerEntity player, SoundEvent sound, float volume) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), sound, SoundCategory.HOSTILE, volume, world.func_201674_k().nextFloat() * 0.1f + 0.9f);
    }

    public static final void playBlockSound(World world, @Nonnull PlayerEntity player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), sound, SoundCategory.BLOCKS, volume, pitch);
    }

    public static final void playProjectileHitBlock(World world, @Nonnull BlockPos pos, SoundEvent sound) {
        if (sound == null) {
            sound = SoundEvents.field_187843_fX;
        }
        world.func_184133_a(null, pos, sound, SoundCategory.AMBIENT, 0.5f, 0.65f);
    }

    public static final void playMagicalInteraction(World world, @Nonnull PlayerEntity player, float volume, float pitch) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SharedGlue.SPARKLE_SOUND(), SoundCategory.RECORDS, volume, pitch);
    }

    public static final void playFoodConsumed(World world, PlayerEntity player, float volume, float pitch) {
        Effects.playSound(world, player, SharedGlue.PLAYER_BURP_SOUND(), volume, pitch);
    }

    public static final void playFoodConsumed(World world, PlayerEntity player) {
        Effects.playSound(world, player, SharedGlue.PLAYER_BURP_SOUND(), 0.5f, world.func_201674_k().nextFloat() * 0.1f + 0.9f);
    }

    public static final void playFeedMeSeymourChomp(World world, PlayerEntity player, BlockPos plant) {
        world.func_184148_a(null, (double)plant.func_177958_n() + 0.5, (double)plant.func_177956_o() + 0.5, (double)plant.func_177952_p() + 0.5, SoundEvents.field_187537_bA, SoundCategory.NEUTRAL, 0.9f, world.func_201674_k().nextFloat() * 0.1f + 0.9f);
    }

    public static final void playHealthConsumed(World world, @Nonnull PlayerEntity player) {
        Effects.playSound(world, player, SoundEvents.field_189109_ed, 0.15f, 0.5f * ((world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.7f + 1.8f));
    }

    public static final void playXpEaten(World world, @Nonnull PlayerEntity player) {
        Effects.playSound(world, player, SharedGlue.PLAYER_BURP_SOUND(), 0.15f, 0.5f * ((world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.7f + 1.8f));
    }

    public static final void playXpLevelUp(World world, @Nonnull PlayerEntity player, int loudThreshold) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SoundEvents.field_187802_ec, player.func_184176_by(), player.field_71068_ca > loudThreshold ? 0.75f : 0.5f, 1.0f);
    }

    public static final void playXpSiphonedFrom(World world, PlayerEntity player, boolean burp) {
        Effects.playSound(world, player, burp ? SharedGlue.PLAYER_BURP_SOUND() : SoundEvents.field_187664_bz, 0.5f, world.func_201674_k().nextFloat() * 0.1f + 0.9f);
    }

    public static final void playXpOffLoaded(World world, PlayerEntity player, float volume) {
        Effects.playSound(world, player, SharedGlue.XP_INTERACT_SOUND(), volume, 0.5f * ((world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.7f + 1.8f));
    }

    public static final void playBucketOfLiquidScoopedUp(World world, PlayerEntity player, @Nullable Material liquid) {
        Effects.playSound(world, player, SharedGlue.LIQUID_SCOOPED_SOUND(liquid == null ? Material.field_151586_h : liquid), 1.0f, 1.0f);
    }

    public static final void playBucketOfLiquidScoopedUp(World world, PlayerEntity player, @Nonnull FluidStack liquid) {
        Effects.playBlockSound(world, player, liquid.getFluid().getAttributes().getFillSound(liquid), 1.0f, 1.0f);
    }

    public static final void playBucketOfLiquidPlacedDown(World world, PlayerEntity player, @Nullable Material liquid) {
        Effects.playSound(world, player, SharedGlue.LIQUID_PUTDOWN_SOUND(liquid == null ? Material.field_151586_h : liquid), 1.0f, 1.0f);
    }

    public static final void playBucketOfLiquidPlacedDown(World world, PlayerEntity player, @Nonnull FluidStack liquid) {
        Effects.playBlockSound(world, player, liquid.getFluid().getAttributes().getEmptySound(liquid), 1.0f, 1.0f);
    }

    public static final void playBottleOfWaterScoopedUp(World world, PlayerEntity player) {
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public static final void playBlockPlaced(World world, PlayerEntity by, BlockState block, BlockPos at) {
        SoundType soundType = block.getSoundType((IWorldReader)world, at, (Entity)by);
        world.func_184133_a(by, at, block.func_215695_r().func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }

    public static final void playExplosionFizzled(World world, BlockPos at, float volume) {
        world.func_184148_a(null, (double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, SoundEvents.field_187637_bq, SoundCategory.BLOCKS, volume, (1.0f + (world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.2f) * 0.7f);
    }

    public static final void playPotionLevelUp(World world, @Nonnull PlayerEntity player) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SoundEvents.field_187802_ec, player.func_184176_by(), 1.0f, 1.0f);
    }

    public static final void playBlockBOOM(World world, @Nullable PlayerEntity player, BlockPos at) {
        world.func_184148_a(player, (double)at.func_177958_n(), (double)at.func_177956_o(), (double)at.func_177952_p(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static final void playGodsBOOM(World world, @Nullable PlayerEntity player, BlockPos at, boolean fromOnHigh) {
        double x = (double)at.func_177958_n() + 0.5;
        double y = (double)at.func_177956_o() + 0.5;
        double z = (double)at.func_177952_p() + 0.5;
        if (fromOnHigh) {
            world.func_184148_a((PlayerEntity)null, x, y, z, SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + world.func_201674_k().nextFloat() * 0.2f);
        }
        world.func_184148_a((PlayerEntity)null, x, y, z, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + world.func_201674_k().nextFloat() * 0.2f);
    }

    public static final void playCreepyGroan(World world, PlayerEntity player, boolean wary) {
        Effects.playSound(world, player, wary ? SoundEvents.field_190031_ew : SoundEvents.field_190026_er, null, MathHelper.func_151240_a((Random)world.func_201674_k(), (float)0.3f, (float)0.6f), world.func_201674_k().nextFloat() * 0.1f + 0.8f);
    }

    public static final void playAmbientGroan(World world, BlockPos at, boolean wary) {
        double x = (double)at.func_177958_n() + 0.5;
        double y = (double)at.func_177956_o() + 0.5;
        double z = (double)at.func_177952_p() + 0.5;
        world.func_184148_a((PlayerEntity)null, x, y, z, wary ? SoundEvents.field_190031_ew : SoundEvents.field_190026_er, SoundCategory.NEUTRAL, MathHelper.func_151240_a((Random)world.func_201674_k(), (float)0.3f, (float)0.6f), world.func_201674_k().nextFloat() * 0.1f + 0.8f);
    }

    public static final void playLockableUnlocked(World world, BlockPos at, boolean metal) {
        Effects.play(metal ? 1037 : 1007, world, at);
    }

    public static final void playLockableLocked(World world, BlockPos at, boolean metal) {
        Effects.play(metal ? 1036 : 1013, world, at);
    }

    public static final void playItemPickedUp(World world, PlayerEntity player, float volume) {
        Effects.playSound(world, player, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, volume < 0.0f ? 0.2f : volume, ((world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.7f + 1.0f) * 2.0f);
    }

    public static final boolean spawnWarningParticle(World world, BlockPos at, Random rand, @Nonnull IParticleData particle) {
        boolean spawned = false;
        if (rand.nextInt(20) == 0) {
            world.func_195594_a(particle, (double)((float)at.func_177958_n() + rand.nextFloat()), (double)((float)at.func_177956_o() + 1.0f), (double)((float)at.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0);
            spawned = true;
        }
        return spawned;
    }

    public static final void spawnSmallArrayOfParticles(@Nonnull World world, BlockPos at, Random rand, @Nonnull IParticleData particle) {
        if (rand == null) {
            rand = world.func_201674_k();
        }
        int n = 0;
        do {
            world.func_195594_a(particle, (double)((float)at.func_177958_n() + rand.nextFloat()), (double)((float)at.func_177956_o() + rand.nextFloat()), (double)((float)at.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0);
        } while (++n < 3);
    }

    public static final boolean spawnIntermittentParticles(World world, BlockPos at, @Nullable IParticleData particleType, Random rand) {
        boolean spawned = false;
        if (rand == null) {
            rand = world.func_201674_k();
        }
        if (rand.nextInt(20) == 0) {
            if (particleType == null) {
                particleType = ParticleTypes.field_197632_y;
            }
            Effects.spawnSmallArrayOfParticles(world, at, rand, particleType);
            spawned = true;
        }
        return spawned;
    }

    public static final void spawnLoveyDoveyParticles(World world, BlockPos at) {
        Effects.spawnSmallArrayOfParticles(world, at, world.func_201674_k(), (IParticleData)ParticleTypes.field_197633_z);
    }

    public static final void spawnPiOoedParticles(World world, BlockPos at) {
        Effects.spawnSmallArrayOfParticles(world, at, world.func_201674_k(), (IParticleData)ParticleTypes.field_197609_b);
    }

    public static final void spawnHappyParticles(@Nonnull World world, Vector3d at, Random rand, boolean pinned, boolean heavy) {
        if (rand == null) {
            rand = world.func_201674_k();
        }
        int n = 0;
        int m = heavy ? 15 : 7;
        do {
            double speedx = rand.nextGaussian() * 0.02;
            double speedy = rand.nextGaussian() * 0.02;
            double speedz = rand.nextGaussian() * 0.02;
            world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, at.func_82615_a() + (double)(pinned ? rand.nextFloat() : 0.0f), at.func_82617_b() + (double)(pinned ? rand.nextFloat() : 0.0f), at.func_82616_c() + (double)(pinned ? rand.nextFloat() : 0.0f), speedx, speedy, speedz);
        } while (++n < m);
    }

    public static final void spawnHappyParticles(@Nonnull World world, Vector3d at) {
        Effects.spawnHappyParticles(world, at, world.func_201674_k(), false, true);
    }

    public static final void spawnHappyParticles(@Nonnull World world, BlockPos at) {
        Effects.spawnHappyParticles(world, Vector3d.func_237491_b_((Vector3i)at), world.func_201674_k(), true, true);
    }

    public static final void spawnPinklyParticles(World world, BlockPos at) {
        Effects.play(SharedGlue.BONEMEAL_SPARKLE_SFX(), world, at);
    }

    public static final void spawnPinklyExplosion(World world, BlockPos at) {
        Effects.play(SharedGlue.BONEMEAL_SPARKLE_SFX(), world, at);
        Effects.play(2003, world, at);
    }

    public static final void spawnTpParticles(World world, BlockPos at, Random rand) {
        if (rand == null) {
            rand = world.func_201674_k();
        }
        for (int i = 0; i < 32; ++i) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)at.func_177958_n(), (double)at.func_177956_o() + rand.nextDouble() * 2.0, (double)at.func_177952_p(), rand.nextGaussian(), 0.0, rand.nextGaussian());
        }
    }

    public static final void playTpArrival(World world, BlockPos at) {
        Effects.play(SharedGlue.PORTAL_TRAVEL_SFX(), world, at);
    }

    public static final void spawnParticles(@Nonnull World world, double atX, double atY, double atZ, @Nullable Random rand, @Nullable IParticleData particle, int count, boolean pinned, boolean still) {
        if (particle == null) {
            particle = ParticleTypes.field_197632_y;
        }
        if (rand == null) {
            rand = world.func_201674_k();
        }
        if (count <= 0) {
            count = 20;
        }
        for (int i = 0; i < count; ++i) {
            double speedx = still ? 0.0 : rand.nextGaussian() * 0.02;
            double speedy = still ? 0.0 : rand.nextGaussian() * 0.02;
            double speedz = still ? 0.0 : rand.nextGaussian() * 0.02;
            double startx = pinned ? atX : atX + (double)(rand.nextFloat() * 2.0f) - 1.0;
            double starty = pinned ? atY : atY + (double)(rand.nextFloat() * 2.0f);
            double startz = pinned ? atZ : atZ + (double)(rand.nextFloat() * 2.0f) - 1.0;
            world.func_195594_a(particle, startx - speedx * 10.0, starty - speedy * 10.0, startz - speedz * 10.0, speedx, speedy, speedz);
        }
    }

    public static final void spawnVisualBOOM(@Nonnull World world, double atX, double atY, double atZ, @Nullable Random rand, @Nullable IParticleData particle) {
        Effects.spawnParticles(world, atX, atY, atZ, rand, particle, -1, false, false);
    }

    public static final void spawnVisualWhack(@Nonnull World world, @Nonnull Entity at, @Nullable Random rand, @Nullable IParticleData particle) {
        Effects.spawnParticles(world, at.func_226277_ct_(), at.func_226278_cu_() + 0.5, at.func_226281_cx_(), rand, particle, -1, false, false);
    }

    public static final void spawnBlockWatered(@Nonnull World world, @Nonnull BlockPos at, @Nullable Random rand) {
        Effects.spawnParticles(world, (double)at.func_177958_n() + 0.5, at.func_177956_o(), (double)at.func_177952_p() + 0.5, rand, (IParticleData)ParticleTypes.field_218425_n, 8, false, false);
    }

    public static final void spawnSmallFlamesAround(@Nonnull World world, @Nonnull Entity at, boolean flat, boolean blue) {
        BasicParticleType FLAME = blue ? ParticleTypes.field_239811_B_ : ParticleTypes.field_197631_x;
        double y = at.func_226278_cu_() + 0.5;
        if (flat) {
            world.func_195594_a((IParticleData)FLAME, at.func_226277_ct_() + 1.0, y, at.func_226281_cx_(), 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)FLAME, at.func_226277_ct_() - 1.0, y, at.func_226281_cx_(), 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)FLAME, at.func_226277_ct_(), y, at.func_226281_cx_() + 1.0, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)FLAME, at.func_226277_ct_(), y, at.func_226281_cx_() - 1.0, 0.0, 0.0, 0.0);
        } else {
            Effects.spawnParticles(world, at.func_226277_ct_() + 1.0, y, at.func_226281_cx_(), null, (IParticleData)FLAME, 1, false, true);
            Effects.spawnParticles(world, at.func_226277_ct_() - 1.0, y, at.func_226281_cx_(), null, (IParticleData)FLAME, 1, false, true);
            Effects.spawnParticles(world, at.func_226277_ct_(), y, at.func_226281_cx_() + 1.0, null, (IParticleData)FLAME, 1, false, true);
            Effects.spawnParticles(world, at.func_226277_ct_(), y, at.func_226281_cx_() - 1.0, null, (IParticleData)FLAME, 1, false, true);
        }
    }

    public static final void spawnSmallFlamesAround(@Nonnull World world, @Nonnull Entity at, boolean flat) {
        Effects.spawnSmallFlamesAround(world, at, flat, false);
    }

    public static final void spawnRainbowParticlesAround(@Nonnull World world, BlockPos pos, @Nullable Random rand) {
        if (rand == null) {
            rand = world.func_201674_k();
        }
        if (rand.nextInt(20) == 0) {
            int n = 0;
            do {
                double yd;
                double xd;
                Direction face;
                BlockPos neighborPos;
                BlockState neighborState;
                if ((neighborState = world.func_180495_p(neighborPos = pos.func_177972_a(face = Direction.func_239631_a_((Random)world.func_201674_k())))).func_200132_m()) continue;
                double d = face.func_82601_c() == 0 ? (double)rand.nextFloat() : (xd = face.func_82601_c() < 0 ? -0.05 : 1.05);
                double d2 = face.func_96559_d() == 0 ? (double)rand.nextFloat() : (yd = face.func_96559_d() < 0 ? -0.05 : 1.05);
                double zd = face.func_82599_e() == 0 ? (double)rand.nextFloat() : (face.func_82599_e() < 0 ? -0.05 : 1.05);
                double x = (double)pos.func_177958_n() + xd;
                double y = (double)pos.func_177956_o() + yd;
                double z = (double)pos.func_177952_p() + zd;
                int rgb = RAINBOW[rand.nextInt(RAINBOW.length)];
                world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, x, y, z, (double)(rgb >> 16 & 0xFF) / 255.0, (double)(rgb >> 8 & 0xFF) / 255.0, (double)(rgb & 0xFF) / 255.0);
            } while (++n < 3);
        }
    }

    public static final void dropMotionless(World world, float x, float y, float z, ItemStack stack, boolean farm, @Nullable Random rand) {
        float dz;
        float dx = rand != null ? rand.nextFloat() * 0.4f + 0.1f : 0.0f;
        float dy = rand != null ? rand.nextFloat() * 0.4f + 0.1f : 0.0f;
        float f = dz = rand != null ? rand.nextFloat() * 0.4f + 0.1f : 0.0f;
        while (!stack.func_190926_b()) {
            ItemEntity drop = new ItemEntity(world, (double)(x + dx), (double)(y + dy), (double)(z + dz), stack.func_77979_a(rand.nextInt(21) + 10));
            if (farm && drop.lifespan == SharedGlue.DEFAULT_DROPPED_ITEM_LIFESPAN_TICKS()) {
                drop.lifespan = LibConfig.farmedDropsLifespanTicks();
            }
            SharedGlue.spawnEntityInto(world, (Entity)drop);
        }
    }

    public static final void dropWithMotion(World world, float x, float y, float z, ItemStack stack, @Nonnull Random rand) {
        double mx = (double)rand.nextFloat() * 0.5 + 0.25;
        double my = (double)rand.nextFloat() * 0.5 + 0.25;
        double mz = (double)rand.nextFloat() * 0.5 + 0.25;
        ItemEntity drop = new ItemEntity(world, (double)x + mx, (double)y + my, (double)z + mz, stack);
        drop.func_174869_p();
        SharedGlue.spawnEntityInto(world, (Entity)drop);
    }

    public static final void dropWithMotion(World world, BlockPos at, ItemStack stack, @Nonnull Random rand) {
        Effects.dropWithMotion(world, at.func_177958_n(), at.func_177956_o(), at.func_177952_p(), stack, rand);
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.func_77969_a(newStack) || oldStack.func_77942_o() && newStack.func_77942_o() && !oldStack.func_77978_p().equals((Object)newStack.func_77978_p());
    }

    private Effects() {
    }
}

