/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jwaresoftware.mcmods.lib.ItemStackSnapshot;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;

public final class ItemStackArray {
    @Nonnull
    public static final ItemStack[] create(int slotCount) {
        ItemStack nullstack = ItemStacks.NULLSTACK();
        ItemStack[] inventoryImpl = new ItemStack[slotCount];
        for (int i = 0; i < inventoryImpl.length; ++i) {
            inventoryImpl[i] = nullstack;
        }
        return inventoryImpl;
    }

    public static final int count(@Nonnull ItemStack[] inventoryImpl) {
        int n = 0;
        for (int i = 0; i < inventoryImpl.length; ++i) {
            if (ItemStacks.isEmpty(inventoryImpl[i]) || !SharedGlue.isDefined(inventoryImpl[i].func_77973_b())) continue;
            ++n;
        }
        return n;
    }

    public static final void clear(@Nonnull ItemStack[] inventoryImpl) {
        ItemStack nullstack = ItemStacks.NULLSTACK();
        for (int i = 0; i < inventoryImpl.length; ++i) {
            inventoryImpl[i] = nullstack;
        }
    }

    @Nonnull
    public static final ItemStack[] readOrderedFrom(@Nonnull CompoundNBT compound, @Nonnull String storageId, int size) {
        ItemStack[] inventoryImpl = ItemStackArray.create(size);
        if (compound.func_74764_b(storageId)) {
            ListNBT slotsNbt = compound.func_150295_c(storageId, 10);
            for (int i = 0; i < slotsNbt.size(); ++i) {
                CompoundNBT slotNbt = slotsNbt.func_150305_b(i);
                byte slot_index = slotNbt.func_74771_c("Slot");
                if (slot_index < 0 || slot_index >= inventoryImpl.length) continue;
                inventoryImpl[slot_index] = ItemStack.func_199557_a((CompoundNBT)slotNbt);
            }
        }
        return inventoryImpl;
    }

    public static final void writeOrderedTo(@Nonnull ItemStack[] inventoryImpl, @Nonnull CompoundNBT compound, @Nonnull String storageId, String countId) {
        ListNBT slotsNbt = new ListNBT();
        for (int i = 0; i < inventoryImpl.length; ++i) {
            if (ItemStacks.isEmpty(inventoryImpl[i])) continue;
            CompoundNBT slotNbt = new CompoundNBT();
            slotNbt.func_74774_a("Slot", (byte)i);
            inventoryImpl[i].func_77955_b(slotNbt);
            slotsNbt.add((Object)slotNbt);
        }
        compound.func_218657_a(storageId, (INBT)slotsNbt);
        if (countId != null) {
            compound.func_74774_a(countId, (byte)slotsNbt.size());
        }
    }

    @Nonnull
    public static final List<ItemStack> readFrom(@Nonnull CompoundNBT compound, @Nonnull String storageId) {
        ListNBT slotsNbt = compound.func_150295_c(storageId, 10);
        ArrayList<ItemStack> out = new ArrayList<ItemStack>(31);
        for (int i = 0; i < slotsNbt.size(); ++i) {
            CompoundNBT slotNbt = slotsNbt.func_150305_b(i);
            ItemStack slotstack = ItemStack.func_199557_a((CompoundNBT)slotNbt);
            if (ItemStacks.isEmpty(slotstack)) continue;
            out.add(slotstack);
        }
        return out;
    }

    public static final void addContentsInformation(@Nonnull ItemStackHandler contents, Predicate<ItemStack> show, @Nonnull List<ITextComponent> tooltip, boolean advanced, String more) {
        int i = 0;
        if (more == null) {
            more = "tooltip.itemsuffix.more.contents";
        }
        if (show == null) {
            show = stack -> true;
        }
        int N = contents.getSlots();
        for (int slotindex = 0; slotindex < N; ++slotindex) {
            ItemStack item = contents.getStackInSlot(slotindex);
            if (item.func_190926_b() || !show.test(item)) continue;
            String displayString = "\u00a77> " + Strings.boundedUiTipString(item, 2) + "\u00a7r";
            tooltip.add((ITextComponent)new StringTextComponent(displayString));
            if (advanced || ++i != 10 || N <= 10) continue;
            int more_num = N - 10;
            tooltip.add((ITextComponent)new TranslationTextComponent(more, new Object[]{more_num}));
            break;
        }
    }

    private static boolean can_represent_strictly(ItemStack existing, ItemStack with) {
        if (existing.func_190926_b()) {
            return true;
        }
        return with.func_190926_b() ? false : (existing.func_77973_b() != with.func_77973_b() ? false : ItemStack.func_77970_a((ItemStack)existing, (ItemStack)with));
    }

    public static final boolean mergeInternal(IItemHandlerModifiable into, @Nonnull ItemStack stack, int[] slots, boolean lossy_allowed) {
        int slot_max;
        ItemStack slot_stack;
        int iindex;
        int ii;
        boolean processed_something = false;
        ArrayList<ItemStackSnapshot> slot_snapshots = lossy_allowed ? null : new ArrayList<ItemStackSnapshot>();
        int stack_maxsize = stack.func_77976_d();
        if (stack.func_77985_e()) {
            for (ii = 0; stack.func_190916_E() > 0 && ii < slots.length; ++ii) {
                iindex = slots[ii];
                slot_stack = into.getStackInSlot(iindex);
                if (slot_stack.func_190926_b() || !ItemStackArray.can_represent_strictly(stack, slot_stack)) continue;
                slot_max = Math.min(stack_maxsize, into.getSlotLimit(iindex));
                int n = slot_stack.func_190916_E() + stack.func_190916_E();
                if (n <= slot_max) {
                    if (!lossy_allowed) {
                        slot_snapshots.add(new ItemStackSnapshot(slot_stack, iindex));
                    }
                    stack.func_190920_e(0);
                    slot_stack.func_190920_e(n);
                    processed_something = true;
                    continue;
                }
                if (slot_stack.func_190916_E() >= slot_max) continue;
                if (!lossy_allowed) {
                    slot_snapshots.add(new ItemStackSnapshot(slot_stack, iindex));
                }
                stack.func_190918_g(slot_max - slot_stack.func_190916_E());
                slot_stack.func_190920_e(slot_max);
                processed_something = true;
            }
        }
        if (!stack.func_190926_b()) {
            for (ii = 0; ii < slots.length; ++ii) {
                iindex = slots[ii];
                slot_stack = into.getStackInSlot(iindex);
                if (!slot_stack.func_190926_b()) continue;
                slot_max = Math.min(stack_maxsize, into.getSlotLimit(iindex));
                ItemStack copy = stack.func_77946_l();
                if (copy.func_190916_E() > slot_max) {
                    copy.func_190920_e(slot_max);
                    stack.func_190918_g(slot_max);
                } else {
                    stack.func_190920_e(0);
                }
                if (!lossy_allowed) {
                    slot_snapshots.add(new ItemStackSnapshot(slot_stack, iindex));
                }
                into.setStackInSlot(iindex, copy);
                processed_something = true;
                break;
            }
        }
        if (processed_something && !lossy_allowed && !stack.func_190926_b()) {
            for (ItemStackSnapshot snapshot : slot_snapshots) {
                into.setStackInSlot(snapshot.iindex, snapshot.savedstack);
                snapshot.savedstack = null;
            }
            processed_something = false;
        }
        return processed_something;
    }
}

