/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;

public final class ItemStackDef {
    @Nullable
    public Item item = Items.field_190931_a;
    public int count = 1;
    private String _item_resource = null;
    private Function<Integer, ItemStack> _item_fetch = null;
    public static final ItemStackDef EMPTY = new ItemStackDef();
    public static final ItemStackDef UNUSED = new ItemStackDef(Items.field_151124_az, 123);

    public ItemStackDef() {
    }

    public ItemStackDef(Item obj, int num) {
        this.item = obj;
        this.count = num;
    }

    public ItemStackDef(Item obj) {
        this.item = obj;
    }

    public ItemStackDef(Block obj, int num) {
        this(obj.func_199767_j(), num);
    }

    public ItemStackDef(Block obj) {
        this(obj.func_199767_j());
    }

    public ItemStackDef(@Nonnull ItemStack obj) {
        this(obj.func_77973_b(), obj.func_190916_E());
    }

    public ItemStackDef(String rid, int num) {
        Validate.notBlank((CharSequence)rid, (String)"A non-blank item resource name is required", (Object[])new Object[0]);
        this._item_resource = rid;
        this.item = null;
        this.count = num;
    }

    public ItemStackDef(String rid) {
        this(rid, 1);
    }

    private ItemStackDef(Item obj, int num, String rid, Function<Integer, ItemStack> callback) {
        this(obj, num);
        this._item_resource = rid;
        this._item_fetch = callback;
    }

    public ItemStackDef(Function<Integer, ItemStack> callback) {
        this(null, 1, null, callback);
    }

    public ItemStackDef(Function<Integer, ItemStack> callback, int num) {
        this(null, num, null, callback);
    }

    public ItemStackDef(Supplier<Item> callback) {
        this((Integer n) -> ItemStacks.create((Item)callback.get(), (int)n));
    }

    public ItemStackDef(@Nonnull CompoundNBT instructions) {
        this.count = instructions.func_74762_e("count");
        if (instructions.func_150297_b("item", 8)) {
            this._item_resource = StringUtils.trimToNull((String)instructions.func_74779_i("item"));
            this.item = null;
        } else if (instructions.func_150297_b("item", 10)) {
            this._item_fetch = n -> {
                ItemStack stk = ItemStack.func_199557_a((CompoundNBT)instructions.func_74775_l("item"));
                if (!stk.func_190926_b()) {
                    stk.func_190920_e(n.intValue());
                }
                return stk;
            };
            this.item = null;
        }
    }

    public final Item getItem() {
        return this.item;
    }

    public final int getCount() {
        return this.count;
    }

    public final String getHolderRef() {
        return this._item_resource;
    }

    @Nonnull
    public final ItemStackDef copy() {
        return new ItemStackDef(this.item, this.count, this._item_resource, this._item_fetch);
    }

    @Nonnull
    public final ItemStack get() {
        return this == EMPTY ? ItemStack.field_190927_a : (this.item != null ? ItemStacks.create(this.item, this.count) : (this._item_fetch != null ? this._item_fetch.apply(this.count) : (this._item_resource != null ? this.getnamed() : ItemStack.field_190927_a)));
    }

    @Nonnull
    public final ItemStack safeget() {
        try {
            return this.get();
        }
        catch (RuntimeException unregistered) {
            return ItemStack.field_190927_a;
        }
    }

    @Nonnull
    private final ItemStack getnamed() {
        Item registered;
        ResourceLocation rid = ResourceLocation.func_208304_a((String)this._item_resource);
        Item item = registered = rid != null && ForgeRegistries.ITEMS.containsKey(rid) ? (Item)ForgeRegistries.ITEMS.getValue(rid) : null;
        if (registered != null) {
            this.item = registered;
            if (registered != Items.field_190931_a) {
                return ItemStacks.create(this.item, this.count);
            }
        }
        return ItemStack.field_190927_a;
    }

    public final boolean isEmpty() {
        return this == EMPTY || this.count <= 0 || this.item == null && this._item_resource == null && this._item_fetch == null || this.item == Items.field_190931_a;
    }

    public static final boolean isEmpty(ItemStackDef o) {
        return o == null || o.isEmpty();
    }

    public final boolean isSingle() {
        return this.count == 1 && !this.isEmpty();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "*EMPTY*";
        }
        String itemstring = ClassUtils.getShortCanonicalName((Object)this.item, (String)"null");
        if (this.item == null && this._item_resource != null) {
            itemstring = this._item_resource;
        }
        return "{[#]" + this.count + ",[o]" + itemstring + "}";
    }

    @Nonnull
    public static final ItemStack convert(@Nullable Object o) {
        if (o == null) {
            return ItemStack.field_190927_a;
        }
        if (o instanceof ItemStack) {
            return (ItemStack)o;
        }
        assert (o instanceof ItemStackDef);
        return ((ItemStackDef)o).safeget();
    }

    public static final ItemStackDef copy(@Nullable ItemStackDef from) {
        if (from == null || from.isEmpty()) {
            return EMPTY;
        }
        return from.copy();
    }
}

