/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.potion.Potion;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.CarrotsLib;
import org.jwaresoftware.mcmods.lib.LibFMLMessage;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.mod.IModConfig;
import org.jwaresoftware.mcmods.lib.impl.Count;

public final class LibConfig
implements IModConfig {
    private static LibConfig _sharedINSTANCE = new LibConfig();
    private boolean _INITIALIZED = false;
    private final List<Enchantment> _OMITTED_FROM_RANDOM_ENCHANTS = new ArrayList<Enchantment>();
    private final List<Potion> _OMITTED_FROM_RANDOM_POTIONS = new ArrayList<Potion>();
    private boolean _UPDATE_ADVANCEMENT_TRIGGERS;
    private boolean _UPDATE_SCORE_BASED_TRIGGERS;
    private int _UPDATE_TRIGGERS_FREQUENCY_TICKS = -1;
    private boolean _ENABLE_UNCURABLE_EFFECTS = false;
    private final HashMap<String, List<String>> _PROPERTY_SYNONYMS = new HashMap(23);
    private List<String> _AGE_PROPERTY_SYNONYMS = (List)Util.func_200696_a(new ArrayList(5), a -> {
        a.add(BlockStateProperties.field_222512_Y.func_177701_a());
        a.add(BlockStateProperties.field_208137_al.func_177701_a());
        a.add("growstate");
    });
    private List<String> _WET_PROPERTY_SYNONYMS = (List)Util.func_200696_a(new ArrayList(5), w -> {
        w.add(BlockStateProperties.field_208133_ah.func_177701_a());
        w.add("wet");
        w.add("wetness");
    });
    private int _SPECIAL_DROPS_LIFESPAN_TICKS = SharedGlue.ticksFromSeconds(450);
    private int _FARMED_DROPS_LIFESPAN_TICKS = SharedGlue.ticksFromSeconds(120);
    private boolean _INCLUDE_NUTRITION_NOTES = false;

    @Nonnull
    public LibConfig setInstance() {
        _sharedINSTANCE = this;
        return this;
    }

    @Nonnull
    public static final LibConfig getInstance() {
        return _sharedINSTANCE;
    }

    public void initEarly() {
        this._INITIALIZED = true;
    }

    @Override
    public boolean isLoaded() {
        return this._INITIALIZED;
    }

    @Override
    public boolean isPresent(@Nonnull String feature) {
        return false;
    }

    @Override
    public boolean isAllowed(@Nonnull String option, boolean defaultValue) {
        return defaultValue;
    }

    public void initFinalize() {
        ArrayList<Potion> omitted_potions = new ArrayList<Potion>();
        ArrayList<Enchantment> omitted_enchants = new ArrayList<Enchantment>();
        Count autotickDelaySeconds = new Count(60);
        ArrayList<String> age_names = new ArrayList<String>();
        ArrayList<String> wet_names = new ArrayList<String>();
        InterModComms.getMessages((String)"carrots").forEach(msg -> {
            LibFMLMessage msgid = LibFMLMessage.findOrNone(msg.getMethod());
            switch (msgid) {
                case ENABLE_UNCURABLE_EFFECTS: {
                    this._ENABLE_UNCURABLE_EFFECTS = true;
                    break;
                }
                case TICK_SCORE_ADVANCEMENTS: {
                    int i;
                    this._UPDATE_SCORE_BASED_TRIGGERS = true;
                    this._UPDATE_ADVANCEMENT_TRIGGERS = true;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (!(unsafe instanceof Number) || (i = ((Number)unsafe).intValue()) <= 1 || i >= autotickDelaySeconds.value()) break;
                    autotickDelaySeconds.setValue(i);
                    break;
                }
                case TICK_ADVANCEMENTS: {
                    this._UPDATE_ADVANCEMENT_TRIGGERS = true;
                    break;
                }
                case OMIT_FROM_RANDOM_POTIONS: {
                    boolean yup = false;
                    ResourceLocation rid = null;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof String) {
                        rid = ResourceLocation.func_208304_a((String)unsafe.toString());
                    } else if (unsafe instanceof ResourceLocation) {
                        rid = (ResourceLocation)unsafe;
                    } else if (unsafe instanceof Potion) {
                        rid = ((Potion)unsafe).getRegistryName();
                    }
                    if (rid != null) {
                        Potion p = null;
                        if (ForgeRegistries.POTION_TYPES.containsKey(rid)) {
                            p = (Potion)ForgeRegistries.POTION_TYPES.getValue(rid);
                        }
                        if (!Potions.isEmpty(p)) {
                            omitted_potions.add(p);
                            yup = true;
                        }
                    }
                    if (yup) break;
                    CarrotsLib.instance.getLog().warn("Unable to process omit potion FML request from '{}' for '{}'. Unrecognized potion identifier. Understands strings, resource locations, and object references for REGISTERED potions only.", (Object)msg.getSenderModId(), (Object)rid);
                    break;
                }
                case OMIT_FROM_RANDOM_ENCHANTS: {
                    boolean yup = false;
                    ResourceLocation rid = null;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof String) {
                        rid = ResourceLocation.func_208304_a((String)unsafe.toString());
                    } else if (unsafe instanceof ResourceLocation) {
                        rid = (ResourceLocation)unsafe;
                    } else if (unsafe instanceof Enchantment) {
                        rid = ((Enchantment)unsafe).getRegistryName();
                    }
                    if (rid != null) {
                        Enchantment e = null;
                        if (ForgeRegistries.ENCHANTMENTS.containsKey(rid)) {
                            e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rid);
                        }
                        if (e != null) {
                            omitted_enchants.add(e);
                            yup = true;
                        }
                    }
                    if (yup) break;
                    CarrotsLib.instance.getLog().warn("Unable to process omit enchantment FML request from '{}' for '{}'. Unrecognized enchantment identifier. Understands strings, resource locations, and object references for REGISTERED enchantments only.", (Object)msg.getSenderModId(), (Object)rid);
                    break;
                }
                case FARMED_DROPS_LIFESPAN_TICKS: 
                case SPECIAL_DROPS_LIFESPAN_TICKS: {
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof Number) {
                        int ticks = ((Number)unsafe).intValue();
                        if (ticks <= 0) break;
                        if (msgid == LibFMLMessage.SPECIAL_DROPS_LIFESPAN_TICKS && ticks > this._SPECIAL_DROPS_LIFESPAN_TICKS) {
                            this._SPECIAL_DROPS_LIFESPAN_TICKS = Math.min(ticks, SharedGlue.ticksFromSeconds(1800));
                            break;
                        }
                        if (msgid != LibFMLMessage.FARMED_DROPS_LIFESPAN_TICKS || ticks >= this._FARMED_DROPS_LIFESPAN_TICKS) break;
                        this._FARMED_DROPS_LIFESPAN_TICKS = ticks;
                        break;
                    }
                    CarrotsLib.instance.getLog().warn("Unable to process dropped items lifespan FML request from '{}'. Value is not a number.", (Object)msg.getSenderModId());
                    break;
                }
                case ADD_MOISTURE_SYNONYM: 
                case ADD_AGE_SYNONYM: {
                    String name = null;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof String) {
                        name = unsafe.toString();
                    } else if (unsafe instanceof IntegerProperty) {
                        name = ((IntegerProperty)unsafe).func_177701_a();
                    } else {
                        CarrotsLib.instance.getLog().warn("Unable to process add property synonym FML request from '{}'. Understands strings and IntegerProperty.", (Object)msg.getSenderModId());
                    }
                    if (name == null) break;
                    if (msgid == LibFMLMessage.ADD_MOISTURE_SYNONYM) {
                        age_names.add(name);
                        break;
                    }
                    wet_names.add(name);
                    break;
                }
                case ENABLE_NUTRITION_NOTES: {
                    break;
                }
            }
        });
        this.finalizePropertySynonyms(age_names, wet_names);
        this.finalizeBlockedEnchantments(omitted_enchants);
        this.finalizeBlockedPotions(omitted_potions);
        if (this._UPDATE_SCORE_BASED_TRIGGERS) {
            this._UPDATE_TRIGGERS_FREQUENCY_TICKS = SharedGlue.ticksFromSeconds(autotickDelaySeconds.intValue());
        }
    }

    private void finalizeBlockedEnchantments(Collection<Enchantment> denylist) {
        if (!denylist.isEmpty()) {
            this._OMITTED_FROM_RANDOM_ENCHANTS.clear();
            this._OMITTED_FROM_RANDOM_ENCHANTS.addAll(denylist);
        }
    }

    public static final boolean omitFromRandomGeneration_s(@Nullable Enchantment e) {
        return LibConfig.getInstance()._OMITTED_FROM_RANDOM_ENCHANTS.contains(e);
    }

    public static final boolean omitFromRandomGeneration(@Nullable Enchantment e) {
        return e == null || e.getRegistryName() == null || LibConfig.omitFromRandomGeneration_s(e);
    }

    private void finalizeBlockedPotions(Collection<Potion> denylist) {
        if (!denylist.isEmpty()) {
            this._OMITTED_FROM_RANDOM_POTIONS.clear();
            this._OMITTED_FROM_RANDOM_POTIONS.addAll(denylist);
        }
    }

    public static final boolean omitFromRandomGeneration_s(@Nullable Potion p) {
        return p == Potions.PLACEHOLDER || LibConfig.getInstance()._OMITTED_FROM_RANDOM_POTIONS.contains(p);
    }

    public static final boolean omitFromRandomGeneration(@Nullable Potion p) {
        return p == null || p.getRegistryName() == null || LibConfig.omitFromRandomGeneration_s(p);
    }

    public static final boolean installAdvancementAutoTriggers() {
        return LibConfig.getInstance()._UPDATE_ADVANCEMENT_TRIGGERS || LibConfig.getInstance()._UPDATE_SCORE_BASED_TRIGGERS;
    }

    public static final boolean tickAdvancementTriggers() {
        return LibConfig.getInstance()._UPDATE_ADVANCEMENT_TRIGGERS;
    }

    public static final int tickScoreTriggersFrequency() {
        return LibConfig.getInstance()._UPDATE_TRIGGERS_FREQUENCY_TICKS;
    }

    public static final boolean allowUncurablePotionEffects() {
        return LibConfig.getInstance()._ENABLE_UNCURABLE_EFFECTS;
    }

    public static final int ticksPerFullDay(DimensionType dim) {
        return LibConfig.ticksPerFullDay();
    }

    public static final int ticksPerFullDay() {
        return SharedGlue.DEFAULT_TICKS_PER_FULL_DAYNIGHT_CYCLE();
    }

    public static final int ticksPerDaytime(DimensionType dim) {
        return LibConfig.ticksPerDaytime();
    }

    public static final int ticksPerDaytime() {
        return SharedGlue.DEFAULT_TICKS_PER_DAYTIME_CYCLE();
    }

    private void finalizePropertySynonyms(Collection<String> agelist, Collection<String> wetlist) {
        for (String age_p : agelist) {
            if (age_p.isEmpty()) continue;
            this._AGE_PROPERTY_SYNONYMS.add(age_p);
        }
        this._AGE_PROPERTY_SYNONYMS = Collections.unmodifiableList(this._AGE_PROPERTY_SYNONYMS);
        for (String id : this._AGE_PROPERTY_SYNONYMS) {
            this._PROPERTY_SYNONYMS.putIfAbsent(id, this._AGE_PROPERTY_SYNONYMS);
        }
        for (String wet_p : wetlist) {
            if (wet_p.isEmpty()) continue;
            this._WET_PROPERTY_SYNONYMS.add(wet_p);
        }
        this._WET_PROPERTY_SYNONYMS = Collections.unmodifiableList(this._WET_PROPERTY_SYNONYMS);
        for (String id : this._WET_PROPERTY_SYNONYMS) {
            this._PROPERTY_SYNONYMS.putIfAbsent(id, this._WET_PROPERTY_SYNONYMS);
        }
    }

    @Nonnull
    public static final List<String> propertySynonyms(@Nonnull String id) {
        return LibConfig.getInstance()._PROPERTY_SYNONYMS.getOrDefault(id, Collections.emptyList());
    }

    public static final List<String> agePropertyNames() {
        return LibConfig.getInstance()._AGE_PROPERTY_SYNONYMS;
    }

    public static final List<String> wetPropertyNames() {
        return LibConfig.getInstance()._WET_PROPERTY_SYNONYMS;
    }

    public static final int specialDropsLifespanTicks() {
        return LibConfig.getInstance()._SPECIAL_DROPS_LIFESPAN_TICKS;
    }

    public static final int farmedDropsLifespanTicks() {
        return LibConfig.getInstance()._FARMED_DROPS_LIFESPAN_TICKS;
    }

    public static final boolean includeNutritionNotes() {
        return LibConfig.getInstance()._INCLUDE_NUTRITION_NOTES;
    }
}

