/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Locale;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.api.IDrink;

public class LiquidType
implements IDrink,
IStringSerializable {
    private static final Vector<LiquidType> _INSTANCES = new Vector(57);
    public static final LiquidType WATER = new LiquidType(1, "water", 6, 0.8f, true, "any_water", "water");
    public static final LiquidType POTABLE_WATER = new LiquidType(1, "clean_water", 12, 1.0f, true, "potable_water", "purified_water", "rain_water", "dist_water", "distilled_water");
    public static final LiquidType UNTREATED_WATER = new LiquidType(1, "dirty_water", 6, 0.5f, true, "untreated_water", "foul_water");
    public static final LiquidType JUICE = new LiquidType(1, "juice", 8, 0.6f, true, "juice", "fruit_juice");
    public static final LiquidType POWER = new LiquidType(1, "power", 12, 1.0f, false, "birch_sap");
    public static final LiquidType TEA = new LiquidType(1, "tea", 8, 0.7f, true, "tea");
    public static final LiquidType MILK = new LiquidType(1, "milk", 4, 0.3f, true, "any_milk", "milk", "muscle_milk");
    public static final LiquidType ANIMALMILK = new LiquidType(1, "animalmilk", 4, 0.3f, true, "animal_milk", "cow_milk", "sheep_milk", "goat_milk", "squid_milk", "llama_milk");
    public static final LiquidType PLANTMILK = new LiquidType(1, "plantmilk", 4, 0.3f, true, "plant_milk", "oatmilk", "oat_milk", "soymilk", "soy_milk", "almond_milk", "coconut_milk", "acorn_milk", "kelp_milk", "nut_milk", "wheat_milk");
    public static final LiquidType FIZZY = new LiquidType(1, "fizzy", 5, 0.4f, true, "soda", "pop");
    public static final LiquidType ICE = new LiquidType(1, "ice", 5, 0.7f, false, "cold_water", "ice_water");
    public static final LiquidType BROTH = new LiquidType(1, "broth", 4, 0.3f, false, "broth", "stock");
    public static final LiquidType SOUP = new LiquidType(1, "soup", 3, 0.2f, true, "soup", "gruel");
    public static final LiquidType STEW = new LiquidType(1, "stew", 2, 0.2f, true, "stew", "mooshroo_stew", "mushroom_stew");
    public static final LiquidType POTION = new LiquidType(1, "potion", POWER, true, "potion", "tonic", "elixir");
    public static final LiquidType CURATIVE = new LiquidType(1, "curative", 2, 0.1f, false, "aloe", "nectar", "liquid_sunlight");
    public static final LiquidType CREAM = new LiquidType(1, "cream", 2, 0.2f, true, "any_cream", "cream", "heavy_cream", "heavycream");
    public static final LiquidType DAIRY_CREAM = new LiquidType(1, "dairy_cream", 2, 0.2f, true, "dairy_cream", "dairycream", "heavy_dairycream");
    public static final LiquidType VEGAN_CREAM = new LiquidType(1, "vegan_cream", 2, 0.2f, true, "vegan_cream", "nondairy_cream");
    public static final LiquidType HONEY = new LiquidType(1, "honey", 1, 0.05f, true, "honey", "honeymilk");
    public static final LiquidType ALCOHOL = new LiquidType(1, "alcohol", 2, 0.1f, true, "alcohol", "spirits", "beer", "liquor", "wine", "booze", "rum", "mead", "hard_cider", "vodka");
    public static final LiquidType XP = new LiquidType(1, "xpjuice", POTION, true, "experience", "xpjuice", "liquid_xp");
    public static final LiquidType MANA = new LiquidType(1, "mana", POTION, true, "mana", "chaos", "liquid_chaos");
    public static final LiquidType SLIGHT = new LiquidType("slight", 2, 0.1f);
    public static final LiquidType GENERIC = new LiquidType(0, "generic", SLIGHT, false, new String[0]);
    public static final LiquidType TRACE = new LiquidType("trace", 1, 0.05f);
    public static final LiquidType MEATMILK = new LiquidType(1, "meatmilk", SLIGHT, false, "meat", "meatmilk", "liquid_meat");
    public static final LiquidType MILK_MARBLE = new LiquidType(0, "milk_drop", SLIGHT, false, new String[0]);
    public static final LiquidType WATER_MARBLE = new LiquidType(0, "water_drop", 2, 0.25f, false, new String[0]);
    public static final LiquidType NONE = new LiquidType(1, "none", 0, 0.0f, false, new String[0]);
    private final String _name;
    private final String _i18n;
    protected final float _thirst;
    protected final float _hydration;
    @Nullable
    protected final String[] _fluids;
    @Nullable
    protected final String _fluid_tag;

    public LiquidType(String name, int thirst, float hydration, boolean tag, String ... fluids) {
        this(0, name, thirst, hydration, tag, fluids);
    }

    protected LiquidType(int x, String name, int thirst, float hydration, boolean tag, String ... fluids) {
        this._name = name.toLowerCase(Locale.ROOT);
        this._i18n = LibInfo.lstring("liquidtype." + this._name);
        this._thirst = thirst;
        this._hydration = hydration;
        this._fluids = fluids != null && fluids.length > 0 ? fluids : null;
        this._fluid_tag = tag && this._fluids != null ? fluids[0] : null;
        if (x > 0) {
            _INSTANCES.add(this);
        }
    }

    public LiquidType(String name, LiquidType like, boolean t, String ... fluids) {
        this(0, name, like, t, fluids);
    }

    protected LiquidType(int x, String name, LiquidType like, boolean t, String ... fluids) {
        this._name = name.toLowerCase(Locale.ROOT);
        this._i18n = LibInfo.lstring("liquidtype." + this._name);
        this._thirst = like._thirst;
        this._hydration = like._hydration;
        this._fluids = fluids != null && fluids.length > 0 ? fluids : null;
        this._fluid_tag = t && this._fluids != null ? fluids[0] : null;
        if (x > 0) {
            _INSTANCES.add(this);
        }
    }

    private LiquidType(String name, int thirst, float hydration) {
        this(1, name, thirst, hydration, false, new String[0]);
    }

    public final boolean isPredefined() {
        return _INSTANCES.contains(this);
    }

    public final boolean isWaterLikeForCooling() {
        return this == ICE || this == WATER || this == POTABLE_WATER || this == UNTREATED_WATER;
    }

    public final boolean isMilkLikeForHealing() {
        return this == MILK || this == ANIMALMILK || this == PLANTMILK || this == CREAM || this == DAIRY_CREAM || this == VEGAN_CREAM;
    }

    @Nonnull
    public final String func_176610_l() {
        return this._name;
    }

    public final IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public final String getTranslationKey() {
        return this._i18n;
    }

    @Override
    public float getHydrationAdded(ItemStack rep) {
        return this._hydration;
    }

    @Override
    public float getThirstQuenched(ItemStack rep) {
        return this._thirst;
    }

    public boolean matches(@Nonnull Fluid fluid) {
        if (this._fluid_tag != null && RID.isIn(fluid, this._fluid_tag)) {
            return true;
        }
        String fluidname = Fluids.name(fluid);
        return this.matches(fluidname);
    }

    public final boolean matches(@Nonnull String fluidname) {
        if (this.func_176610_l().matches(fluidname)) {
            return true;
        }
        if (this._fluid_tag != null && this._fluid_tag.equals(fluidname)) {
            return true;
        }
        if (this._fluids != null) {
            for (String id : this._fluids) {
                if (!id.equals(fluidname)) continue;
                return true;
            }
        }
        return false;
    }

    public static final LiquidType water(boolean treated) {
        return treated ? POTABLE_WATER : WATER;
    }

    @Nullable
    public static final LiquidType find(@Nonnull Fluid fluid) {
        for (LiquidType lqT : _INSTANCES) {
            if (!lqT.matches(fluid)) continue;
            return lqT;
        }
        return null;
    }
}

