/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public class Materials {
    public static final Material general = new Material.Builder(SharedGlue.MapColor_DIRT).func_200506_i();
    public static final Material milk = new BetterBuilder(SharedGlue.Material_water, SharedGlue.MapColor_SNOW).func_200506_i();
    public static final Material potable_water = new BetterBuilder(SharedGlue.Material_water, SharedGlue.MapColor_LIGHTBLUE).func_200506_i();
    public static final Material sticky_goo = new BetterBuilder(SharedGlue.Material_water, SharedGlue.MapColor_YELLOW).func_200506_i();
    public static final Material liquid_slime = new BetterBuilder(SharedGlue.MapColor_LIME).func_200506_i();
    public static final Material liquid_xp = new BetterBuilder(SharedGlue.MapColor_LIME).func_200506_i();
    public static final Material manure = new BetterBuilder(SharedGlue.MapColor_BROWN).pushDestroys().func_200506_i();
    public static final Material fertilizer_water = new BetterBuilder(SharedGlue.Material_water, SharedGlue.MapColor_YELLOW).func_200506_i();
    public static final Material dirty_dirt = new Material.Builder(SharedGlue.MapColor_DIRT).func_200506_i();
    public static final Material sludge = new BetterBuilder(SharedGlue.MapColor_BROWN).pushDestroys().func_200506_i();
    public static final Material dungcake = new BetterBuilder(SharedGlue.MapColor_YELLOW).pushDestroys().flammable().func_200506_i();
    public static final Material bio_residue = new BetterBuilder(SharedGlue.MapColor_GREEN).pushDestroys().func_200506_i();
    public static final Material dried_leaves = new BetterBuilder(SharedGlue.MapColor_WOOD).pushDestroys().flammable().func_200506_i();
    public static final Material rotten_plants = new BetterBuilder(SharedGlue.MapColor_NONE).pushDestroys().flammable().func_200509_f().func_200506_i();
    public static final Material gel = new BetterBuilder(SharedGlue.MapColor_NONE).func_200506_i();
    public static final Material squid_ink = new BetterBuilder(SharedGlue.Material_water, SharedGlue.MapColor_BLACK).func_200506_i();
    public static final Material tough_wood = new BetterBuilder(SharedGlue.MapColor_WOOD).requiresTool().func_200506_i();
    public static final Material tough_leaves = new BetterBuilder(SharedGlue.MapColor_LEAVES).pushDestroys().notOpaque().func_200506_i();
    public static final Material blessed_dirt = new BetterBuilder(SharedGlue.MapColor_LIME).requiresTool().func_200506_i();
    public static final Material cursed_dirt = new BetterBuilder(SharedGlue.MapColor_PURPLE).requiresTool().func_200506_i();
    public static final Material pinkly_water = new BetterBuilder(SharedGlue.Material_water, SharedGlue.MapColor_PINK).func_200506_i();
    public static final Material hell_rock = new BetterBuilder(SharedGlue.Material_rock, SharedGlue.MapColor_NETHERRACK).func_200506_i();
    public static final Material gauge_pole = new BetterBuilder(tough_wood, SharedGlue.MapColor_SAND).pushBlocks().func_200506_i();
    public static final Material fuller_clay = new Material.Builder(SharedGlue.MapColor_CLAY).func_200506_i();
    public static final Set<Material> EFFECTIVE_MATERIALS_CIRCUITS = Sets.newHashSet((Object[])new Material[]{Material.field_151592_s, Material.field_151594_q, Material.field_76233_E, Material.field_151591_t});
    public static final Set<Material> EFFECTIVE_MATERIALS_PICKAXE = Sets.newHashSet((Object[])new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151574_g, Material.field_151588_w, Material.field_151598_x, hell_rock, fuller_clay});
    public static final Set<Material> EFFECTIVE_MATERIALS_AXEAXE = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_151572_C, Material.field_151589_v, Material.field_215713_z, Material.field_237214_y_, Material.field_151580_n, Material.field_151593_r, Material.field_151570_A, Material.field_151583_m, gauge_pole, bio_residue, tough_wood});
    public static final Set<Material> EFFECTIVE_MATERIALS_SHOVEL = Sets.newHashSet((Object[])new Material[]{Material.field_151578_c, Material.field_151595_p, Material.field_151571_B, Material.field_151597_y, Material.field_151596_z, dirty_dirt, cursed_dirt, blessed_dirt, sludge, gel});
    public static final Set<Material> EFFECTIVE_MATERIALS_HAMMER = Sets.newHashSet((Iterator)Iterators.concat(EFFECTIVE_MATERIALS_PICKAXE.iterator(), EFFECTIVE_MATERIALS_AXEAXE.iterator()));

    public static final Material[] getForMiningMultitool() {
        HashSet all = Sets.newHashSetWithExpectedSize((int)71);
        all.addAll(EFFECTIVE_MATERIALS_CIRCUITS);
        all.addAll(EFFECTIVE_MATERIALS_PICKAXE);
        all.addAll(EFFECTIVE_MATERIALS_AXEAXE);
        all.addAll(EFFECTIVE_MATERIALS_SHOVEL);
        return all.toArray(new Material[all.size()]);
    }

    public static final Material[] getForMiningCrackhammer() {
        HashSet all = Sets.newHashSetWithExpectedSize((int)61);
        all.addAll(EFFECTIVE_MATERIALS_CIRCUITS);
        all.addAll(EFFECTIVE_MATERIALS_HAMMER);
        return all.toArray(new Material[all.size()]);
    }

    public static final Material[] getForMiningQuickPickaxe() {
        HashSet all = Sets.newHashSetWithExpectedSize((int)61);
        all.addAll(EFFECTIVE_MATERIALS_CIRCUITS);
        all.addAll(EFFECTIVE_MATERIALS_PICKAXE);
        return all.toArray(new Material[all.size()]);
    }

    public static final boolean isStickShearable(Material material) {
        return material == SharedGlue.Material_plants || material == SharedGlue.Material_leaves || material == SharedGlue.Material_vine || material == SharedGlue.Material_coral || material == Material.field_204868_h || material == Material.field_203243_f || material == Material.field_242934_h || material == rotten_plants || material == dried_leaves || material == tough_leaves;
    }

    public static final boolean isNonColliding(Material material, boolean large) {
        return material == SharedGlue.Material_plants || material == SharedGlue.Material_air || material == SharedGlue.Material_vine || material == Material.field_204868_h || material == rotten_plants || material == Material.field_242934_h || material == Material.field_203243_f || !large && (material == SharedGlue.Material_web || material == SharedGlue.Material_coral);
    }

    public static boolean isRockHard(Material m) {
        return m == SharedGlue.Material_rock || m == hell_rock;
    }

    public static boolean isDirtHard(Material m) {
        return m == SharedGlue.Material_ground;
    }

    public static boolean isClayHard(Material m) {
        return m == SharedGlue.Material_clay || m == fuller_clay;
    }

    protected Materials() {
    }

    public static final class BetterBuilder
    extends Material.Builder {
        private Boolean _opaque = null;

        public BetterBuilder(MaterialColor c) {
            super(c);
        }

        public BetterBuilder pushDestroys() {
            super.func_200511_g();
            return this;
        }

        public BetterBuilder flammable() {
            super.func_200504_e();
            return this;
        }

        public BetterBuilder pushBlocks() {
            super.func_200503_h();
            return this;
        }

        public BetterBuilder requiresTool() {
            return this;
        }

        public BetterBuilder notOpaque() {
            this._opaque = false;
            return this;
        }

        public BetterBuilder(@Nonnull Material m, @Nullable MaterialColor c) {
            super(c != null ? c : m.func_151565_r());
            if (m.func_76224_d()) {
                this.func_200507_a();
            }
            if (!m.func_76220_a()) {
                this.func_200502_b();
            }
            if (!m.func_76230_c()) {
                this.func_200508_c();
            }
            if (!m.func_76218_k()) {
                this._opaque = false;
            }
            if (m.func_76217_h()) {
                this.flammable();
            }
            if (m.func_76222_j()) {
                this.func_200509_f();
            }
            if (m.func_186274_m() == PushReaction.DESTROY) {
                this.pushDestroys();
            } else if (m.func_186274_m() == PushReaction.BLOCK) {
                this.pushBlocks();
            }
        }

        public Material func_200506_i() {
            Material m = super.func_200506_i();
            if (this._opaque != null) {
                Material om;
                m = om = new Material(m.func_151565_r(), m.func_76224_d(), m.func_76220_a(), m.func_76230_c(), this._opaque.booleanValue(), m.func_76217_h(), m.func_76222_j(), m.func_186274_m());
            }
            return m;
        }
    }
}

