/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.EmptyFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.api.IModItem;

public final class RID {
    public static final String nullProxy = "carrots:null";
    public static final String adhesiveBlock = "carrots:adhesive_blocks";
    public static final String anyArrow = "minecraft:arrows";
    public static final String anyBone = "bones";
    public static final String anyBook = "books";
    public static final String anyChest = "chests";
    public static final String anyColorlessGlass = "carrots:colorless_glass";
    public static final String anyDirt = "dirt";
    public static final String anyDye = "dyes";
    public static final String anyEgg = "eggs";
    public static final String anyFeather = "feathers";
    public static final String anyGlass = "carrots:glass";
    public static final String anyOreBlock = "ores";
    public static final String anyPaper = "paper";
    public static final String anyHead = "carrots:heads";
    public static final String anyString = "strings";
    public static final String anyStone = "stone";
    public static final String anyVine = "vines";
    public static final String blazepowder = "dusts/blaze";
    public static final String bonemeal = "bonemeals";
    public static final String cactusBlock = "cactus";
    public static final String clayball = "ingots/clay";
    public static final String coalBlock = "storage_blocks/coal";
    public static final String cobblestone = "cobblestone";
    public static final String darkprismarineBlock = "prismarine/dark";
    public static final String diamond = "gems/diamond";
    public static final String diamondBlock = "storage_blocks/diamonds";
    public static final String diamondNugget = "nuggets/diamond";
    public static final String dirtDust = "dusts/dirt";
    public static final String emerald = "gems/emerald";
    public static final String emeraldBlock = "storage_blocks/emerald";
    public static final String emeraldNugget = "nuggets/emerald";
    public static final String emptyBottle = "empty_bottles";
    public static final String emptyBowl = "bowls";
    public static final String emptyBucket = "buckets/empty/iron";
    public static final String emptyIronBucket = "buckets/empty/iron";
    public static final String emptyJar = "carrots:empty_jars";
    public static final String enderpearl = "enderpearls";
    public static final String xpBucket = "buckets/experience";
    public static final String flint = "flint";
    public static final String gelatinBlock = "storage_blocks/gelatin";
    public static final String glowstoneDust = "dusts/glowstone";
    public static final String goldIngot = "ingots/gold";
    public static final String goldNugget = "nuggets/gold";
    public static final String goldBlock = "storage_blocks/gold";
    public static final String gravel = "gravel";
    public static final String gunpowder = "dusts/gunpowder";
    public static final String ironBlock = "storage_blocks/iron";
    public static final String ironIngot = "ingots/iron";
    public static final String ironNugget = "nuggets/iron";
    public static final String lapis = "gems/lapis";
    public static final String lapisBlock = "storage_blocks/lapis";
    public static final String lapisNugget = "nuggets/lapis";
    public static final String lavaBucket = "buckets/lava";
    public static final String lavaDust = "dusts/lava";
    public static final String lavaFluid = "minecraft:lava";
    public static final String lifeEssence = "carrots:life_essences";
    public static final String lifeRebirth = "carrots:rebirth_essences";
    public static final String looseEmptyBucket = "buckets/empty";
    public static final String mendingTwine = "carrots:ties/mending";
    public static final String milkBucket = "buckets/milk";
    public static final String netherrack = "netherrack";
    public static final String obsidian = "obsidian";
    public static final String ore = "ores";
    public static final String paper = "paper";
    public static final String pinkWool = "wool/pink";
    public static final String portionHide = "carrots:portions_hide";
    public static final String prismarineBlock = "prismarine";
    public static final String potableBucket = "buckets/potable_water";
    public static final String potableFluid = "forge:potable_water";
    public static final String potionBottle = "carrots:potion_bottles";
    public static final String quartz = "gems/quartz";
    public static final String quartzNugget = "nuggets/quartz";
    public static final String redstoneBlock = "storage_blocks/redstone";
    public static final String redstoneDust = "dusts/redstone";
    public static final String rock = "rocks";
    public static final String rottenflesh = "rotten_flesh";
    public static final String sand = "minecraft:sand";
    public static final String slimeball = "slime_balls";
    public static final String slimeBlock = "storage_blocks/slime_balls";
    public static final String slimeBucket = "buckets/slime";
    public static final String slimeNugget = "nuggets/slime";
    public static final String smallrock = "rocks/small";
    public static final String sponge = "carrots:portions_sponge";
    public static final String spongeBlock = "sponges";
    public static final String stone = "stone";
    public static final String stoneNugget = "nuggets/stone";
    public static final String stoneStick = "rods/stone";
    public static final String strongTie = "carrots:ties/strong";
    public static final String tipped_arrow = "carrots:arrows/tipped";
    public static final String treeLeaves = "minecraft:leaves";
    public static final String treeSapling = "minecraft:saplings";
    public static final String waterBottle = "water_bottles";
    public static final String waterBucket = "buckets/water";
    public static final String waterFluid = "minecraft:water";
    public static final String waterTreatment = "carrots:water_treatments";
    public static final String wheatCrop = "crops/wheat";
    public static final String witherBone = "bones/wither";
    public static final String woodBowl = "bowls/wooden";
    public static final String woodChest = "chests/wooden";
    public static final String woodFence = "fences/wooden";
    public static final String woodLog = "minecraft:logs";
    public static final String woodPlank = "minecraft:planks";
    public static final String woodSlab = "minecraft:slabs";
    public static final String woodStick = "rods/wooden";
    public static final String woolBlock = "minecraft:wool";

    static final ResourceLocation _r(String tag) {
        int i = tag.indexOf(58);
        if (i < 0) {
            tag = "forge:" + tag;
        } else if (i == 0) {
            tag = "forge" + tag;
        }
        return new ResourceLocation(tag);
    }

    static final ItemStack _i(Item item) {
        if (item instanceof IModItem) {
            return ((IModItem)item).createInstance(item);
        }
        return new ItemStack((IItemProvider)item);
    }

    public static final String _s(String tag) {
        return RID._r(tag).toString();
    }

    @Nullable
    public static final ResourceLocation r(String tag) {
        if (tag == null) {
            return null;
        }
        int i = tag.indexOf(58);
        if (i < 0) {
            tag = "forge:" + tag;
        } else if (i == 0) {
            tag = "forge" + tag;
        }
        return ResourceLocation.func_208304_a((String)tag);
    }

    public static final String fstring(String name) {
        return "forge:" + name;
    }

    public static final ITag<Item> itemTagsOrEmpty(ResourceLocation r) {
        ITag.INamedTag<Item> t = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(r);
        return t != null ? t : Tags.NO_ITEMS;
    }

    public static final ITag<Block> blockTagsOrEmpty(ResourceLocation r) {
        ITag.INamedTag<Block> t = TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(r);
        return t != null ? t : Tags.NO_BLOKS;
    }

    public static final boolean isGroupDefined(String tag) {
        return TagCollectionManager.func_242178_a().func_241836_b().func_241833_a().containsKey(RID._r(tag));
    }

    @Nonnull
    public static final Collection<Item> getItemsInGroup(String tag) {
        if (!RID.isGroupDefined(tag)) {
            return Collections.EMPTY_LIST;
        }
        ResourceLocation r = RID._r(tag);
        return new ArrayList<Item>(RID.itemTagsOrEmpty(r).func_230236_b_());
    }

    @Nonnull
    public static final List<ItemStack> getAllInGroup(String tag) {
        if (!RID.isGroupDefined(tag)) {
            return Collections.EMPTY_LIST;
        }
        ResourceLocation r = RID._r(tag);
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(11);
        for (Item item : RID.itemTagsOrEmpty(r).func_230236_b_()) {
            all.add(RID._i(item));
        }
        return all;
    }

    @Nullable
    public static final ITag<Item> getTag(ResourceLocation tag) {
        return tag == null ? null : TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(tag);
    }

    @Nullable
    public static final ITag<Item> getTag(String tag) {
        return tag == null ? null : TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(RID.r(tag));
    }

    public static final boolean isIn(Item item, String tag) {
        ITag<Item> group = RID.getTag(tag);
        return group != null && item.func_206844_a(group);
    }

    @Nullable
    public static final ITag<Block> getBlockTag(@Nullable String tag) {
        return tag == null ? null : TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(RID.r(tag));
    }

    public static final boolean isIn(Block block, String tag) {
        ITag<Block> group = RID.getBlockTag(tag);
        return group != null && block.func_203417_a(group);
    }

    public static final boolean isIn(@Nullable BlockState block, String tag) {
        if (block == null) {
            return false;
        }
        ITag<Block> group = RID.getBlockTag(tag);
        return group != null && block.func_235714_a_(group);
    }

    @Nullable
    public static final ITag<Fluid> getFluidTag(@Nullable String tag) {
        return tag == null ? null : TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(RID.r(tag));
    }

    public static final boolean isIn(@Nonnull Fluid fluid, String tag) {
        ITag<Fluid> group = RID.getFluidTag(tag);
        return group != null && fluid.func_207185_a(group);
    }

    @Nullable
    public static final ITag<EntityType<?>> getEntityTypeTag(@Nullable String tag) {
        return tag == null ? null : TagCollectionManager.func_242178_a().func_241838_d().func_199910_a(RID.r(tag));
    }

    public static final boolean isIn(@Nonnull EntityType<?> type, String tag) {
        ITag<EntityType<?>> group = RID.getEntityTypeTag(tag);
        return group != null && type.func_220341_a(group);
    }

    @Nullable
    public static final ITag<Enchantment> getEnchantmentTag(@Nullable String tag) {
        return tag == null ? null : TagCollectionManager.func_242178_a().getCustomTypeCollection(ForgeRegistries.ENCHANTMENTS).func_199910_a(RID.r(tag));
    }

    @Nullable
    public static final ITag<Potion> getPotionTag(@Nullable String tag) {
        return tag == null ? null : TagCollectionManager.func_242178_a().getCustomTypeCollection(ForgeRegistries.POTION_TYPES).func_199910_a(RID.r(tag));
    }

    @Nonnull
    public static final ItemStack getFirst(@Nullable String tag) {
        ITag<Item> all = RID.getTag(tag);
        if (all != null) {
            try {
                Iterator iterator = all.func_230236_b_().iterator();
                if (iterator.hasNext()) {
                    Item item = (Item)iterator.next();
                    return RID._i(item);
                }
            }
            catch (IllegalStateException not_bound) {
                LibInfo.LOG.warn(not_bound.getMessage());
            }
        }
        return ItemStack.field_190927_a;
    }

    public static final boolean isIngredientDefined(@Nullable String tag) {
        return !RID.getFirst(tag).func_190926_b();
    }

    public static final boolean isFluidDefined(@Nullable String tag) {
        ITag<Fluid> all = RID.getFluidTag(tag);
        if (all != null) {
            for (Fluid f : all.func_230236_b_()) {
                if (f == Fluids.field_204541_a || f instanceof EmptyFluid) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean matches(@Nullable ItemStack stack, @Nonnull String tag, @Nullable Item preference) {
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (item == preference) {
                return true;
            }
            if (tag.charAt(0) == '#') {
                tag = tag.substring(1);
            } else if (tag.contains(":")) {
                ResourceLocation r = new ResourceLocation(tag);
                Item item2 = preference = ForgeRegistries.ITEMS.containsKey(r) ? (Item)ForgeRegistries.ITEMS.getValue(r) : null;
                if (preference != null && item == preference) {
                    return true;
                }
            }
            if (RID.getItemsInGroup(tag).contains(item)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean matches(ItemStack stack, @Nonnull String tag) {
        return RID.matches(stack, tag, null);
    }

    public static final boolean matches(@Nullable ItemStack stack, @Nonnull ResourceLocation tag, @Nullable Item preference) {
        if (!ItemStacks.isEmpty(stack) && tag != null) {
            Item item = stack.func_77973_b();
            if (item == preference) {
                return true;
            }
            try {
                ITag<Item> tagcoll = RID.getTag(tag);
                if (tagcoll != null && tagcoll.func_230236_b_().contains(item)) {
                    return true;
                }
            }
            catch (IllegalStateException not_bound) {
                LibInfo.LOG.warn(not_bound.getMessage());
            }
        }
        return false;
    }

    private RID() {
    }

    public static final void init() {
    }

    public static class Tags {
        public static final ITag.INamedTag<Item> NO_ITEMS = Tags.forItems("carrots:null");
        public static final ITag.INamedTag<Block> NO_BLOKS = Tags.forBlocks("carrots:null");
        public static final ITag.INamedTag<Item> HAPPY_FOODS = Tags.forItems(LibInfo.MOD_ID(), "happy_foods");
        public static final ITag.INamedTag<Item> HEADS = Tags.forItems(LibInfo.MOD_ID(), "heads");
        public static final ITag.INamedTag<Item> BARTER_TOKENS = Tags.forItems(LibInfo.MOD_ID(), "barter_tokens");
        public static final ITag.INamedTag<Item> LIGHTING_DUSTS = Tags.forItems("forge", "dusts/lighting");
        public static final ITag.INamedTag<Item> EMPTY_BUCKETS = Tags.forItems("forge", "buckets/empty");
        public static final ITag.INamedTag<Item> MOB_HEADS = Tags.forItems(LibInfo.MOD_ID(), "heads/mobs");
        public static final ITag.INamedTag<Item> HOES = Tags.forItems("forge", "tools/hoes");
        public static final ITag.INamedTag<Item> PAXELS = Tags.forItems("forge", "tools/paxels");
        public static final ITag.INamedTag<Item> SNIPS = Tags.forItems("forge", "tools/snips");
        public static final Tags.IOptionalNamedTag<Item> FLINT_STEELS = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge:tools/flint_steels"), Collections.singleton(() -> Items.field_151033_d));
        public static final ITag.INamedTag<Item> SHEARS = Tags.forItems("forge", "tools/shears");
        public static final ITag.INamedTag<Block> DIRT_LIKE = Tags.forBlocks("minecraft", "dirt_like");
        public static final ITag.INamedTag<Block> MAGMA_LIKE = Tags.forBlocks("minecraft", "magma_like");
        public static final ITag.INamedTag<Block> CACTUS_BLOCKS = Tags.forBlocks("forge", "cactus");
        public static final ITag.INamedTag<Block> GRASS_BLOCKS = Tags.forBlocks("forge", "grass");
        public static final ITag.INamedTag<Block> FARMLAND = Tags.forBlocks("forge", "farmland");
        public static final ITag.INamedTag<Block> LADDERS = Tags.forBlocks("minecraft", "ladders");
        public static final ITag.INamedTag<Block> LEVERS = Tags.forBlocks("minecraft", "levers");
        public static final ITag.INamedTag<Block> TORCHES = Tags.forBlocks("minecraft", "torches");
        public static final ITag.INamedTag<Block> CAMPFIRES = BlockTags.field_232882_ax_;
        public static final ITag.INamedTag<Block> OTHER_BONEMEALABLE = Tags.forBlocks("forge", "other_bonemealables");
        public static final ITag.INamedTag<Block> SUGARCANE = Tags.forBlocks("forge", "sugar_cane");
        public static final ITag.INamedTag<Block> TALL_FLOWERS = BlockTags.field_226148_H_;
        public static final ITag.INamedTag<Block> VINES = Tags.forBlocks("forge", "vines");
        public static final ITag.INamedTag<Fluid> HEALING_WATERS = Tags.forFluids("forge", "healing");
        public static final ITag.INamedTag<Block> TNT_LIKE = Tags.forBlocks("forge", "tnt_like");
        public static final ITag.INamedTag<EntityType<?>> BOAT_ENTITIES = Tags.forEntities("forge:boats");
        public static final ITag.INamedTag<EntityType<?>> MILKABLE_COWS = Tags.forEntities("forge:milkable_dairy_cows");
        public static final ITag.INamedTag<EntityType<?>> MILKABLE_MOOSHROOMS = Tags.forEntities("forge:milkable_shroom_cows");
        public static final ITag.INamedTag<EntityType<?>> MILKABLE_SHEEP = Tags.forEntities("forge:milkable_sheep");

        public static final ITag.INamedTag<Block> forBlocks(String rid) {
            return BlockTags.func_199894_a((String)rid);
        }

        public static final ITag.INamedTag<Block> forBlocks(String domain, String rid) {
            return BlockTags.func_199894_a((String)(domain + ":" + rid));
        }

        public static final ITag.INamedTag<Item> forItems(String rid) {
            return ItemTags.func_199901_a((String)rid);
        }

        public static final Tags.IOptionalNamedTag<Item> forOptionalItems(String rid) {
            return ItemTags.createOptional((ResourceLocation)new ResourceLocation(rid));
        }

        public static final Tags.IOptionalNamedTag<Item> forOptionalItems(String domain, String rid) {
            return ItemTags.createOptional((ResourceLocation)new ResourceLocation(domain, rid));
        }

        public static final ITag.INamedTag<Item> forItems(String domain, String rid) {
            return ItemTags.func_199901_a((String)(domain + ":" + rid));
        }

        public static final ITag.INamedTag<Fluid> forFluids(String rid) {
            return FluidTags.func_206956_a((String)rid);
        }

        public static final ITag.INamedTag<Fluid> forFluids(String domain, String rid) {
            return FluidTags.func_206956_a((String)(domain + ":" + rid));
        }

        public static final ITag.INamedTag<EntityType<?>> forEntities(String rid) {
            return EntityTypeTags.createOptional((ResourceLocation)new ResourceLocation(rid));
        }

        public static final ITag.INamedTag<Enchantment> forEnchantment(String rid) {
            return ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (ResourceLocation)new ResourceLocation(rid));
        }

        public static final Tags.IOptionalNamedTag<Enchantment> forOptionalEnchantment(String rid) {
            return ForgeTagHandler.createOptionalTag((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (ResourceLocation)new ResourceLocation(rid));
        }
    }
}

