/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.advancements.AdvancementTrigger;
import org.jwaresoftware.mcmods.lib.advancements.CraftedItemTrigger;
import org.jwaresoftware.mcmods.lib.advancements.HarvestedTrigger;
import org.jwaresoftware.mcmods.lib.advancements.LootedItemTrigger;
import org.jwaresoftware.mcmods.lib.advancements.PlayerEarnedTrigger;
import org.jwaresoftware.mcmods.lib.advancements.PlayerScoreTrigger;
import org.jwaresoftware.mcmods.lib.advancements.PlayerStatTrigger;
import org.jwaresoftware.mcmods.lib.advancements.StatPredicate;

public class CarrotsTriggers {
    protected CarrotsTriggers() {
    }

    public static final void initTriggerSupport() {
        CriteriaTriggers.func_192118_a((ICriterionTrigger)LootedItemTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)CraftedItemTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)AdvancementTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)PlayerStatTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)PlayerScoreTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)HarvestedTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)PlayerEarnedTrigger.INSTANCE);
    }

    public static final void initFinalize() {
        StatPredicate.initFinalize();
        if (LibConfig.installAdvancementAutoTriggers()) {
            MinecraftForge.EVENT_BUS.register((Object)new EventsListener());
        }
    }

    public static final AdvancementManager getADM() {
        return ServerLifecycleHooks.getCurrentServer().func_191949_aK();
    }

    public static final AdvancementManager getADM(@Nullable PlayerEntity player) {
        AdvancementManager adm = null;
        if (player instanceof ServerPlayerEntity) {
            adm = ((ServerPlayerEntity)player).field_71133_b.func_191949_aK();
        }
        return adm != null ? adm : CarrotsTriggers.getADM();
    }

    public static final class EventsListener {
        EventsListener() {
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onItemCrafted(PlayerEvent.ItemCraftedEvent e) {
            if (SharedGlue.isaProgressAffectedPlayer((Entity)e.getPlayer()) && !ItemStacks.isEmpty(e.getCrafting())) {
                CraftedItemTrigger.doApply((ServerPlayerEntity)e.getPlayer(), e.getCrafting());
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onItemSmelted(PlayerEvent.ItemSmeltedEvent e) {
            if (SharedGlue.isaProgressAffectedPlayer((Entity)e.getPlayer()) && !ItemStacks.isEmpty(e.getSmelting())) {
                CraftedItemTrigger.doApply((ServerPlayerEntity)e.getPlayer(), e.getSmelting());
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onItemBrewed(PlayerBrewedPotionEvent e) {
            if (SharedGlue.isaProgressAffectedPlayer((Entity)e.getPlayer()) && !ItemStacks.isEmpty(e.getStack())) {
                CraftedItemTrigger.doApply((ServerPlayerEntity)e.getPlayer(), e.getStack());
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onItemRepaired(AnvilRepairEvent e) {
            ItemStack output = e.getItemResult();
            if (SharedGlue.isaProgressAffectedPlayer((Entity)e.getPlayer()) && !ItemStacks.isEmpty(output)) {
                ItemStack input = e.getItemInput();
                ItemStack material = e.getIngredientInput();
                if (!ItemStacks.isEmpty(input) && !ItemStacks.isEmpty(material) && input.func_77973_b() != output.func_77973_b()) {
                    CraftedItemTrigger.doApply((ServerPlayerEntity)e.getPlayer(), output);
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onItemFished(ItemFishedEvent e) {
            if (SharedGlue.isaProgressAffectedPlayer((Entity)e.getPlayer())) {
                for (ItemStack fishedUp : e.getDrops()) {
                    CraftedItemTrigger.doApply((ServerPlayerEntity)e.getPlayer(), fishedUp);
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onBucketScooped(FillBucketEvent e) {
            ItemStack filledBucket;
            if (SharedGlue.isaProgressAffectedPlayer((Entity)e.getPlayer()) && !ItemStacks.isEmpty(filledBucket = e.getFilledBucket()) && !ItemStacks.areItemStacksEqual(e.getEmptyBucket(), filledBucket)) {
                CraftedItemTrigger.doApply((ServerPlayerEntity)e.getPlayer(), filledBucket);
            }
        }

        @SubscribeEvent
        public void onAdvancement(AdvancementEvent e) {
            if (SharedGlue.isaProgressAffectedPlayer((Entity)e.getPlayer())) {
                ServerPlayerEntity player = (ServerPlayerEntity)e.getPlayer();
                ResourceLocation advancement = e.getAdvancement().func_192067_g();
                AdvancementTrigger.doApply(player, advancement);
                PlayerEarnedTrigger.doApply(player, advancement);
            }
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent e) {
            ServerPlayerEntity player;
            long t;
            long modulo = LibConfig.tickScoreTriggersFrequency();
            if (modulo > 0L && e.phase == TickEvent.Phase.END && e.side == LogicalSide.SERVER && SharedGlue.isaProgressAffectedPlayer((Entity)e.player) && (t = (player = (ServerPlayerEntity)e.player).func_130014_f_().func_82737_E()) % modulo == 0L) {
                PlayerStatTrigger.doApply(player);
                PlayerScoreTrigger.doApply(player);
                PlayerEarnedTrigger.doApply(player);
            }
        }
    }
}

