/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.advancements.AdvancementPredicate;
import org.jwaresoftware.mcmods.lib.advancements.RewardPredicate;
import org.jwaresoftware.mcmods.lib.advancements.ScorePredicate;
import org.jwaresoftware.mcmods.lib.advancements.StatPredicate;

public final class PlayerEarnedTrigger
extends AbstractCriterionTrigger<Instance> {
    @Nonnull
    public static final ResourceLocation NAME = LibInfo.r("player_earned");
    @Nonnull
    public static final PlayerEarnedTrigger INSTANCE = new PlayerEarnedTrigger();

    public ResourceLocation func_192163_a() {
        return NAME;
    }

    protected Instance deserializeTrigger(@Nonnull JsonObject json, @Nonnull EntityPredicate.AndPredicate pp, @Nonnull ConditionArrayParser ca) {
        return Instance.deserialize(pp, json);
    }

    private PlayerEarnedTrigger() {
    }

    public void trigger(ServerPlayerEntity player, ResourceLocation with) {
        this.func_235959_a_(player, instance -> instance.test(with));
    }

    public void trigger(ServerPlayerEntity player, ItemStack with) {
        this.func_235959_a_(player, instance -> instance.test((PlayerEntity)player, with, null));
    }

    public void trigger(ServerPlayerEntity player, ResourceLocation name, ItemStack with) {
        this.func_235959_a_(player, instance -> instance.test((PlayerEntity)player, with, name));
    }

    public static final void doApply(ServerPlayerEntity player, ResourceLocation thing) {
        INSTANCE.trigger(player, thing);
    }

    public static final void doApply(ServerPlayerEntity player, ItemStack thing) {
        INSTANCE.trigger(player, thing);
    }

    public static final void doApply(ServerPlayerEntity player, ResourceLocation thing, ItemStack with) {
        INSTANCE.trigger(player, thing, with);
    }

    public static final void doApply(ServerPlayerEntity player, Item awarded) {
        if (SharedGlue.isDefined(awarded)) {
            INSTANCE.trigger(player, awarded.getRegistryName());
        }
    }

    public static final void doApply(ServerPlayerEntity player) {
        INSTANCE.trigger(player, ItemStack.field_190927_a);
    }

    public static final class Instance
    extends CriterionInstance {
        private final Optional<StatPredicate> _stats;
        private final Optional<AdvancementPredicate> _advancement;
        private final Optional<RewardPredicate> _reward;
        private final Optional<ScorePredicate> _scores;

        public Instance(EntityPredicate.AndPredicate pp, Optional<AdvancementPredicate> advancement, Optional<StatPredicate> stats, Optional<RewardPredicate> reward, Optional<ScorePredicate> scores) {
            super(NAME, pp);
            this._stats = stats != null ? stats : Optional.empty();
            this._reward = reward != null ? reward : Optional.empty();
            this._advancement = advancement != null ? advancement : Optional.empty();
            this._scores = scores != null ? scores : Optional.empty();
        }

        public Instance(RewardPredicate reward) {
            this(EntityPredicate.AndPredicate.field_234582_a_, null, null, Optional.ofNullable(reward), null);
        }

        public boolean test(ResourceLocation what) {
            if (this._advancement.isPresent() || this._scores.isPresent() || this._stats.isPresent()) {
                return false;
            }
            return this._reward.get().test(what);
        }

        public boolean test(PlayerEntity player, ItemStack with, @Nullable ResourceLocation what) {
            boolean t;
            boolean bl = t = this._advancement.isPresent() ? this._advancement.get().test(player) : true;
            if (!t) {
                return false;
            }
            boolean bl2 = t = this._reward.isPresent() ? this._reward.get().test(player, with, what) : true;
            if (!t) {
                return false;
            }
            boolean bl3 = t = this._stats.isPresent() ? this._stats.get().test(player) : true;
            if (!t) {
                return false;
            }
            return this._scores.isPresent() ? this._scores.get().test(player) : true;
        }

        public final boolean test(Item awarded) {
            return SharedGlue.isDefined(awarded) && this.test(awarded.getRegistryName());
        }

        public JsonObject func_230240_a_(ConditionArraySerializer ca) {
            JsonObject all = super.func_230240_a_(ca);
            if (this._advancement.isPresent()) {
                this._advancement.get().serialize_into(all);
            }
            if (this._stats.isPresent()) {
                this._stats.get().serialize_into(all);
            }
            if (this._reward.isPresent()) {
                this._reward.get().serialize_into(all);
            }
            if (this._scores.isPresent()) {
                this._scores.get().serialize_into(all);
            }
            return all;
        }

        static final Instance deserialize(EntityPredicate.AndPredicate pp, JsonObject all) {
            Optional<RewardPredicate> reward = RewardPredicate.deserialize_outof(all);
            Optional<AdvancementPredicate> advancement = AdvancementPredicate.deserialize_outof(all);
            Optional<StatPredicate> stats = StatPredicate.deserialize_outof(all);
            Optional<ScorePredicate> scores = ScorePredicate.deserialize_outof(all);
            return new Instance(pp, advancement, stats, reward, scores);
        }
    }
}

