/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.Locale;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public enum DayNightState {
    UNKNOWN(false),
    DAWN(true),
    DAY(true),
    DUSK(true),
    NIGHT(false);

    public static final Check SIMPLE;
    private final String _name_lc = this.name().toLowerCase(Locale.ROOT);
    private final boolean _light;

    private DayNightState(boolean light) {
        this._light = light;
    }

    public String toString() {
        return this._name_lc;
    }

    public boolean isKnown() {
        return this != UNKNOWN;
    }

    public final boolean hasAnyLight() {
        return this._light;
    }

    @Nonnull
    public static final DayNightState fromWorld(IBiomeReader worldr, BlockPos at) {
        if (!SharedGlue.isaWorld((IWorldReader)worldr)) {
            return UNKNOWN;
        }
        World world = (World)worldr;
        RegistryKey<Biome> biome = Locations.biomeKeyFor(worldr, at);
        if (Locations.inTheNether(biome, worldr, at)) {
            return NIGHT;
        }
        if (Locations.inTheEnd(biome, worldr, at)) {
            return NIGHT;
        }
        if (!Locations.isOverworld((IWorldReader)worldr)) {
            return world.func_72935_r() ? DAY : NIGHT;
        }
        return Locations.isDayTime((IWorld)world, at) ? DAY : NIGHT;
    }

    static {
        SIMPLE = DayNightState::fromWorld;
    }

    public static interface Check
    extends BiFunction<IWorld, BlockPos, DayNightState> {
    }
}

