/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Foods;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.NPE;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.XpCalculations;
import org.jwaresoftware.mcmods.lib.api.IConsumable;
import org.jwaresoftware.mcmods.lib.api.INutritionSource;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.ObjRef;
import org.jwaresoftware.mcmods.lib.integration.ENVHelper;

public interface IDrinkableFluid
extends IConsumable,
INutritionSource {
    public static final IDrinkableFluid NONE = new IDrinkableFluid(){

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.NONE;
        }

        @Override
        public boolean isConsumable() {
            return false;
        }

        @Override
        public boolean isConsumableAlways() {
            return false;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public IDrinkableFluid getDrinkableSip() {
            return null;
        }
    };
    public static final IDrinkableFluid WATER = new IDrinkableFluid(){

        @Override
        public boolean isConsumableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.WATER;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }
    };
    public static final IDrinkableFluid WATER_MARBLE = new Sip(() -> NourishingDrink.NO_EFFECT, false){

        @Override
        public boolean isConsumableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.WATER_MARBLE;
        }

        @Override
        protected boolean cureBadPotionEffects(LiquidType drinkType, LivingEntity drinker, ItemStack rep) {
            return false;
        }
    };
    public static final IDrinkableFluid WATERWATER = new NourishingDrink(){

        @Override
        public boolean isConsumableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.WATER;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }
    };
    public static final IDrinkableFluid CLEANWATER_BUCKET = new NourishingDrink(){

        @Override
        public boolean isConsumableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.POTABLE_WATER;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public IDrinkableFluid getDrinkableSip() {
            return WATER_MARBLE;
        }
    };
    public static final IDrinkableFluid MILK = new IDrinkableFluid(){

        @Override
        public boolean isConsumableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MILK;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }
    };
    public static final IDrinkableFluid MILK_MARBLE = new Sip(() -> NourishingDrink.UHC_RATION, false){

        @Override
        public boolean isConsumableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MILK_MARBLE;
        }

        @Override
        protected boolean cureBadPotionEffects(LiquidType drinkType, LivingEntity drinker, ItemStack rep) {
            return false;
        }
    };
    public static final IDrinkableFluid MILKMILK = new IDrinkableFluid(){

        @Override
        public boolean isConsumableAlways() {
            return true;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MILK;
        }

        @Override
        public float getNNHealAmount() {
            return 4.0f;
        }

        @Override
        public float getNNSaturationModifier() {
            return 1.0f;
        }
    };
    public static final IDrinkableFluid MILKMILK_BUCKET = new NourishingDrink(4.0f * MILKMILK.getNNHealAmount(), 1.0f, true, false){
        {
            this.setRegistryName(LibInfo.rstring("milk_bucket"));
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MILK;
        }

        @Override
        protected boolean cureBadPotionEffects(LiquidType drinkType, LivingEntity drinker, ItemStack rep) {
            Potions.cureBadPotionEffectsWithMilkBucket(drinker);
            return true;
        }

        @Override
        public IDrinkableFluid getDrinkableSip() {
            return MILK_MARBLE;
        }
    };
    public static final IDrinkableFluid PLANTMILK_BUCKET = new NourishingDrink(4.0f * MILKMILK.getNNHealAmount(), 1.0f, true, false){
        {
            this.setRegistryName(LibInfo.rstring("plantmilk_bucket"));
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.PLANTMILK;
        }

        @Override
        protected boolean cureBadPotionEffects(LiquidType drinkType, LivingEntity drinker, ItemStack rep) {
            Potions.cureBadPotionEffectsWithMilkBucket(drinker);
            return true;
        }

        @Override
        public IDrinkableFluid getDrinkableSip() {
            return MILK_MARBLE;
        }
    };
    public static final IDrinkableFluid HONEY_BUCKET = new NourishingDrink(4 * Foods.field_226604_w_.func_221466_a(), 1.2f, true, false){
        {
            this.setRegistryName(LibInfo.rstring("honey_bucket"));
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.HONEY;
        }

        @Override
        public boolean includeCooldown() {
            return true;
        }

        @Override
        protected boolean cureBadPotionEffects(LiquidType drinkType, LivingEntity drinker, ItemStack rep) {
            Potions.cureBadPotionEffectsWithHoney(drinker, true, true);
            return true;
        }

        @Override
        protected boolean applyPotionEffects(LivingEntity drinker, ItemStack rep) {
            super.applyPotionEffects(drinker, rep);
            drinker.func_195064_c(new EffectInstance(SharedGlue.Potion_regeneration, 100, 0));
            return true;
        }

        @Override
        public IDrinkableFluid getDrinkableSip() {
            return MILK_MARBLE;
        }
    };
    public static final IDrinkableFluid XP_BUCKET = new DrinkableFluid(){
        {
            this.setRegistryName(LibInfo.rstring("experience_bucket"));
        }

        @Override
        public boolean isConsumableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.XP;
        }

        @Override
        public void onDrunk(ItemStack what, @Nonnull LivingEntity drinker) {
            if (SharedGlue.isaRealNonSpectatingPlayer((Entity)drinker) && SharedGlue.isaServerWorld((IWorldReader)drinker.func_130014_f_())) {
                XpCalculations.spawnXPBurst(drinker.func_130014_f_(), drinker.func_226277_ct_(), drinker.func_226278_cu_(), drinker.func_226281_cx_(), 34, null);
                if (!what.func_190926_b()) {
                    ((PlayerEntity)drinker).func_71029_a(Stats.field_75929_E.func_199076_b((Object)what.func_77973_b()));
                    ItemSupport.noteItemConsumed((PlayerEntity)drinker, ItemStacks.copy1(what));
                }
            }
        }
    };
    public static final IDrinkableFluid POTION = new IDrinkableFluid(){

        @Override
        public boolean isConsumableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.POTION;
        }
    };
    public static final IDrinkableFluid SHROOSTEW = new IDrinkableFluid(){

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.STEW;
        }

        @Override
        public float getNNHealAmount() {
            return Foods.field_221448_x.func_221466_a();
        }

        @Override
        public float getNNSaturationModifier() {
            return Foods.field_221448_x.func_221469_b();
        }
    };
    public static final IDrinkableFluid SHROOSTEW_BUCKET = new NourishingDrink(4 * Foods.field_221448_x.func_221466_a(), 2.75f * Foods.field_221448_x.func_221469_b()){
        {
            this.setRegistryName(LibInfo.rstring("mooshroo_stew_bucket"));
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.STEW;
        }

        @Override
        public boolean includeCooldown() {
            return true;
        }

        @Override
        protected boolean playersOnly() {
            return true;
        }
    };
    public static final IDrinkableFluid MEATMILK = new IDrinkableFluid(){

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MEATMILK;
        }

        @Override
        public float getNNHealAmount() {
            return 10.0f;
        }

        @Override
        public float getNNSaturationModifier() {
            return 0.8f;
        }
    };
    public static final IDrinkableFluid MEATMILK_BUCKET = new NourishingDrink(4.0f * MEATMILK.getNNHealAmount(), 2.75f * MEATMILK.getNNSaturationModifier()){
        {
            this.setRegistryName(LibInfo.rstring("meatmilk_bucket"));
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MEATMILK;
        }

        @Override
        public boolean includeCooldown() {
            return true;
        }

        @Override
        protected boolean playersOnly() {
            return true;
        }
    };
    public static final IDrinkableFluid AMBROSIA = new NourishingDrink(4.0f, 1.2f){
        {
            this.setRegistryName(LibInfo.rstring("ambrosia"));
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.CURATIVE;
        }

        @Override
        public boolean includeCooldown() {
            return true;
        }

        @Override
        protected boolean cureBadPotionEffects(LiquidType drinkType, LivingEntity drinker, ItemStack rep) {
            Potions.cureBadPotionEffectsWithHoney(drinker, true, true);
            return true;
        }

        @Override
        protected boolean applyPotionEffects(LivingEntity drinker, ItemStack rep) {
            super.applyPotionEffects(drinker, rep);
            drinker.func_195064_c(new EffectInstance(SharedGlue.Potion_regeneration, 100, 1));
            drinker.func_195064_c(new EffectInstance(SharedGlue.Potion_absorption, 2400, 0));
            return true;
        }

        @Override
        public IDrinkableFluid getDrinkableSip() {
            return MILK_MARBLE;
        }
    };
    public static final IDrinkableFluid BIRCH_SAP = new NourishingDrink(3.0f, 3.34f, true, false){
        {
            this.setRegistryName(LibInfo.rstring("birch_sap"));
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.POWER;
        }

        @Override
        protected boolean cureBadPotionEffects(LiquidType drinkType, LivingEntity drinker, ItemStack rep) {
            Potions.removePotionEffectUnconditionally(drinker, SharedGlue.Potion_hunger);
            Potions.removePotionEffectUnconditionally(drinker, SharedGlue.Potion_nausea);
            if (drinker.func_70681_au().nextFloat() < 0.5f) {
                Potions.removePotionEffectUnconditionally(drinker, SharedGlue.Potion_poison);
            }
            return true;
        }
    };
    public static final IDrinkableFluid BIRCH_SAP_BUCKET = new NourishingDrink(2.0f * BIRCH_SAP.getNNHealAmount(), BIRCH_SAP.getNNSaturationModifier(), true, false){
        {
            this.setRegistryName(LibInfo.rstring("birch_sap_bucket"));
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.POWER;
        }

        @Override
        protected boolean playersOnly() {
            return true;
        }

        @Override
        protected boolean cureBadPotionEffects(LiquidType drinkType, LivingEntity drinker, ItemStack rep) {
            ((NourishingDrink)BIRCH_SAP).cureBadPotionEffects(drinkType, drinker, rep);
            Potions.removePotionEffectUnconditionally(drinker, SharedGlue.Potion_poison);
            return true;
        }

        @Override
        protected boolean applyPotionEffects(LivingEntity drinker, ItemStack rep) {
            super.applyPotionEffects(drinker, rep);
            drinker.func_195064_c(new EffectInstance(SharedGlue.Potion_saturation, 2400, 0));
            return true;
        }
    };

    default public boolean isConsumableAlwaysForHydration() {
        return this.getNNHealAmount() == 0.0f && this.getDrinkValues().getThirstQuenched(ItemStack.field_190927_a) > 0.0f;
    }

    @Override
    default public boolean isConsumableAlways() {
        return this.isConsumableAlwaysForHydration();
    }

    @Nonnull
    default public LiquidType getDrinkValues() {
        return LiquidType.GENERIC;
    }

    @Override
    default public float getNNHealAmount() {
        return 0.0f;
    }

    @Override
    default public float getNNHealAmount(ItemStack drink) {
        return this.getNNHealAmount();
    }

    @Override
    default public float getNNSaturationModifier() {
        return 0.0f;
    }

    @Override
    default public float getNNSaturationModifier(ItemStack drink) {
        return this.getNNSaturationModifier();
    }

    default public void onDrunk(ItemStack what, @Nonnull LivingEntity drinker) {
    }

    @Override
    default public boolean includeCooldown() {
        return !this.isConsumableAlways() && this.getNNHealAmount() > 16.0f;
    }

    @Nullable
    default public IDrinkableFluid getDrinkableSip() {
        return null;
    }

    public static class DynamicDrink
    extends NourishingDrink {
        protected final LiquidType _lqtype;

        public DynamicDrink(@Nonnull LiquidType lqtype, Supplier<Food> on_drunk) {
            super(on_drunk, false);
            this._lqtype = Objects.requireNonNull(lqtype);
        }

        public DynamicDrink(@Nonnull LiquidType lqtype, int nutrition, float saturation, boolean always) {
            super(nutrition, saturation, always, false);
            this._lqtype = Objects.requireNonNull(lqtype);
        }

        @Override
        public LiquidType getDrinkValues() {
            return this._lqtype;
        }

        @Override
        protected boolean playersOnly() {
            return true;
        }

        @Override
        public void onDrunk(ItemStack what, LivingEntity drinker) {
            this.onDrunkImpl(what, drinker);
        }
    }

    public static class Sip
    extends NourishingDrink {
        public Sip(Supplier<Food> on_drunk, boolean universal) {
            super(on_drunk, universal);
        }

        public Sip(int nutrition, float saturation, boolean universal) {
            super(nutrition, saturation, true, universal);
        }

        @Override
        public void onDrunk(ItemStack what, @Nonnull LivingEntity drinker) {
            if (what.func_190926_b()) {
                this.onDrunkImpl(this.sample(), drinker);
            }
        }
    }

    public static class NourishingDrink
    extends DrinkableFluid {
        public static final Food NO_EFFECT = new Food.Builder().func_221456_a(0).func_221454_a(0.0f).func_221457_c().func_221453_d();
        public static final Food SURVIVAL_RATION = new Food.Builder().func_221456_a(1).func_221454_a(0.05f).func_221457_c().func_221453_d();
        public static final Food UHC_RATION = new Food.Builder().func_221456_a(1).func_221454_a(0.05f).func_221457_c().effect(() -> Potions.newPotionEffect(SharedGlue.Potion_regeneration, 20, 1), 1.0f).func_221453_d();
        @Nonnull
        protected final Supplier<Food> _on_drunk;
        protected final boolean _heal_all;
        private INutritionSource _on_drunk_wrapper = null;

        protected NourishingDrink() {
            this._on_drunk = () -> NO_EFFECT;
            this._heal_all = false;
        }

        public NourishingDrink(Supplier<Food> on_drunk, boolean universal) {
            this._on_drunk = on_drunk == null ? () -> NO_EFFECT : on_drunk;
            this._heal_all = universal;
        }

        public NourishingDrink(float nutrition, float saturation, boolean always, boolean universal) {
            Food food = ItemSupport.foodFrom((int)nutrition, saturation, false, always, false).func_221453_d();
            this._on_drunk = () -> food;
            this._heal_all = universal;
        }

        public NourishingDrink(float nutrition, float saturation) {
            this(nutrition, saturation, false, false);
        }

        private INutritionSource defaultNutrition() {
            if (this._on_drunk_wrapper == null) {
                this._on_drunk_wrapper = new INutritionSource.Simple(this._on_drunk.get());
            }
            return this._on_drunk_wrapper;
        }

        @Nonnull
        public final INutritionSource getNutrition(ItemStack drink) {
            FluidStack fluidstack;
            if (!drink.func_190926_b() && !(fluidstack = Fluids.getGenericFluid(drink)).isEmpty() && fluidstack.hasTag()) {
                CompoundNBT tag = fluidstack.getTag();
                if (tag.func_150297_b("He", 5)) {
                    return new INutritionSource.Simple(tag);
                }
                if (tag.func_150297_b("DrinkStats", 10)) {
                    return new INutritionSource.Simple(tag.func_74775_l("DrinkStats"));
                }
            }
            return this.defaultNutrition();
        }

        @Override
        public float getNNHealAmount() {
            return this._on_drunk.get().func_221466_a();
        }

        @Override
        public float getNNHealAmount(ItemStack drunk) {
            return this.getNutrition(drunk).getNNHealAmount();
        }

        @Override
        public float getNNSaturationModifier() {
            return this._on_drunk.get().func_221469_b();
        }

        @Override
        public float getNNSaturationModifier(ItemStack drunk) {
            return this.getNutrition(drunk).getNNSaturationModifier();
        }

        @Override
        public boolean isConsumable() {
            return true;
        }

        @Override
        public boolean isConsumableAlways() {
            return this._on_drunk.get().func_221468_d() || this.isConsumableAlwaysForHydration();
        }

        @Override
        public boolean isInstaConsume() {
            return this._on_drunk.get().func_221465_e();
        }

        @Override
        public long getNNCheckList(ItemStack drunk) {
            return this.getNutrition(drunk).getNNCheckList(ItemStack.field_190927_a);
        }

        @Override
        public void onDrunk(ItemStack what, LivingEntity drinker) {
            this.onDrunkImpl(what, drinker);
        }

        protected ItemStack sample() {
            return ItemStack.field_190927_a;
        }

        protected boolean playersOnly() {
            return false;
        }

        @Nonnull
        public final <T extends Food> T food() {
            return (T)this._on_drunk.get();
        }

        protected final boolean onDrunkImpl(ItemStack rep, @Nonnull LivingEntity drinker) {
            int sumfin = 0;
            if (SharedGlue.isaServerWorld((IWorldReader)drinker.func_130014_f_())) {
                PlayerEntity player = SharedGlue.getPlayerOrNull((Entity)drinker);
                if (this.playersOnly() && player == null) {
                    return false;
                }
                INutritionSource nn = this.getNutrition(rep);
                boolean kontinue = true;
                if (player != null) {
                    int nutrition = nn.getNNHealAmount() < 1.0f ? 0 : (int)nn.getNNHealAmount();
                    player.func_71024_bL().func_75122_a(nutrition, nn.getNNSaturationModifier());
                    if (nutrition > 0) {
                        ++sumfin;
                    }
                    if (!rep.func_190926_b()) {
                        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)rep.func_77973_b()));
                        ItemSupport.noteItemConsumed(player, ItemStacks.copy1(rep));
                    }
                } else if (this._heal_all) {
                    if (NPE.healIfHurt(drinker, nn.getNNHealAmount())) {
                        ++sumfin;
                    }
                } else if (SharedGlue.isaFriendlyNPE((Entity)drinker)) {
                    if (NPE.healIfHurt(drinker, nn.getNNHealAmount())) {
                        ++sumfin;
                    }
                } else {
                    kontinue = false;
                }
                if (kontinue) {
                    ITemperatureChangeable t_cap;
                    LiquidType drinkType = this.getDrinkValues();
                    if (this.cureBadPotionEffects(drinkType, drinker, rep)) {
                        ++sumfin;
                    }
                    if (player != null && ENVHelper.manageThirst() && ENVHelper.quenchThirst(player, drinkType, rep)) {
                        ++sumfin;
                    }
                    if (player != null && ENVHelper.manageTemperature() && rep.func_77973_b() instanceof ITemperatureChangeable && (t_cap = (ITemperatureChangeable)rep.func_77973_b()).getTemperatureDelivery() == ITemperatureChangeable.Category.CONSUMED && ENVHelper.applyTemperatureRelief(rep, t_cap, player)) {
                        ++sumfin;
                    }
                    if (this.applyPotionEffects(drinker, rep)) {
                        ++sumfin;
                    }
                }
            }
            return sumfin > 0;
        }

        protected boolean cureBadPotionEffects(LiquidType drinkType, LivingEntity drinker, ItemStack rep) {
            boolean tried = false;
            if (drinkType.isMilkLikeForHealing()) {
                Potions.cureBadPotionEffectsWithMilk(drinker, false, false, false);
                tried = true;
            }
            if (drinkType.isWaterLikeForCooling()) {
                Potions.cureFireBurningEffects(drinker, true);
                tried = true;
            }
            if (Potions.isCurative(drinker, rep)) {
                Potions.curePotionEffects(drinker, rep);
                tried = true;
            }
            return tried;
        }

        protected boolean applyPotionEffects(LivingEntity drinker, ItemStack rep) {
            ObjRef<FluidStack> potion_fluid;
            int sumfin = 0;
            if (!rep.func_190926_b() && this.getDrinkValues() == LiquidType.POTION && Potions.isad(rep, potion_fluid = new ObjRef<FluidStack>())) {
                if (potion_fluid.isEmpty()) {
                    Potions.addPotionEffects(drinker, rep);
                } else {
                    Potions.addPotionEffects(drinker, potion_fluid.get());
                }
                ++sumfin;
            }
            Object food = this.food();
            for (Pair bonus_def : food.func_221464_f()) {
                if (bonus_def.getFirst() == null || !(drinker.func_70681_au().nextFloat() < ((Float)bonus_def.getSecond()).floatValue())) continue;
                drinker.func_195064_c(new EffectInstance((EffectInstance)bonus_def.getFirst()));
                ++sumfin;
            }
            return sumfin > 0;
        }
    }

    public static abstract class DrinkableFluid
    extends ForgeRegistryEntry.UncheckedRegistryEntry<DrinkableFluid>
    implements IDrinkableFluid {
        protected DrinkableFluid() {
        }
    }
}

