/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;

public interface INutritionSource {
    default public float getNNHealAmount() {
        return this.getNNHealAmount(ItemStack.field_190927_a);
    }

    default public float getNNHealAmount(ItemStack source) {
        return 0.0f;
    }

    default public float getNNSaturationModifier() {
        return this.getNNSaturationModifier(ItemStack.field_190927_a);
    }

    default public float getNNSaturationModifier(ItemStack source) {
        return 0.0f;
    }

    default public long getNNCheckList(ItemStack source) {
        return source.func_190926_b() ? 0L : NutritionNote.getFrom(source);
    }

    @Nonnull
    default public Map<ResourceLocation, Float> getNNBreakdown(ItemStack source) {
        return Collections.EMPTY_MAP;
    }

    public static class Simple
    implements INutritionSource {
        public final float baseHealAmount;
        public final float baseSaturationAmount;
        public final long baseNotes;

        public Simple(float h, float s, long n) {
            this.baseHealAmount = h;
            this.baseSaturationAmount = s;
            this.baseNotes = NutritionNote.clean(n);
        }

        public Simple(@Nonnull CompoundNBT from) {
            this(from.func_74760_g("He"), from.func_74760_g("Sa"), from.func_74763_f("NN"));
        }

        public Simple(@Nonnull Food from, long notes) {
            this(from.func_221466_a(), from.func_221469_b(), notes);
        }

        public Simple(@Nonnull Food from) {
            this(from, 0L);
        }

        public CompoundNBT save(CompoundNBT to) {
            if (to == null) {
                to = new CompoundNBT();
            }
            to.func_74776_a("He", this.baseHealAmount);
            to.func_74776_a("Sa", this.baseSaturationAmount);
            to.func_74772_a("NN", this.baseNotes);
            return to;
        }

        @Override
        public final float getNNHealAmount(ItemStack unused) {
            return this.getNNHealAmount();
        }

        @Override
        public float getNNHealAmount() {
            return this.baseHealAmount;
        }

        @Override
        public final float getNNSaturationModifier(ItemStack unused) {
            return this.getNNSaturationModifier();
        }

        @Override
        public float getNNSaturationModifier() {
            return this.baseSaturationAmount;
        }

        @Override
        public long getNNCheckList(ItemStack unused) {
            return this.baseNotes;
        }
    }
}

