/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.api.NNTest;

public enum NutritionNote implements IStringSerializable,
LongSupplier,
NNTest
{
    NUTS(1L, "foods/nuts"),
    DAIRY(2L),
    SHELLFISH(4L),
    OVO(8L, "eggs"),
    SOY(16L, "foods/tofus"),
    WHEAT(32L, "crops/wheat"),
    GLUTEN(64L),
    MEAT(128L, "foods/any_meats"),
    FISH(256L),
    FRUITS("foods/fruit"),
    VEGGIES,
    CARBS,
    PROTEIN(-1L, v -> (v & 0x19EL) != 0L, "foods/any_proteins"),
    FATS,
    SWEETS,
    HI_FIBER,
    CAFFEINE("ingredients/caffeine"),
    CAFFEINE_FREE(CAFFEINE.absent()),
    HEAT,
    VEGAN(v -> (v & 0x18EL) == 0L),
    GMO,
    ORGANIC(GMO.absent()),
    UNSAFE,
    MEAT_FREE(MEAT.absent()),
    DAIRY_FREE(DAIRY.absent()),
    LACTOSE_FREE(DAIRY.absent()),
    OVO_FREE(OVO.absent()),
    GLUTEN_FREE(GLUTEN.absent().and(WHEAT.absent())),
    SEAFOOD(v -> (v & 0x104L) != 0L),
    SEAFOOD_FREE(SEAFOOD.absent()),
    ANIMAL,
    ANIMAL_FREE_LITE(ANIMAL.absent()),
    ANIMAL_STRICT,
    ANIMAL_FREE(ANIMAL_STRICT.absent()),
    HI_SUGAR,
    LO_SUGAR(HI_SUGAR.absent()),
    HI_FAT,
    LO_FAT(HI_FAT.absent()),
    HI_SALT,
    LO_SALT(HI_SALT.absent()),
    ALLERGEN_FREE(v -> (v & 0x1FFL) == 0L),
    ALLERGEN_LITE(v -> (v & 7L) == 0L),
    CAUTIOUS(LO_SUGAR.and(LO_SALT)),
    BLAND(LO_SUGAR.and(LO_SALT).and(LO_FAT).and(HEAT.absent()));

    public static final Set<NutritionNote> ALLERGENS_SET;
    public static final Set<NutritionNote> FOOD_GROUPS_SET;
    public static final Set<NutritionNote> FOOD_GROUPS_TOOLTIP_SET;
    public static final Set<NutritionNote> MISC_SET;
    public static final Set<NutritionNote> BASE_SET;
    public static final Set<NutritionNote> EXTENDED_SET;
    static final long _RESERVED = 0xFFFFFFFFFFFFFFFL;
    public static final String NBT_NNOTE;
    public static final String MEMBER_NAME = "nnotes";
    final long _bit;
    private final String _lc_name;
    private final String _i18n;
    @Nullable
    private final NNTest _rule;
    @Nullable
    private final String _tag;
    static final NutritionNote[] _VALUES;
    public static final ITag.INamedTag<Item> DISABLED_FOODGROUP_TAG;

    public static final long clean(long l) {
        return l > 0L ? l & 0xFFFFFFFFFFFFFFFL : 0L;
    }

    private NutritionNote(@Nullable long bit, NNTest rule, String main_tag) {
        this._bit = bit <= 0L ? 1L << 1 + this.ordinal() : bit;
        this._lc_name = this.name().toLowerCase(Locale.ROOT);
        this._i18n = LibInfo.lstring("nnote." + this.name());
        this._rule = rule;
        this._tag = main_tag;
    }

    private NutritionNote() {
        this(-1L, null, null);
    }

    private NutritionNote(NNTest rule) {
        this(-1L, rule, null);
    }

    private NutritionNote(long bit) {
        this(bit, null, null);
    }

    private NutritionNote(long bit, String tag) {
        this(bit, null, tag);
    }

    private NutritionNote(String tag) {
        this(-1L, null, tag);
    }

    public final long bit() {
        return this._bit;
    }

    @Override
    public final long getAsLong() {
        return this.bit();
    }

    @Override
    public final boolean pass(long value) {
        return this._rule != null ? this._rule.pass(value) : (value == 0L ? false : this.in(value));
    }

    public final long apply(long value) {
        return value & 0xFFFFFFFFFFFFFFFL | this.bit();
    }

    public final long clear(long value) {
        return value | this.bit() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public final boolean in(long value) {
        return value > 0L && (value & this.bit()) == this.bit();
    }

    public final boolean exclusive(long value) {
        return this.in(value) && this.pass(value);
    }

    public boolean in(ItemStack consumable) {
        return this.in(NutritionNote.getFrom(consumable));
    }

    public final long checked(long value) {
        if (this.in(value) && this.fail(value)) {
            value = this.clear(value);
        }
        return value;
    }

    @Nonnull
    public final String func_176610_l() {
        return this._lc_name;
    }

    public IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public final String getTranslationKey() {
        return this._i18n;
    }

    public final StringBuilder addTo(@Nullable StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(30);
        }
        if (sb.length() > 0) {
            sb.append(",");
        }
        sb.append(this.name());
        return sb;
    }

    public final boolean contains(Item item) {
        if (this._tag != null && RID.isIn(item, this._tag)) {
            return true;
        }
        return RID.isIn(item, LibInfo.rstring("nutrition/notes/" + this.func_176610_l()));
    }

    public static final long valueOf(@Nonnull NutritionNote nn, NutritionNote ... rest) {
        long mask = nn.bit();
        for (NutritionNote n : rest) {
            mask |= n.bit();
        }
        return mask;
    }

    public static final String descriptionOf(@Nonnull NutritionNote nn, NutritionNote ... rest) {
        StringBuilder sb = new StringBuilder(35);
        sb.append(nn.name());
        for (NutritionNote n : rest) {
            n.addTo(sb);
        }
        return sb.toString();
    }

    public static final boolean present(ItemStack stack) {
        return stack != null && ItemStacks.hasData(stack, NBT_NNOTE);
    }

    public static final boolean present(CompoundNBT data) {
        return data != null && data.func_74764_b(NBT_NNOTE);
    }

    public static final ItemStack addTo(ItemStack stack, String value) {
        ItemStacks.setString(stack, NBT_NNOTE, value);
        return stack;
    }

    public static final ItemStack addTo(ItemStack stack, long value) {
        ItemStacks.setLong(stack, NBT_NNOTE, value &= 0xFFFFFFFFFFFFFFFL);
        return stack;
    }

    public static final long getFrom(ItemStack stack) {
        long value = 0L;
        if (NutritionNote.present(stack)) {
            long raw = ItemStacks.hasString(stack, NBT_NNOTE) ? NutritionNote.fromList(ItemStacks.getString(stack, NBT_NNOTE), false, 0L, -1L) : ItemStacks.getLong(stack, NBT_NNOTE);
            value = NutritionNote.clean(raw);
        }
        return value;
    }

    public static final long getFor(ItemStack stack, @Nonnull Set<NutritionNote> set, boolean force, boolean check) {
        if (stack.func_190926_b()) {
            return 0L;
        }
        long value = NutritionNote.getFrom(stack);
        if (!force && NutritionNote.present(stack)) {
            return value;
        }
        Item item = stack.func_77973_b();
        for (NutritionNote nn : set) {
            if (!nn.contains(item)) continue;
            value |= nn.bit();
        }
        if (check) {
            for (NutritionNote nn : set) {
                value = nn.checked(value);
            }
        }
        return value;
    }

    @Nullable
    public static final NutritionNote fromName(String s, @Nullable NutritionNote valueIfUndefined) {
        if (!StringUtils.isEmpty((CharSequence)s)) {
            s = s.toUpperCase(Locale.ROOT);
            for (NutritionNote next : _VALUES) {
                if (!next.name().equals(s)) continue;
                return next;
            }
        }
        return valueIfUndefined;
    }

    public static final long from(@Nonnull Set<NutritionNote> set) {
        long value = 0L;
        if (set != null) {
            for (NutritionNote nn : set) {
                value = nn.apply(value);
            }
        }
        return value;
    }

    public static final long fromList(String lstring, boolean partialOk, long valueIfEmpty, long valueIfError) {
        long value = valueIfEmpty;
        if (!StringUtils.isEmpty((CharSequence)lstring)) {
            if (Strings.isAllValue(lstring = lstring.toUpperCase(Locale.ROOT), false) || Scope.ALL.name().equals(lstring)) {
                return -1L;
            }
            Scope byname = Scope.fromName(lstring);
            if (byname != null) {
                value = NutritionNote.from(byname.NOTES);
            } else {
                for (String next : StringUtils.split((String)lstring, (String)",|")) {
                    NutritionNote nn = NutritionNote.fromName(next, null);
                    if (nn == null && !partialOk) {
                        return valueIfError;
                    }
                    if (nn == null) continue;
                    value = nn.apply(value);
                }
            }
        }
        return value;
    }

    public static final String getUnformattedLine(long value) {
        if (value <= 0L) {
            return "";
        }
        StringBuilder sb = new StringBuilder(30);
        for (NutritionNote nn : _VALUES) {
            if (!nn.in(value)) continue;
            nn.addTo(sb);
        }
        return sb.toString();
    }

    @Nonnull
    public static final List<IFormattableTextComponent> getDisplayNames(long value, @Nonnull Scope set) {
        List<IFormattableTextComponent> l = Collections.emptyList();
        if (value > 0L) {
            l = new ArrayList<IFormattableTextComponent>(4);
            for (NutritionNote nn : _VALUES) {
                if (!set.NOTES.contains(nn) || !nn.in(value)) continue;
                l.add(nn.getDisplayName());
            }
        }
        return l;
    }

    @Nonnull
    public static final List<NutritionNote> toList(long value, @Nonnull Scope set) {
        List<NutritionNote> l = Collections.emptyList();
        if (value > 0L) {
            l = new ArrayList<NutritionNote>(4);
            for (NutritionNote nn : _VALUES) {
                if (!set.NOTES.contains(nn) || !nn.in(value)) continue;
                l.add(nn);
            }
        }
        return l;
    }

    @Nullable
    public static final IFormattableTextComponent getDisplayLine(long value, @Nonnull Scope set) {
        TranslationTextComponent l_nn = null;
        int n = 0;
        for (IFormattableTextComponent nn : NutritionNote.getDisplayNames(value, set)) {
            if (n++ > 0) {
                l_nn.func_230529_a_((ITextComponent)new StringTextComponent(", ").func_240699_a_(TextFormatting.GRAY));
            } else {
                l_nn = new TranslationTextComponent("carrots.tooltip.empty");
            }
            l_nn.func_230529_a_((ITextComponent)nn.func_240699_a_(set.COLOR));
        }
        return n == 0 ? null : l_nn;
    }

    static {
        ALLERGENS_SET = Collections.unmodifiableSet((Set)Util.func_200696_a((Object)Sets.newHashSetWithExpectedSize((int)19), s -> {
            s.add(NUTS);
            s.add(DAIRY);
            s.add(SHELLFISH);
            s.add(OVO);
            s.add(SOY);
            s.add(GLUTEN);
            s.add(FISH);
            s.add(WHEAT);
        }));
        FOOD_GROUPS_SET = Collections.unmodifiableSet((Set)Util.func_200696_a((Object)Sets.newHashSetWithExpectedSize((int)19), s -> {
            s.add(CARBS);
            s.add(PROTEIN);
            s.add(VEGGIES);
            s.add(FRUITS);
            s.add(FATS);
            s.add(MEAT);
            s.add(SEAFOOD);
            s.add(DAIRY);
        }));
        FOOD_GROUPS_TOOLTIP_SET = Collections.unmodifiableSet((Set)Util.func_200696_a((Object)Sets.newHashSetWithExpectedSize((int)11), s -> {
            s.add(CARBS);
            s.add(PROTEIN);
            s.add(VEGGIES);
            s.add(FRUITS);
            s.add(FATS);
        }));
        MISC_SET = Collections.unmodifiableSet((Set)Util.func_200696_a((Object)Sets.newHashSetWithExpectedSize((int)11), s -> {
            s.add(SWEETS);
            s.add(HI_FIBER);
            s.add(CAFFEINE);
            s.add(UNSAFE);
            s.add(VEGAN);
        }));
        BASE_SET = Collections.unmodifiableSet(Sets.newHashSet((Iterator)Iterators.concat(ALLERGENS_SET.iterator(), FOOD_GROUPS_SET.iterator(), MISC_SET.iterator())));
        EXTENDED_SET = Collections.unmodifiableSet((Set)Util.func_200696_a((Object)Sets.newHashSetWithExpectedSize((int)53), s -> {
            s.addAll(BASE_SET);
            s.add(ORGANIC);
            s.add(GMO);
        }));
        NBT_NNOTE = LibInfo.rstring("nnote");
        _VALUES = NutritionNote.values();
        DISABLED_FOODGROUP_TAG = RID.Tags.forItems(LibInfo.rstring("nutrition/disabled_foodgroup"));
    }

    public static enum Scope {
        NONE,
        ALLERGENS("nnote_allergen", ALLERGENS_SET, TextFormatting.DARK_RED),
        FOOD_GROUPS("nnote_fgroups", FOOD_GROUPS_SET, TextFormatting.DARK_GREEN),
        FOOD_GROUPS_TOOLTIP(FOOD_GROUPS, FOOD_GROUPS_TOOLTIP_SET),
        BASE("nnote", BASE_SET, null),
        OTHER("nnote_misc", MISC_SET, TextFormatting.DARK_BLUE),
        ALL("nnote_extended", EXTENDED_SET, null);

        @Nonnull
        public final String NBT;
        @Nonnull
        public final Set<NutritionNote> NOTES;
        @Nonnull
        public final TextFormatting COLOR;
        private final String _i18n;
        private static final Scope[] _VALUES;

        private Scope() {
            this(null, null, null);
        }

        private Scope(String nbt, Set<NutritionNote> set, TextFormatting colr) {
            this.NBT = nbt != null ? LibInfo.rstring(nbt) : "";
            this.NOTES = set != null ? set : Collections.emptySet();
            this.COLOR = colr != null ? colr : TextFormatting.GRAY;
            this._i18n = LibInfo.lstring("nnprofile." + this.name() + ".line");
        }

        private Scope(Scope same, Set<NutritionNote> set) {
            this.NBT = same.NBT;
            this.NOTES = set != null ? set : Collections.emptySet();
            this.COLOR = same.COLOR;
            this._i18n = same._i18n;
        }

        public final IFormattableTextComponent getDisplayLineFor(IFormattableTextComponent line) {
            return new TranslationTextComponent(this._i18n, new Object[]{line});
        }

        @Nullable
        public static final Scope fromName(String s) {
            for (Scope next : _VALUES) {
                if (!next.name().equals(s)) continue;
                return next;
            }
            return null;
        }

        static {
            _VALUES = Scope.values();
        }
    }
}

