/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.api.TemperatureRange;

public enum WorldSeason {
    UNKNOWN(TextFormatting.BLACK),
    EARLY_HOT(TextFormatting.YELLOW),
    HOT(TextFormatting.RED),
    EARLY_COLD(TextFormatting.DARK_AQUA),
    COLD(TextFormatting.BLUE);

    private static Map<String, WorldSeason> _VALUES;
    public static final Provider BY_BIOME_PROVIDER;
    private final String _name_lc = this.name().toLowerCase(Locale.ROOT);
    private final TextFormatting _color;

    private WorldSeason(TextFormatting c) {
        this._color = c;
    }

    public String toString() {
        return this._name_lc;
    }

    public boolean isKnown() {
        return this != UNKNOWN;
    }

    @Nonnull
    public TextFormatting getTipColor() {
        return this._color;
    }

    @Nullable
    public static final WorldSeason fromLString(String s) {
        return s != null ? _VALUES.get(s.toLowerCase(Locale.ROOT)) : null;
    }

    @Nonnull
    public static final WorldSeason fromFast(@Nonnull String s) {
        return _VALUES.getOrDefault(s, UNKNOWN);
    }

    @Nonnull
    public static final WorldSeason fromBiome(IBiomeReader worldr, BlockPos pos) {
        RegistryKey<Biome> biome = Locations.biomeKeyFor(worldr, pos);
        if (Locations.inTheNether(biome, worldr, pos)) {
            return HOT;
        }
        if (Locations.inTheEnd(biome, worldr, pos)) {
            return COLD;
        }
        if (Locations.isOverworld((IWorldReader)worldr) || Locations.isBiomeLike(biome, BiomeDictionary.Type.OVERWORLD)) {
            Biome biome_obj = Locations.biomeFor(worldr, biome);
            float t = biome_obj.func_225486_c(pos);
            TemperatureRange tempcat = TemperatureRange.match(t);
            if (tempcat == TemperatureRange.FREEZE || tempcat == TemperatureRange.COLD) {
                return COLD;
            }
            if (tempcat == TemperatureRange.WARM) {
                return HOT;
            }
            if (biome_obj.func_201850_b((IWorldReader)worldr, pos)) {
                return EARLY_HOT;
            }
            return EARLY_COLD;
        }
        if (Locations.isBiomeLike(biome, BiomeDictionary.Type.HOT)) {
            return HOT;
        }
        if (Locations.isBiomeLike(biome, BiomeDictionary.Type.COLD)) {
            return COLD;
        }
        return UNKNOWN;
    }

    static {
        _VALUES = (Map)Util.func_200696_a(new HashMap(), m -> {
            for (WorldSeason s : WorldSeason.values()) {
                m.put(s._name_lc, s);
            }
            m.put("spring", EARLY_HOT);
            m.put("early_spring", EARLY_HOT);
            m.put("mid_spring", EARLY_HOT);
            m.put("late_spring", EARLY_HOT);
            m.put("late_wet", EARLY_HOT);
            m.put("summer", HOT);
            m.put("early_summer", HOT);
            m.put("mid_summer", HOT);
            m.put("late_summer", HOT);
            m.put("dry", HOT);
            m.put("early_dry", HOT);
            m.put("mid_dry", HOT);
            m.put("late_dry", HOT);
            m.put("autumn", EARLY_COLD);
            m.put("fall", EARLY_COLD);
            m.put("early_autumn", EARLY_COLD);
            m.put("mid_autumn", EARLY_COLD);
            m.put("late_autumn", EARLY_COLD);
            m.put("early_wet", EARLY_COLD);
            m.put("winter", COLD);
            m.put("early_winter", COLD);
            m.put("mid_winter", COLD);
            m.put("late_winter", COLD);
            m.put("wet", COLD);
        });
        BY_BIOME_PROVIDER = WorldSeason::fromBiome;
    }

    public static final class ConstantSeasonProvider
    implements Provider {
        private final WorldSeason _season;

        public static final ConstantSeasonProvider of(@Nonnull WorldSeason season) {
            return new ConstantSeasonProvider(Objects.requireNonNull(season, "A season is required"));
        }

        @Override
        public WorldSeason apply(IBiomeReader worldr, BlockPos at) {
            return this._season;
        }

        private ConstantSeasonProvider(WorldSeason season) {
            this._season = season;
        }
    }

    public static interface Provider
    extends BiFunction<IBiomeReader, BlockPos, WorldSeason> {
    }
}

