/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.barter;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.barter.BarterToken;
import org.jwaresoftware.mcmods.lib.capability.QualityGrade;

public final class Bartering {
    static final AtomicBoolean _enabledFlag = new AtomicBoolean(false);
    static final ConcurrentMap<ModIntegration, Function<QualityGrade, ItemStack>> _modFactories = new ConcurrentHashMap<ModIntegration, Function<QualityGrade, ItemStack>>();
    public static final Function<QualityGrade, ItemStack> NO_TOKEN_FACTORY = qg -> ItemStack.field_190927_a;
    public static final Function<QualityGrade, ItemStack> VANILLA_1TOKEN_FACTORY = qg -> ItemStacks.create(QualityGrade.sameOrUnknown(qg).defaultBarterItem());
    public static final Function<QualityGrade, ItemStack> CARROTS_TOKENS_FACTORY = Bartering.fromTagsTokenFactory(LibInfo.MOD_ID());

    public static final Function<QualityGrade, ItemStack> fromTagsTokenFactory(@Nullable String modid, @Nullable String nmspace) {
        return qg -> {
            String rmodid;
            List<ItemStack> all;
            QualityGrade rqg = QualityGrade.sameOrUnknown(qg);
            if (rqg.isKnown() && !(all = RID.getAllInGroup((rmodid = modid != null ? modid : LibInfo.MOD_ID()) + ":barter_tokens/" + rqg.func_176610_l())).isEmpty()) {
                ItemStack out = all.get(LibInfo.nextInt(all.size()));
                if (nmspace != null) {
                    ItemStacks.setString(out, "barter:modid", nmspace);
                }
                return out;
            }
            return ItemStack.field_190927_a;
        };
    }

    public static final Function<QualityGrade, ItemStack> fromTagsTokenFactory(@Nullable String modid) {
        return Bartering.fromTagsTokenFactory(modid, null);
    }

    private static final boolean isLib(ModIntegration modid) {
        return modid == null || modid == ModIntegration.CARROTS_LIB;
    }

    private static final boolean isReserved(ModIntegration modid) {
        return Bartering.isLib(modid) || modid == ModIntegration.MINECRAFT || modid == ModIntegration.FORGE_LIB;
    }

    public static final boolean isEnabled() {
        return _enabledFlag.get();
    }

    public static final void setEnabled(boolean enabled) {
        if (_enabledFlag.compareAndSet(!enabled, enabled)) {
            if (enabled) {
                _modFactories.put(ModIntegration.MINECRAFT, Bartering.fromTagsTokenFactory(ModIntegration.MINECRAFT.modid()));
                _modFactories.put(ModIntegration.FORGE_LIB, Bartering.fromTagsTokenFactory(ModIntegration.FORGE_LIB.modid()));
            } else {
                _modFactories.remove((Object)ModIntegration.MINECRAFT);
                _modFactories.remove((Object)ModIntegration.FORGE_LIB);
            }
        }
    }

    public static final boolean isEnabled(@Nullable ModIntegration modid) {
        return Bartering.isReserved(modid) ? Bartering.isEnabled() : _modFactories.containsKey((Object)modid);
    }

    @Nonnull
    public static final Function<QualityGrade, ItemStack> getTokenFactory() {
        return _enabledFlag.get() ? CARROTS_TOKENS_FACTORY : VANILLA_1TOKEN_FACTORY;
    }

    @Nonnull
    public static final Function<QualityGrade, ItemStack> getTokenFactory(ModIntegration modid) {
        return Bartering.isLib(modid) ? Bartering.getTokenFactory() : _modFactories.getOrDefault((Object)modid, NO_TOKEN_FACTORY);
    }

    public static final void setTokenFactory(ModIntegration modid, @Nonnull Function<QualityGrade, ItemStack> factory) {
        if (!Bartering.isReserved(modid)) {
            _modFactories.put(modid, Objects.requireNonNull(factory));
        }
    }

    public static final void setTokenFactory(ModIntegration modid) {
        if (!Bartering.isReserved(modid)) {
            _modFactories.put(modid, Bartering.fromTagsTokenFactory(modid.modid()));
        }
    }

    public static final void makeTokens() {
        for (QualityGrade qg : QualityGrade.values()) {
            if (!qg.isKnown()) continue;
            BarterToken token = new BarterToken("barter_token_" + qg.func_176610_l(), qg, true);
            token.setDefaultExchangeRate(qg.isEqualOrBetter(QualityGrade.GOLD) ? 100 : 200);
            if (!qg.isEqualOrBetter(QualityGrade.EXCELLENT)) {
                BarterToken._LOOTABLES.add(token);
            }
            IniRegistries.autoregisterItem(LibInfo.MOD_ID(), token, LibInfo.rstring(token.oid()));
        }
    }
}

